/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.company.entity.CompanyExtend;
import com.els.base.company.entity.CompanyExtendExample;
import com.els.base.company.service.CompanyExtendService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f01\u4e1a\u4fe1\u606f\u6269\u5c55\u8868")
@Controller
@RequestMapping(value={"companyExtend"})
public class CompanyExtendController {
    @Resource
    protected CompanyExtendService companyExtendService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f01\u4e1a\u4fe1\u606f\u6269\u5c55\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyExtend companyExtend) {
        Assert.isNotNull(companyExtend, "\u4fdd\u5b58\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        companyExtend.setCompanyId(CompanyUtils.currentCompanyId());
        companyExtend.setCompanySrmCode(CompanyUtils.currentCompany().getCompanyCode());
        this.companyExtendService.addObj(companyExtend);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f01\u4e1a\u4fe1\u606f\u6269\u5c55\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyExtend companyExtend) {
        Assert.isNotBlank(companyExtend.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.companyExtendService.modifyObj(companyExtend);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f01\u4e1a\u4fe1\u606f\u6269\u5c55\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.companyExtendService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f\u6269\u5c55\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyExtend", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyExtend>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyExtendExample example = new CompanyExtendExample();
        example.setPageView(new PageView<CompanyExtend>(pageNo, pageSize));
        CompanyExtendExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.companyExtendService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u6269\u5c55\u8868\u7684\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/findCompanyExtend"})
    @ResponseBody
    public ResponseResult<CompanyExtend> findCompanyExtend(@RequestParam(required=false) String supCompanySrmCode) {
        CompanyExtend companyExtend = null;
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            supCompanySrmCode = CompanyUtils.currentCompany().getCompanyCode();
        }
        CompanyExtendExample example = new CompanyExtendExample();
        example.createCriteria().andCompanySrmCodeEqualTo(supCompanySrmCode);
        List list = this.companyExtendService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            companyExtend = (CompanyExtend)list.get(0);
        }
        return ResponseResult.success(companyExtend);
    }
}

