/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.dao.FaiBorrowMapper;
import com.els.base.material.entity.FaiBorrow;
import com.els.base.material.entity.FaiBorrowExample;
import com.els.base.material.entity.MaterialSupplier;
import com.els.base.material.service.FaiBorrowService;
import com.els.base.material.service.MaterialSupplierService;
import com.els.base.material.utils.BorrowBillStatus;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultFaiBorrowService")
public class FaiBorrowServiceImpl
implements FaiBorrowService,
ITaskListener {
    @Resource
    protected FaiBorrowMapper faiBorrowMapper;
    @Resource
    protected WorkFlowService workFlowService;
    @Resource
    protected MaterialSupplierService materialSupplierService;
    Logger logger = LoggerFactory.getLogger(FaiBorrowServiceImpl.class);

    @Override
    @CacheEvict(value={"faiBorrow"}, allEntries=true)
    public void addObj(FaiBorrow t) {
        this.faiBorrowMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"faiBorrow"}, allEntries=true)
    public void addAll(List<FaiBorrow> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.faiBorrowMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"faiBorrow"}, allEntries=true)
    public void deleteObjById(String id) {
        this.faiBorrowMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"faiBorrow"}, allEntries=true)
    public void deleteByExample(FaiBorrowExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.faiBorrowMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"faiBorrow"}, allEntries=true)
    public void modifyObj(FaiBorrow t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.faiBorrowMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"faiBorrow"}, keyGenerator="redisKeyGenerator")
    public FaiBorrow queryObjById(String id) {
        return this.faiBorrowMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"faiBorrow"}, keyGenerator="redisKeyGenerator")
    public List<FaiBorrow> queryAllObjByExample(FaiBorrowExample example) {
        return this.faiBorrowMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"faiBorrow"}, keyGenerator="redisKeyGenerator")
    public PageView<FaiBorrow> queryObjByPage(FaiBorrowExample example) {
        PageView<FaiBorrow> pageView = example.getPageView();
        pageView.setQueryResult(this.faiBorrowMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"faiBorrow"}, allEntries=true)
    public void sendToSing(String id) {
        FaiBorrow faiBorrow = this.queryObjById(id);
        if (faiBorrow == null) {
            throw new CommonException("\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e!");
        }
        if (!faiBorrow.getBillStatus().equals(BorrowBillStatus.NEW.getValue()) && !faiBorrow.getBillStatus().equals(BorrowBillStatus.REFUSED.getValue())) {
            throw new CommonException("\u53ea\u6709\u65b0\u589e\u3001\u5ba1\u6279\u62d2\u7edd\u7684\u5355\u636e\u624d\u53ef\u4ee5\u9001\u7b7e!");
        }
        String wkflowcode = "";
        wkflowcode = "1".equals(faiBorrow.getFaitype()) ? "FAI-CONFIRM" : "FAI-CHECKUP";
        ProcessStartVO vo = ProcessStartVO.newInstance(wkflowcode, faiBorrow.getBillNo(), faiBorrow.getId(), "firstBorrow?id=" + faiBorrow.getId());
        vo.setListenerClass(this.getClass());
        ProcessInstance startProcess = this.workFlowService.startProcess(vo);
        if (startProcess != null) {
            faiBorrow.setBillStatus(BorrowBillStatus.APPROVING.getValue());
            faiBorrow.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            faiBorrow.setUpdateUserName(SpringSecurityUtils.getLoginUser().getNickName());
            faiBorrow.setUpdateTime(new Date());
            this.modifyObj(faiBorrow);
        }
    }

    @Override
    @CacheEvict(value={"faiBorrow"}, allEntries=true)
    public void listen(TaskOperateEvent event) {
        if (event == null) {
            return;
        }
        String businessId = event.getBusinessId();
        if (StringUtils.isBlank((String)businessId)) {
            return;
        }
        FaiBorrow faiBorrow = this.queryObjById(businessId);
        String assignee = StringUtils.defaultIfBlank((String)event.getAssignee(), (String)"");
        String fullMessage = StringUtils.defaultIfBlank((String)event.getApproveDesc(), (String)"");
        String result = "\u5ba1\u6279\u4eba\uff1a" + assignee + "\uff0c\u5ba1\u6279\u610f\u89c1\uff1a" + fullMessage + " ; ";
        this.logger.info(result);
        if (event.isFinished() && event.isPass()) {
            this.logger.info("\u5ba1\u6279\u6d41\u5b8c\u6210\u800c\u4e14\u901a\u8fc7");
            faiBorrow.setBillStatus(BorrowBillStatus.APPROVED.getValue());
            faiBorrow.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            faiBorrow.setUpdateUserName(SpringSecurityUtils.getLoginUser().getNickName());
            faiBorrow.setUpdateTime(new Date());
            faiBorrow.setAttribute1(result);
            this.modifyObj(faiBorrow);
            MaterialSupplier MaterialSupplierBorrow = (MaterialSupplier)this.materialSupplierService.queryObjById(faiBorrow.getBorrowId());
            MaterialSupplier materialSupplier = new MaterialSupplier();
            BeanUtils.copyProperties((Object)materialSupplier, (Object)MaterialSupplierBorrow);
            materialSupplier.setFaisource("2");
            materialSupplier.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            materialSupplier.setUpdateUserName(SpringSecurityUtils.getLoginUser().getNickName());
            materialSupplier.setUpdateTime(new Date());
            materialSupplier.setMaterialCode(faiBorrow.getMaterialCode());
            materialSupplier.setMaterialName(faiBorrow.getMaterialName());
            materialSupplier.setSourceMaterialCode(MaterialSupplierBorrow.getMaterialCode());
            materialSupplier.setSourceMaterialName(MaterialSupplierBorrow.getMaterialName());
            materialSupplier.setSourceAttachment(MaterialSupplierBorrow.getAttachment());
            materialSupplier.setFai("Y");
            this.materialSupplierService.addObj(materialSupplier);
        } else if (event.isFinished() && !event.isPass()) {
            faiBorrow.setBillStatus(BorrowBillStatus.REFUSED.getValue());
            faiBorrow.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            faiBorrow.setUpdateUserName(SpringSecurityUtils.getLoginUser().getNickName());
            faiBorrow.setUpdateTime(new Date());
            this.modifyObj(faiBorrow);
        }
    }
}

