/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.material.dao.MaterialMapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialCategoryExample;
import com.els.base.material.entity.MaterialCategoryMapImportEntity;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialPropKey;
import com.els.base.material.entity.MaterialPropKeyGroup;
import com.els.base.material.entity.MaterialPropValue;
import com.els.base.material.entity.MaterialPropValueExample;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.service.MaterialPropValueService;
import com.els.base.material.service.MaterialService;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialService")
public class MaterialServiceImpl
implements MaterialService {
    @Resource
    protected MaterialMapper materialMapper;
    @Resource
    protected MaterialCategoryService materialCategoryService;
    @Resource
    protected MaterialPropValueService materialPropValueService;
    @Resource
    protected CompanyService companyService;

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(Material record, MaterialExample example) {
        Assert.isNotNull(record);
        Assert.isNotEmpty(example.getOredCriteria(), "\u4e0d\u80fd\u5168\u8868\u66f4\u65b0");
        return this.materialMapper.updateByExampleSelective(record, example);
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public void addObj(Material t) {
        if (StringUtils.isBlank((String)t.getCategoryId())) {
            throw new NullPointerException("\u7269\u6599\u5206\u7c7bId\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58");
        }
        MaterialCategory materialCategory = (MaterialCategory)this.materialCategoryService.queryObjById(t.getCategoryId());
        if (materialCategory == null) {
            throw new CommonException("\u7269\u6599\u5206\u7c7b '" + t.getCategoryId() + "' \u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58", "do_not_exists", "\u7269\u6599\u5206\u7c7b ");
        }
        t.setCategoryName(materialCategory.getCategoryName());
        MaterialExample materialExample = new MaterialExample();
        MaterialExample.Criteria materialExampleCriteria = materialExample.createCriteria();
        materialExampleCriteria.andProjectIdEqualTo(t.getProjectId());
        materialExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
        materialExampleCriteria.andMaterialCodeEqualTo(t.getMaterialCode());
        int count = this.materialMapper.countByExample(materialExample);
        if (count > 0) {
            throw new CommonException("\u7269\u6599\u7f16\u53f7 '" + t.getMaterialCode() + "' \u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58", "base_is_exists", "\u7269\u6599MaterialCode");
        }
        this.materialMapper.insertSelective(t);
        MaterialPropValueExample materialPropValueExample = new MaterialPropValueExample();
        MaterialPropValueExample.Criteria materialPropValueExampleCriteria = materialPropValueExample.createCriteria();
        materialPropValueExampleCriteria.andProjectIdEqualTo(t.getProjectId());
        materialPropValueExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
        materialPropValueExampleCriteria.andMaterialIdEqualTo(t.getId());
        this.materialPropValueService.deleteByExample(materialPropValueExample);
        List<MaterialPropKeyGroup> materialPropKeyGroupList = t.getMaterialPropKeyGroupList();
        if (CollectionUtils.isNotEmpty(materialPropKeyGroupList)) {
            for (MaterialPropKeyGroup materialPropKeyGroup : materialPropKeyGroupList) {
                List<MaterialPropKey> materialPropKeyList = materialPropKeyGroup.getMaterialPropKeyList();
                if (!CollectionUtils.isNotEmpty(materialPropKeyList)) continue;
                for (MaterialPropKey materialPropKey : materialPropKeyList) {
                    MaterialPropValue materialPropValue = new MaterialPropValue();
                    materialPropValue.setProjectId(t.getProjectId());
                    materialPropValue.setCompanyId(t.getCompanyId());
                    materialPropValue.setMaterialId(t.getId());
                    materialPropValue.setPropKeyId(materialPropKey.getId());
                    materialPropValue.setPropKey(materialPropKey.getPropKey());
                    materialPropValue.setPropValue(materialPropKey.getPropValue());
                    materialPropValue.setPropKeyGroupId(materialPropKeyGroup.getId());
                    this.materialPropValueService.addObj(materialPropValue);
                }
            }
        }
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public void modifyObj(Material t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        Material material = this.materialMapper.selectByPrimaryKey(t.getId());
        if (material == null) {
            throw new CommonException("\u8be5\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0", "do_not_exists", "\u8be5\u7269\u6599");
        }
        MaterialCategory materialCategory = (MaterialCategory)this.materialCategoryService.queryObjById(t.getCategoryId());
        if (materialCategory == null) {
            throw new CommonException("\u8be5\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58", "do_not_exists", "\u8be5\u7269\u6599");
        }
        t.setProjectId(t.getProjectId());
        t.setCompanyId(t.getCompanyId());
        t.setCategoryName(materialCategory.getCategoryName());
        t.setCreateUserId(t.getCreateUserId());
        t.setCreateUserName(t.getCreateUserName());
        MaterialExample materialExample = new MaterialExample();
        MaterialExample.Criteria materialExampleCriteria = materialExample.createCriteria();
        materialExampleCriteria.andProjectIdEqualTo(t.getProjectId());
        materialExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
        materialExampleCriteria.andMaterialCodeEqualTo(t.getMaterialCode());
        if (material.getMaterialCode().equals(t.getMaterialCode())) {
            this.materialMapper.updateByPrimaryKeySelective(t);
        } else {
            if (this.materialMapper.countByExample(materialExample) > 0) {
                throw new CommonException("\u7269\u6599MaterialCode '" + t.getMaterialCode() + "' \u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0", "base_is_exists", "\u7269\u6599MaterialCode");
            }
            this.materialMapper.updateByPrimaryKeySelective(t);
        }
        MaterialPropValueExample materialPropValueExample = new MaterialPropValueExample();
        MaterialPropValueExample.Criteria materialPropValueExampleCriteria = materialPropValueExample.createCriteria();
        materialPropValueExampleCriteria.andProjectIdEqualTo(t.getProjectId());
        materialPropValueExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
        materialPropValueExampleCriteria.andMaterialIdEqualTo(t.getId());
        this.materialPropValueService.deleteByExample(materialPropValueExample);
        List<MaterialPropKeyGroup> materialPropKeyGroupList = t.getMaterialPropKeyGroupList();
        if (CollectionUtils.isNotEmpty(materialPropKeyGroupList)) {
            for (MaterialPropKeyGroup materialPropKeyGroup : materialPropKeyGroupList) {
                List<MaterialPropKey> materialPropKeyList = materialPropKeyGroup.getMaterialPropKeyList();
                if (!CollectionUtils.isNotEmpty(materialPropKeyList)) continue;
                for (MaterialPropKey materialPropKey : materialPropKeyList) {
                    MaterialPropValue materialPropValue = new MaterialPropValue();
                    materialPropValue.setProjectId(t.getProjectId());
                    materialPropValue.setCompanyId(t.getCompanyId());
                    materialPropValue.setMaterialId(t.getId());
                    materialPropValue.setPropKeyId(materialPropKey.getId());
                    materialPropValue.setPropKey(materialPropKey.getPropKey());
                    materialPropValue.setPropValue(materialPropKey.getPropValue());
                    materialPropValue.setPropKeyGroupId(materialPropKeyGroup.getId());
                    this.materialPropValueService.addObj(materialPropValue);
                }
            }
        }
    }

    @Override
    public Material queryObjById(String id) {
        return this.materialMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public List<Material> queryAllObjByExample(MaterialExample example) {
        return this.materialMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public PageView<Material> queryObjByPage(MaterialExample example) {
        PageView<Material> pageView = example.getPageView();
        pageView.setQueryResult(this.materialMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public PageView<Material> queryMaterialByPage(MaterialExample example) {
        PageView<Material> pageView = example.getPageView();
        pageView.setQueryResult(this.materialMapper.selectDistinctByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public int isEnable(String materialId, Integer isEnable) {
        Material material = new Material();
        material.setId(materialId);
        material.setIsEnable(isEnable);
        return this.materialMapper.updateByPrimaryKeySelective(material);
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    public void importMaterial(List<Material> materials) {
        if (materials == null) {
            throw new IllegalArgumentException("parameter materials is null");
        }
        for (Material material : materials) {
            String projectId = material.getProjectId();
            String companyId = material.getCompanyId();
            String materialCode = material.getMaterialCode();
            MaterialExample materialExample = new MaterialExample();
            MaterialExample.Criteria criteria = materialExample.createCriteria();
            criteria.andProjectIdEqualTo(projectId).andCompanyIdEqualTo(companyId).andMaterialCodeEqualTo(materialCode);
            int count = this.materialMapper.countByExample(materialExample);
            if (count > 0) {
                this.materialMapper.updateByExampleSelective(material, materialExample);
                continue;
            }
            this.materialMapper.insertSelective(material);
        }
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    public int importMaterialFromMDM(List<Material> materials, StringBuilder builder) {
        if (materials == null) {
            throw new IllegalArgumentException("parameter materials is null");
        }
        builder.append("\u63a5\u6536\u5230\u7269\u6599\u6570\u636e" + materials.size() + "\u6761").append("\r\n");
        int errorcout = 0;
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List companyList = this.companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            Company c = (Company)companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        builder.append("\u5f00\u59cb\u5904\u7406\u6570\u636e").append("\r\n");
        for (Material material : materials) {
            try {
                String materialCode = material.getMaterialCode();
                MaterialExample materialExample = new MaterialExample();
                MaterialExample.Criteria criteria = materialExample.createCriteria();
                criteria.andProjectIdEqualTo(projectId).andCompanyIdEqualTo(companyId).andMaterialCodeEqualTo(materialCode).andFactoryNameEqualTo(material.getFactoryName());
                int count = this.materialMapper.countByExample(materialExample);
                if (count > 0) {
                    Material materialOld = this.materialMapper.selectByExample(materialExample).get(0);
                    criteria.andIdEqualTo(materialOld.getId());
                    material.setAutomaticDetection(materialOld.getAutomaticDetection());
                    material.setUpdateTime(new Date());
                    material.setSapUpdateTime(new Date());
                    this.materialMapper.updateByExampleSelective(material, materialExample);
                } else {
                    material.setProjectId(projectId);
                    material.setCompanyId(companyId);
                    material.setCreateTime(new Date());
                    material.setCreateUserId("Webservice");
                    material.setCreateUserName("Webservice");
                    material.setUpdateTime(new Date());
                    material.setSapUpdateTime(new Date());
                    this.materialMapper.insertSelective(material);
                }
            }
            catch (Exception e) {
                ++errorcout;
                builder.append("\u7269\u6599\u4ee3\u7801:" + material.getMaterialCode() + "\u5de5\u5382\u4ee3\u7801:" + material.getFactoryName() + "\u4fdd\u5b58\u5931\u8d25").append("\r\n");
                try {
                    builder.append("\u7269\u6599\u4fe1\u606f").append("\r\n");
                    builder.append(JsonUtils.writeValueAsString((Object)material)).append("\r\n");
                }
                catch (JsonProcessingException e1) {
                    e1.printStackTrace();
                }
                builder.append("\u9519\u8bef\u539f\u56e0:" + e.getMessage()).append("\r\n");
            }
            builder.append("\u5904\u7406\u6210\u529f\u6761\u6570 " + (materials.size() - errorcout) + "\u6761").append("\r\n");
            builder.append("\u5904\u7406\u5931\u8d25\u6761\u6570 " + errorcout + "\u6761").append("\r\n");
            builder.append("\u6570\u636e\u5904\u7406\u5b8c\u6210").append("\r\n");
        }
        return errorcout;
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    public void importMaterialFromExcel(List<Material> materials) {
        if (materials == null) {
            throw new IllegalArgumentException("parameter materials is null");
        }
        for (Material material : materials) {
            String projectId = ProjectUtils.getProjectId();
            String companyId = ProjectUtils.getCompanyId();
            String materialCode = material.getMaterialCode();
            String factoyName = material.getFactoryName();
            MaterialExample materialExample = new MaterialExample();
            MaterialExample.Criteria criteria = materialExample.createCriteria();
            criteria.andProjectIdEqualTo(projectId).andCompanyIdEqualTo(companyId).andMaterialCodeEqualTo(materialCode).andFactoryNameEqualTo(factoyName);
            int count = this.materialMapper.countByExample(materialExample);
            if (count > 0) {
                material.setUpdateTime(new Date());
                material.setSapUpdateTime(new Date());
                this.materialMapper.updateByExampleSelective(material, materialExample);
                continue;
            }
            material.setCompanyId(companyId);
            material.setProjectId(projectId);
            material.setCreateTime(new Date());
            material.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            material.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            material.setUpdateTime(new Date());
            material.setSapUpdateTime(new Date());
            this.materialMapper.insertSelective(material);
        }
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    public void importMaterialAutomaticDetection(List<Material> materials) {
        if (materials == null) {
            throw new IllegalArgumentException("parameter materials is null");
        }
        for (Material material : materials) {
            String projectId = ProjectUtils.getProjectId();
            String companyId = ProjectUtils.getCompanyId();
            String materialCode = material.getMaterialCode();
            String factoyName = material.getFactoryName();
            if (!"2100".equals(factoyName) && !"2200".equals(factoyName)) {
                throw new CommonException("\u5de5\u5382\u53ea\u80fd\u8f93\u51652100\u30012200");
            }
            if (!"Y".equals(material.getAutomaticDetection()) && !"N".equals(material.getAutomaticDetection())) {
                throw new CommonException("\u662f\u5426\u81ea\u52a8\u68c0\u6d4b(Y/N) \u53ea\u80fd\u8f93\u5165 Y\u6216\u8005N");
            }
            MaterialExample materialExample = new MaterialExample();
            MaterialExample.Criteria criteria = materialExample.createCriteria();
            criteria.andProjectIdEqualTo(projectId).andCompanyIdEqualTo(companyId).andMaterialCodeEqualTo(materialCode).andFactoryNameEqualTo(factoyName);
            int count = this.materialMapper.countByExample(materialExample);
            if (count > 0) {
                material.setUpdateTime(new Date());
                material.setSapUpdateTime(new Date());
                this.materialMapper.updateByExampleSelective(material, materialExample);
                continue;
            }
            material.setCompanyId(companyId);
            material.setProjectId(projectId);
            material.setCreateTime(new Date());
            material.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            material.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            material.setUpdateTime(new Date());
            material.setSapUpdateTime(new Date());
            this.materialMapper.insertSelective(material);
        }
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    public void importMaterialMapFromTxt(List<MaterialCategoryMapImportEntity> materialMaps) {
        if (materialMaps == null) {
            throw new IllegalArgumentException("parameter materials is null");
        }
        String projectId = ProjectUtils.getProjectId();
        String companyId = ProjectUtils.getCompanyId();
        for (MaterialCategoryMapImportEntity materialMap : materialMaps) {
            String materialCode = materialMap.getMaterialCode();
            String factoyName = materialMap.getFactoryName();
            if (!"2100".equals(factoyName) && !"2200".equals(factoyName)) {
                throw new CommonException("\u7269\u6599\u4ee3\u7801\uff1a" + materialCode + "\u5de5\u5382\u53ea\u80fd\u8f93\u51652100\u30012200");
            }
            String categoryCode = materialMap.getCategoryCode();
            MaterialExample materialExample = new MaterialExample();
            MaterialExample.Criteria criteria = materialExample.createCriteria();
            criteria.andProjectIdEqualTo(projectId).andCompanyIdEqualTo(companyId).andMaterialCodeEqualTo(materialCode).andFactoryNameEqualTo(factoyName);
            int count = this.materialMapper.countByExample(materialExample);
            if (count > 0) {
                MaterialCategoryExample example = new MaterialCategoryExample();
                example.createCriteria().andProjectIdEqualTo(projectId).andIsEnableEqualTo(Constant.YES_INT).andCategoryCodeEqualTo(materialMap.getCategoryCode());
                List materialCategoryList = this.materialCategoryService.queryAllObjByExample(example);
                if (CollectionUtils.isEmpty(materialCategoryList)) {
                    throw new CommonException("\u7269\u6599\u5206\u7c7b\u4ee3\u7801\u4e3a" + categoryCode + "\u7684\u7269\u6599\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58", "do_not_exists");
                }
                MaterialCategory materialCategory = (MaterialCategory)materialCategoryList.get(0);
                Material material = new Material();
                material.setCategoryId(materialCategory.getId());
                material.setCategoryName(materialCategory.getCategoryName());
                material.setUpdateTime(new Date());
                material.setSapUpdateTime(new Date());
                this.materialMapper.updateByExampleSelective(material, materialExample);
                continue;
            }
            throw new CommonException("\u7269\u6599\u4ee3\u7801\u4e3a" + materialCode + ",\u5de5\u5382\u4e3a:" + factoyName + "\u7684\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58", "do_not_exists");
        }
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public Boolean isExists(String materialCode) {
        if (StringUtils.isBlank((String)materialCode)) {
            throw new IllegalArgumentException("parameter materialCode is null");
        }
        MaterialExample materialExample = new MaterialExample();
        MaterialExample.Criteria criteria = materialExample.createCriteria();
        criteria.andMaterialCodeEqualTo(materialCode);
        int count = this.materialMapper.countByExample(materialExample);
        if (count > 0) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isJTL(String materialCode) {
        if (StringUtils.isEmpty((String)materialCode)) {
            throw new CommonException("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MaterialExample materialExample = new MaterialExample();
        materialExample.createCriteria().andMaterialCodeEqualTo(materialCode).andLogProGroupEqualTo("L003");
        int count = this.materialMapper.countByExample(materialExample);
        return count != 0;
    }

    @Override
    public List<String> selectMaterialCode() {
        return this.materialMapper.selectDistinctMaterialCode(SpringSecurityUtils.getLoginUserId());
    }
}

