/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.dao.MaterialSupplierMapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialCategoryExample;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialSupplier;
import com.els.base.material.entity.MaterialSupplierExample;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.service.MaterialService;
import com.els.base.material.service.MaterialSupplierService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMaterialSupplierService")
public class MaterialSupplierServiceImpl
implements MaterialSupplierService {
    @Resource
    protected MaterialSupplierMapper materialSupplierMapper;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MaterialCategoryService materialCategoryService;
    @Resource
    protected CompanyService companyService;

    @Override
    @CacheEvict(value={"materialSupplier"}, allEntries=true)
    public void addObj(MaterialSupplier t) {
        this.materialSupplierMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"materialSupplier"}, allEntries=true)
    public void addObj(Project project, Company company, MaterialSupplier materialSupplier) {
        if (StringUtils.isEmpty((String)materialSupplier.getMaterialCode())) {
            throw new CommonException("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u65b0\u589e!");
        }
        if (StringUtils.isEmpty((String)materialSupplier.getSupCompanySapCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u65b0\u589e!");
        }
        if (materialSupplier.getFaiPlanStartTime() == null) {
            throw new CommonException("fai\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (materialSupplier.getFaiPlanEndTime() == null) {
            throw new CommonException("fai\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        materialSupplier.setProjectId(project.getId());
        materialSupplier.setCompanyId(company.getId());
        MaterialExample example = new MaterialExample();
        MaterialExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(project.getId()).andCompanyIdEqualTo(company.getId()).andMaterialCodeEqualTo(materialSupplier.getMaterialCode()).andIsEnableEqualTo(Constant.YES_INT);
        List MaterialArray = this.materialService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(MaterialArray)) {
            throw new CommonException("\u7269\u6599\u7f16\u7801\u4e3a" + materialSupplier.getMaterialCode() + "\u7684\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u5165!");
        }
        Material material = (Material)MaterialArray.get(0);
        materialSupplier.setMaterialCode(material.getMaterialCode());
        materialSupplier.setMaterialId(material.getId());
        materialSupplier.setMaterialName(material.getMaterialName());
        if (StringUtils.isEmpty((String)materialSupplier.getPackRemark())) {
            materialSupplier.setPackRemark(material.getPackRemark());
        }
        if (StringUtils.isEmpty((String)materialSupplier.getMinPackSpce())) {
            materialSupplier.setMinPackSpce(material.getMinPackSpce());
        }
        if (StringUtils.isEmpty((String)materialSupplier.getStandPackQuantity())) {
            materialSupplier.setStandPackQuantity(material.getStandPackQuantity());
        }
        if (StringUtils.isEmpty((String)materialSupplier.getStandPackSpce())) {
            materialSupplier.setStandPackSpce(material.getStandPackSpce());
        }
        if (StringUtils.isEmpty((String)materialSupplier.getMaterialOutSize())) {
            materialSupplier.setMaterialOutSize(material.getMaterialOutSize());
        }
        if (StringUtils.isEmpty((String)material.getCategoryId())) {
            throw new CommonException("\u7269\u6599\u7f16\u7801\u4e3a" + materialSupplier.getMaterialCode() + "\u7684\u6ca1\u6709\u7ef4\u62a4\u7269\u6599\u5206\u7c7b\uff0c\u65e0\u6cd5\u65b0\u589e!");
        }
        CompanyExample companyExample = new CompanyExample();
        CompanyExample.Criteria companyExamplecriteria = companyExample.createCriteria();
        companyExamplecriteria.andProjectIdEqualTo(project.getId()).andCompanySapCodeEqualTo(materialSupplier.getSupCompanySapCode());
        List<Company> CompanyArray = this.companyService.queryAllSupplerCompanies(company.getId(), companyExample);
        if (CollectionUtils.isEmpty(CompanyArray)) {
            throw new CommonException("\u4f9b\u5e94\u5546\u4ee3\u7801\u4e3a" + materialSupplier.getSupCompanySapCode() + "\u7684\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e!");
        }
        MaterialCategoryExample materialCategoryExample = new MaterialCategoryExample();
        MaterialCategoryExample.Criteria materialCategorycriteria = materialCategoryExample.createCriteria();
        materialCategorycriteria.andProjectIdEqualTo(project.getId()).andCompanyIdEqualTo(company.getId()).andIdEqualTo(material.getCategoryId());
        List materialCategoryArray = this.materialCategoryService.queryAllObjByExample(materialCategoryExample);
        if (CollectionUtils.isNotEmpty(materialCategoryArray)) {
            MaterialCategory materialCategory = (MaterialCategory)this.materialCategoryService.queryAllObjByExample(materialCategoryExample).get(0);
            materialSupplier.setCategoryCode(materialCategory.getCategoryCode());
            materialSupplier.setCategoryId(materialCategory.getId());
            materialSupplier.setCategoryName(materialCategory.getCategoryName());
        }
        if (!"Y".equals(materialSupplier.getFai()) && !"N".equals(materialSupplier.getFai())) {
            throw new CommonException("FAI\u6807\u8bc6(Y/N) \u53ea\u80fd\u8f93\u5165 Y\u6216\u8005N");
        }
        if (!"Y".equals(materialSupplier.getSample()) && !"N".equals(materialSupplier.getSample())) {
            throw new CommonException("\u6837\u54c1(Y/N) \u53ea\u80fd\u8f93\u5165 Y\u6216\u8005N");
        }
        Date nowDate = new Date();
        Company supCompany = CompanyArray.get(0);
        materialSupplier.setSupCompanyId(supCompany.getId());
        materialSupplier.setSupCompanyCode(supCompany.getCompanyCode());
        materialSupplier.setSupCompanySapCode(supCompany.getCompanySapCode());
        materialSupplier.setSupCompanyName(supCompany.getCompanyName());
        materialSupplier.setSupCompanyFullName(supCompany.getCompanyFullName());
        materialSupplier.setUpdateTime(nowDate);
        materialSupplier.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        materialSupplier.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        materialSupplier.setCreateTime(nowDate);
        materialSupplier.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        materialSupplier.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        if (this.isExists(materialSupplier.getMaterialCode(), materialSupplier.getSupCompanySapCode()).booleanValue()) {
            MaterialSupplierExample materialSupplierexample = new MaterialSupplierExample();
            MaterialSupplierExample.Criteria materialSuppliercriteria = materialSupplierexample.createCriteria();
            materialSuppliercriteria.andMaterialCodeEqualTo(materialSupplier.getMaterialCode()).andSupCompanySapCodeEqualTo(materialSupplier.getSupCompanySapCode());
            MaterialSupplier materialSupplierOld = this.queryAllObjByExample(materialSupplierexample).get(0);
            materialSupplier.setId(materialSupplierOld.getId());
            this.materialSupplierMapper.updateByPrimaryKeySelective(materialSupplier);
        } else {
            materialSupplier.setCreateTime(nowDate);
            materialSupplier.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            materialSupplier.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            this.materialSupplierMapper.insertSelective(materialSupplier);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"materialSupplier"}, allEntries=true)
    public void addAll(List<MaterialSupplier> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.materialSupplierMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"materialSupplier"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialSupplierMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"materialSupplier"}, allEntries=true)
    public void deleteByExample(MaterialSupplierExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialSupplierMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"materialSupplier"}, allEntries=true)
    public void deleteObjByIdArray(List<String> idList) {
        for (String id : idList) {
            this.deleteObjById(id);
        }
    }

    @Override
    @CacheEvict(value={"materialSupplier"}, allEntries=true)
    public void modifyObj(MaterialSupplier t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialSupplierMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"materialSupplier"}, keyGenerator="redisKeyGenerator")
    public MaterialSupplier queryObjById(String id) {
        return this.materialSupplierMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"materialSupplier"}, keyGenerator="redisKeyGenerator")
    public List<MaterialSupplier> queryAllObjByExample(MaterialSupplierExample example) {
        return this.materialSupplierMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"materialSupplier"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialSupplier> queryObjByPage(MaterialSupplierExample example) {
        PageView<MaterialSupplier> pageView = example.getPageView();
        pageView.setQueryResult(this.materialSupplierMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"materialSupplier"}, allEntries=true)
    public void importMaterialSupplier(Project project, Company company, List<MaterialSupplier> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date nowDate = new Date();
        int index = 0;
        for (MaterialSupplier materialSupplier : list) {
            materialSupplier.setProjectId(project.getId());
            materialSupplier.setCompanyId(company.getId());
            ++index;
            if (StringUtils.isEmpty((String)materialSupplier.getMaterialCode())) {
                throw new CommonException("\u7b2c" + index + "\u884c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u5165!");
            }
            if (StringUtils.isEmpty((String)materialSupplier.getSupCompanySapCode())) {
                throw new CommonException("\u7b2c" + index + "\u884c\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u5165!");
            }
            if (!"1".equals(materialSupplier.getFaitype()) && !"2".equals(materialSupplier.getFaitype())) {
                throw new CommonException("\u7b2c" + index + "\u884c,FAI\u7c7b\u522b\u53ea\u80fd\u8f93\u51651\u62162\uff0c\u65e0\u6cd5\u5bfc\u5165!");
            }
            MaterialExample example = new MaterialExample();
            MaterialExample.Criteria criteria = example.createCriteria();
            criteria.andProjectIdEqualTo(project.getId()).andCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andMaterialCodeEqualTo(materialSupplier.getMaterialCode());
            List MaterialArray = this.materialService.queryAllObjByExample(example);
            if (CollectionUtils.isEmpty(MaterialArray)) {
                throw new CommonException("\u7269\u6599\u7f16\u7801\u4e3a" + materialSupplier.getMaterialCode() + "\u7684\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u5165!");
            }
            Material material = (Material)MaterialArray.get(0);
            materialSupplier.setMaterialCode(material.getMaterialCode());
            materialSupplier.setMaterialId(material.getId());
            materialSupplier.setMaterialName(material.getMaterialName());
            materialSupplier.setMaterialSpecification(material.getMaterialSpecification());
            if (StringUtils.isEmpty((String)materialSupplier.getPackRemark())) {
                materialSupplier.setPackRemark(material.getPackRemark());
            }
            if (StringUtils.isEmpty((String)materialSupplier.getMinPackSpce())) {
                materialSupplier.setMinPackSpce(material.getMinPackSpce());
            }
            if (StringUtils.isEmpty((String)materialSupplier.getStandPackQuantity())) {
                materialSupplier.setStandPackQuantity(material.getStandPackQuantity());
            }
            if (StringUtils.isEmpty((String)materialSupplier.getStandPackSpce())) {
                materialSupplier.setStandPackSpce(material.getStandPackSpce());
            }
            if (StringUtils.isEmpty((String)materialSupplier.getMaterialOutSize())) {
                materialSupplier.setMaterialOutSize(material.getMaterialOutSize());
            }
            if (StringUtils.isEmpty((String)material.getCategoryId())) {
                throw new CommonException("\u7269\u6599\u7f16\u7801\u4e3a" + materialSupplier.getMaterialCode() + "\u7684\u6ca1\u6709\u7ef4\u62a4\u7269\u6599\u5206\u7c7b\uff0c\u65e0\u6cd5\u5bfc\u5165!");
            }
            MaterialCategoryExample materialCategoryExample = new MaterialCategoryExample();
            MaterialCategoryExample.Criteria materialCategorycriteria = materialCategoryExample.createCriteria();
            materialCategorycriteria.andProjectIdEqualTo(project.getId()).andCompanyIdEqualTo(company.getId()).andIdEqualTo(material.getCategoryId());
            List materialCategoryArray = this.materialCategoryService.queryAllObjByExample(materialCategoryExample);
            if (CollectionUtils.isNotEmpty(materialCategoryArray)) {
                MaterialCategory materialCategory = (MaterialCategory)materialCategoryArray.get(0);
                materialSupplier.setCategoryCode(materialCategory.getCategoryCode());
                materialSupplier.setCategoryId(materialCategory.getId());
                materialSupplier.setCategoryName(materialCategory.getCategoryName());
            }
            CompanyExample companyExample = new CompanyExample();
            CompanyExample.Criteria companyExamplecriteria = companyExample.createCriteria();
            companyExamplecriteria.andProjectIdEqualTo(project.getId()).andCompanySapCodeEqualTo(materialSupplier.getSupCompanySapCode());
            List<Company> CompanyArray = this.companyService.queryAllSupplerCompanies(company.getId(), companyExample);
            if (CollectionUtils.isEmpty(CompanyArray)) {
                throw new CommonException("\u4f9b\u5e94\u5546\u4ee3\u7801\u4e3a" + materialSupplier.getSupCompanySapCode() + "\u7684\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u5165!");
            }
            Company supCompany = CompanyArray.get(0);
            materialSupplier.setSupCompanyId(supCompany.getId());
            materialSupplier.setSupCompanyCode(supCompany.getCompanyCode());
            materialSupplier.setSupCompanySapCode(supCompany.getCompanySapCode());
            materialSupplier.setSupCompanyName(supCompany.getCompanyName());
            materialSupplier.setSupCompanyFullName(supCompany.getCompanyFullName());
            materialSupplier.setUpdateTime(nowDate);
            materialSupplier.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            materialSupplier.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            if (this.isExists(materialSupplier.getMaterialCode(), materialSupplier.getSupCompanySapCode()).booleanValue()) {
                MaterialSupplierExample materialSupplierexample = new MaterialSupplierExample();
                MaterialSupplierExample.Criteria materialSuppliercriteria = materialSupplierexample.createCriteria();
                materialSuppliercriteria.andMaterialCodeEqualTo(materialSupplier.getMaterialCode()).andSupCompanySapCodeEqualTo(materialSupplier.getSupCompanySapCode());
                MaterialSupplier materialSupplierOld = this.queryAllObjByExample(materialSupplierexample).get(0);
                materialSupplier.setId(materialSupplierOld.getId());
                this.modifyObj(materialSupplier);
                continue;
            }
            materialSupplier.setCreateTime(nowDate);
            materialSupplier.setCreateUserId(SpringSecurityUtils.getLoginUserId());
            materialSupplier.setCreateUserName(SpringSecurityUtils.getLoginUserName());
            this.addObj(materialSupplier);
        }
    }

    private Boolean isExists(String MaterialCode2, String SupCompanySapCode) {
        MaterialSupplierExample example = new MaterialSupplierExample();
        MaterialSupplierExample.Criteria criteria = example.createCriteria();
        criteria.andMaterialCodeEqualTo(MaterialCode2).andSupCompanySapCodeEqualTo(SupCompanySapCode);
        int count = this.materialSupplierMapper.countByExample(example);
        if (count > 0) {
            return true;
        }
        return false;
    }
}

