/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialCategoryExample;
import com.els.base.material.entity.MaterialCategoryImportEntity;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialPropKeyGroup;
import com.els.base.material.entity.MaterialPropKeyGroupExample;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.service.MaterialPropKeyGroupService;
import com.els.base.material.service.MaterialService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.txtImport.TxtImportResponse;
import com.els.base.utils.txtImport.TxtImportUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u7269\u6599\u5206\u7c7b")
@Controller
@RequestMapping(value={"materialCategory"})
public class MaterialCategoryController {
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MaterialCategoryService materialCategoryService;
    @Resource
    protected MaterialPropKeyGroupService materialPropKeyGroupService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@ApiParam(value="\u7269\u6599\u5206\u7c7b\u4fe1\u606f") @RequestBody MaterialCategory materialCategory) {
        materialCategory.setId(null);
        materialCategory.setCompanyId(CompanyUtils.currentCompanyId());
        materialCategory.setProjectId(ProjectUtils.getProjectId());
        this.materialCategoryService.addObj(materialCategory);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@ApiParam(value="\u7269\u6599\u5206\u7c7b\u4fe1\u606f") @RequestBody MaterialCategory materialCategory) {
        materialCategory.setCompanyId(CompanyUtils.currentCompanyId());
        materialCategory.setProjectId(ProjectUtils.getProjectId());
        if (StringUtils.isBlank((String)materialCategory.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u7f16\u8f91\u5931\u8d25", "id_is_blank");
        }
        this.materialCategoryService.modifyObj(materialCategory);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@ApiParam(value="\u7269\u6599\u5206\u7c7bID") @RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25", "id_is_blank");
        }
        MaterialExample example = new MaterialExample();
        MaterialExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andCategoryIdEqualTo(id);
        List list = this.materialService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new CommonException("\u7269\u6599\u5728\u5b58\u5728\u7269\u6599\u5206\u7c7b\u7684\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01", "existing_ref_ass", "\u7269\u6599", "\u7269\u6599\u5206\u7c7b");
        }
        MaterialPropKeyGroupExample materialPropKeyGroupExample = new MaterialPropKeyGroupExample();
        MaterialPropKeyGroupExample.Criteria materialPropKeyGroupExampleCriteria = materialPropKeyGroupExample.createCriteria();
        materialPropKeyGroupExampleCriteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        materialPropKeyGroupExampleCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        materialPropKeyGroupExampleCriteria.andMaterialCategoryIdEqualTo(id);
        List materialPropKeyGroupList = this.materialPropKeyGroupService.queryAllObjByExample(materialPropKeyGroupExample);
        if (CollectionUtils.isNotEmpty(materialPropKeyGroupList)) {
            throw new CommonException("\u7269\u6599\u5728\u5b58\u5728\u7269\u6599\u5206\u7c7b\u7684\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01", "existing_ref_ass", "\u7269\u6599", "\u7269\u6599\u5206\u7c7b");
        }
        this.materialCategoryService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialCategory>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialCategory") @RequestBody(required=false) List<QueryParam> params) {
        PageView pageData;
        List materialCategoryList;
        MaterialCategoryExample example = new MaterialCategoryExample();
        example.setPageView(new PageView<MaterialCategory>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        MaterialCategoryExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (CollectionUtils.isNotEmpty(params)) {
            CriteriaUtils.addCriterion(criteria, params);
        }
        if (CollectionUtils.isNotEmpty(materialCategoryList = (pageData = this.materialCategoryService.queryObjByPage(example)).getQueryResult())) {
            for (MaterialCategory materialCategory : materialCategoryList) {
                MaterialPropKeyGroupExample materialPropKeyGroupExample = new MaterialPropKeyGroupExample();
                MaterialPropKeyGroupExample.Criteria materialPropKeyGroupExampleCriteria = materialPropKeyGroupExample.createCriteria();
                materialPropKeyGroupExampleCriteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
                materialPropKeyGroupExampleCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
                materialPropKeyGroupExampleCriteria.andMaterialCategoryIdEqualTo(materialCategory.getId());
                List<MaterialPropKeyGroup> materialPropKeyGroupList = this.materialPropKeyGroupService.queryAllObjByExample(materialPropKeyGroupExample);
                materialCategory.setMaterialPropKeyGroupList(materialPropKeyGroupList);
            }
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u5206\u7c7b", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMateriaCategorylFromExcel"})
    public ResponseResult<String> importMateriaCategorylFromExcel(MultipartHttpServletRequest request) {
        System.out.println("\u5bfc\u5165\u7269\u6599\u5206\u7c7b----\u83b7\u53d6\u6587\u4ef6");
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u5206\u7c7b----\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u5206\u7c7b----\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        System.out.println("\u5bfc\u5165\u7269\u6599\u5206\u7c7b----" + key);
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        if (!uploadFile.getOriginalFilename().endsWith(".xls")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301xls");
        }
        System.out.println("\u5bfc\u5165\u7269\u6599\u5206\u7c7b titleAndModelKeys----");
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
        ArrayList<MaterialCategoryImportEntity> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, MaterialCategoryImportEntity.class);
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u5165\u5f02\u5e38" + e.getMessage());
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.materialCategoryService.importMaterialCategory(ProjectUtils.getProject(), CompanyUtils.currentCompany(), list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u5206\u7c7b", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMateriaCategorylFromTxt"})
    public ResponseResult<String> importMateriaCategorylFromTxt(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);
        String[] keys = new String[]{"categoryCode", "categoryName", "pCategoryCode", "pCategoryName"};
        try {
            TxtImportResponse importTxt = TxtImportUtils.importTxt((MultipartFile)file, (String)"\t", MaterialCategoryImportEntity.class, (String[])keys);
            List list = importTxt.getList();
            this.materialCategoryService.importMaterialCategory(ProjectUtils.getProject(), CompanyUtils.currentCompany(), list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    private MultipartFile vaildTxtFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".txt")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301txt");
        }
        return file;
    }

    @ApiOperation(value="\u4e0b\u8f7d\u7269\u6599\u5206\u7c7b\u5bfc\u5165\u6a21\u677f(Excel)", httpMethod="GET")
    @RequestMapping(value={"service/downloadTemplateExcel"})
    @ResponseBody
    public ModelAndView downloadTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u7269\u6599\u5206\u7c7b\u5bfc\u5165\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
            ArrayList list = new ArrayList();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"\u7269\u6599\u5206\u7c7b", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5206\u7c7b\u7f16\u7801", (String)"categoryCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5206\u7c7b\u540d\u79f0", (String)"categoryName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0a\u7ea7\u7269\u6599\u5206\u7c7b\u4ee3\u7801", (String)"pCategoryCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0a\u7ea7\u7269\u6599\u5206\u7c7b\u540d\u79f0", (String)"pCategoryName"));
        return titleAndModelKeys;
    }
}

