/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialCategoryMapImportEntity;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialPropKey;
import com.els.base.material.entity.MaterialPropKeyExample;
import com.els.base.material.entity.MaterialPropKeyGroup;
import com.els.base.material.entity.MaterialPropKeyGroupExample;
import com.els.base.material.entity.MaterialPropValue;
import com.els.base.material.entity.MaterialPropValueExample;
import com.els.base.material.service.MaterialPropKeyGroupService;
import com.els.base.material.service.MaterialPropKeyService;
import com.els.base.material.service.MaterialPropValueService;
import com.els.base.material.service.MaterialService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.txtImport.TxtImportResponse;
import com.els.base.utils.txtImport.TxtImportUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u7269\u6599")
@Controller
@RequestMapping(value={"material"})
public class MaterialController {
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MaterialPropKeyGroupService materialPropKeyGroupService;
    @Resource
    protected MaterialPropKeyService materialPropKeyService;
    @Resource
    protected MaterialPropValueService materialPropValueService;
    @Resource
    protected DicGroupItemService dicGroupItemService;

    @ApiOperation(httpMethod="POST", value="\u8bbe\u7f6e\u7269\u6599\u662f\u5426\u542f\u7528\u6709\u6548\u671f")
    @RequestMapping(value={"service/validityFlag"})
    @ResponseBody
    public ResponseResult<String> validityFlag(@ApiParam(value="\u7269\u6599ID\u5217\u8868") @RequestBody(required=true) List<String> ids, @ApiParam(value="\u6709\u6548\u671f\u6807\u8bc6\u7b26,1\u8868\u793a\u4f9b\u5e94\u5546\u9001\u8d27\u5355\u5fc5\u987b\u8f93\u5165[\u7269\u6599\u8fc7\u671f\u65e5],0\u8868\u793a\u4f9b\u5e94\u5546\u9001\u8d27\u5355\u65e0\u9700\u8f93\u5165[\u7269\u6599\u8fc7\u671f\u65e5]", defaultValue="0") @RequestParam(required=true, defaultValue="0") Integer validityFlag) {
        Assert.isNotEmpty(ids, "\u7269\u6599ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull(validityFlag, "\u6807\u8bc6\u7b26\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MaterialExample materialExample = new MaterialExample();
        materialExample.createCriteria().andIdIn((List)ids);
        Material material = new Material();
        material.setMaterialValidityFlag(validityFlag);
        this.materialService.updateByExampleSelective(material, materialExample);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Material>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Material") @RequestBody(required=false) QueryParamWapper queryParamWapper) {
        MaterialExample example = new MaterialExample();
        example.setPageView(new PageView<Material>(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CODE ASC,UPDATE_TIME DESC");
        MaterialExample.Criteria criteria = example.createCriteria();
        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion(criteria, queryParamWapper);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        PageView pageData = this.materialService.queryObjByPage(example);
        List materialList = pageData.getQueryResult();
        if (CollectionUtils.isNotEmpty(materialList)) {
            for (Material material : materialList) {
                if (StringUtils.isBlank((String)material.getCategoryId())) continue;
                MaterialPropKeyGroupExample materialPropKeyGroupExample = new MaterialPropKeyGroupExample();
                MaterialPropKeyGroupExample.Criteria materialPropKeyGroupExampleCriteria = materialPropKeyGroupExample.createCriteria();
                materialPropKeyGroupExampleCriteria.andProjectIdEqualTo(material.getProjectId());
                materialPropKeyGroupExampleCriteria.andCompanyIdEqualTo(material.getCompanyId());
                materialPropKeyGroupExampleCriteria.andMaterialCategoryIdEqualTo(material.getCategoryId());
                List<MaterialPropKeyGroup> materialPropKeyGroupList = this.materialPropKeyGroupService.queryAllObjByExample(materialPropKeyGroupExample);
                if (CollectionUtils.isNotEmpty(materialPropKeyGroupList)) {
                    for (MaterialPropKeyGroup materialPropKeyGroup : materialPropKeyGroupList) {
                        MaterialPropKeyExample materialPropKeyExampleExample = new MaterialPropKeyExample();
                        MaterialPropKeyExample.Criteria materialPropKeyExampleCriteria = materialPropKeyExampleExample.createCriteria();
                        materialPropKeyExampleCriteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
                        materialPropKeyExampleCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
                        materialPropKeyExampleCriteria.andPropKeyGroupIdEqualTo(materialPropKeyGroup.getId());
                        List<MaterialPropKey> materialPropKeyList = this.materialPropKeyService.queryAllObjByExample(materialPropKeyExampleExample);
                        if (CollectionUtils.isNotEmpty(materialPropKeyList)) {
                            for (MaterialPropKey materialPropKey : materialPropKeyList) {
                                MaterialPropValueExample materialPropValueExample = new MaterialPropValueExample();
                                MaterialPropValueExample.Criteria materialPropValueExampleCriteria = materialPropValueExample.createCriteria();
                                materialPropValueExampleCriteria.andProjectIdEqualTo(material.getProjectId());
                                materialPropValueExampleCriteria.andCompanyIdEqualTo(material.getCompanyId());
                                materialPropValueExampleCriteria.andMaterialIdEqualTo(material.getId());
                                materialPropValueExampleCriteria.andPropKeyGroupIdEqualTo(materialPropKeyGroup.getId());
                                materialPropValueExampleCriteria.andPropKeyIdEqualTo(materialPropKey.getId());
                                materialPropValueExampleCriteria.andPropKeyEqualTo(materialPropKey.getPropKey());
                                List materialPropValueList = this.materialPropValueService.queryAllObjByExample(materialPropValueExample);
                                if (!CollectionUtils.isNotEmpty(materialPropValueList) || materialPropValueList.size() <= 0) continue;
                                MaterialPropValue materialPropValue = (MaterialPropValue)materialPropValueList.get(0);
                                materialPropKey.setPropValue(materialPropValue.getPropValue());
                            }
                        }
                        materialPropKeyGroup.setMaterialPropKeyList(materialPropKeyList);
                    }
                }
                material.setMaterialPropKeyGroupList(materialPropKeyGroupList);
            }
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599")
    @RequestMapping(value={"service/findMaterialByPage"})
    @ResponseBody
    public ResponseResult<PageView<Material>> findMaterialByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Material") @RequestBody(required=false) QueryParamWapper queryParamWapper) {
        MaterialExample example = new MaterialExample();
        example.setPageView(new PageView<Material>(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CODE ASC");
        MaterialExample.Criteria criteria = example.createCriteria();
        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion(criteria, queryParamWapper);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        PageView<Material> pageData = this.materialService.queryMaterialByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u542f\u7528/\u7981\u6b62\u7269\u6599\u4fe1\u606f")
    @RequestMapping(value={"service/isEnable"})
    @ResponseBody
    public ResponseResult<Integer> isEnable(@ApiParam(value="\u7269\u6599id") String id, @ApiParam(value="\u542f\u7528\u4f201,\u7981\u7528\u4f200") Integer isEnable) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e3a\u7a7a,\u542f\u7528/\u7981\u6b62\u4f01\u4e1a\u5931\u8d25", "id_is_blank");
        }
        int result = this.materialService.isEnable(id, isEnable);
        return ResponseResult.success(result);
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMaterialFromExcel"})
    public ResponseResult<String> importMaterialFromExcel(MultipartHttpServletRequest request) {
        System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e----\u83b7\u53d6\u6587\u4ef6");
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e----\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e----\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636ekey----" + key);
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636etitleAndModelKeys----");
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
        ArrayList<Material> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Material.class);
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u5165\u5f02\u5e38" + e.getMessage());
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.materialService.importMaterialFromExcel(list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u4ed3\u50a8\u8bbe\u7f6e", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMaterialWarehouseFromExcel"})
    public ResponseResult<String> importMaterialWarehouseFromExcel(MultipartHttpServletRequest request) {
        System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e----\u83b7\u53d6\u6587\u4ef6");
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e----\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e----\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636ekey----" + key);
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636etitleAndModelKeys----");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599", (String)"materialCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialName", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"factoryName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e93\u4f4d", (String)"warehouse"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed3\u4f4d", (String)"warehouseBin"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"figureType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u89c4\u683c", (String)"materialSpecification"));
        ArrayList<Material> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Material.class);
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u5165\u5f02\u5e38" + e.getMessage());
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.materialService.importMaterialFromExcel(list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4e0b\u8f7d\u7269\u6599\u4e3b\u6570\u636e\u5bfc\u5165\u6a21\u677f", httpMethod="GET")
    @RequestMapping(value={"service/downloadTemplateExcel"})
    @ResponseBody
    public ModelAndView downloadTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u7269\u6599\u4e3b\u6570\u636e\u5bfc\u5165\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
            ArrayList list = new ArrayList();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"\u7269\u6599\u4e3b\u6570\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u6807\u8bc6", (String)"materialCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u89c4\u683c", (String)"materialSpecification"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"description"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e01\u79cd", (String)"currency"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5355\u91cd", (String)"weight"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"figureType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"factoryName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u57fa\u672c\u5355\u4f4d", (String)"basicUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7c7b\u578b", (String)"purchaseType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed3\u4f4d", (String)"warehouseBin"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed3\u5e93", (String)"warehouse"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u5173\u7cfb", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMaterialCategoryMapFromTxt"})
    public ResponseResult<String> importMaterialCategoryMapFromTxt(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);
        String[] keys = new String[]{"materialCode", "materialName", "factoryName", "categoryCode", "categoryName"};
        try {
            TxtImportResponse importTxt = TxtImportUtils.importTxt((MultipartFile)file, (String)"\t", MaterialCategoryMapImportEntity.class, (String[])keys);
            List list = importTxt.getList();
            this.materialService.importMaterialMapFromTxt(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    private MultipartFile vaildTxtFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".txt")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301txt");
        }
        return file;
    }

    @ApiOperation(value="\u4e0b\u8f7d\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u5173\u7cfb\u5bfc\u5165\u6a21\u677f", httpMethod="GET")
    @RequestMapping(value={"service/downloadMapTemplateExcel"})
    @ResponseBody
    public ModelAndView downloadMapTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u5173\u7cfb\u5bfc\u5165\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeyMap();
            ArrayList list = new ArrayList();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"\u7269\u6599\u4e3b\u6570\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKeyMap() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u6807\u8bc6", (String)"materialCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"factoryName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5206\u7c7b\u7f16\u7801", (String)"categoryCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5206\u7c7b\u540d\u79f0", (String)"categoryName"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u5305\u88c5\u89c4\u683c", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMaterialPackagingFromExcel"})
    public ResponseResult<String> importMaterialPackagingFromExcel(MultipartHttpServletRequest request) {
        System.out.println("\u5bfc\u5165\u7269\u6599\u5305\u88c5\u89c4\u683c----\u83b7\u53d6\u6587\u4ef6");
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u5305\u88c5\u89c4\u683c----\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u5305\u88c5\u89c4\u683c----\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        System.out.println("\u5bfc\u5165\u7269\u6599\u5305\u88c5\u89c4\u683ckey----" + key);
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        System.out.println("\u5bfc\u5165\u7269\u6599\u5305\u88c5\u89c4\u683ctitleAndModelKeys----");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u4ee3\u7801", (String)"materialCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"factoryName", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6807\u51c6\u5305\u88c5\u89c4\u683c", (String)"standPackSpce", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6700\u5c0f\u5305\u88c5\u89c4\u683c", (String)"minPackSpce", (boolean)true));
        List<Material> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Material.class);
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u5165\u5f02\u5e38" + e.getMessage());
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (Material material : list) {
                String materialCode = material.getMaterialCode();
                String factoryName = material.getFactoryName();
                String standPackSpce = material.getStandPackSpce();
                String minPackSpce = material.getMinPackSpce();
                MaterialExample example = new MaterialExample();
                MaterialExample.Criteria createCriteria = example.createCriteria();
                createCriteria.andMaterialCodeEqualTo(materialCode).andFactoryNameEqualTo(factoryName);
                List materialList = this.materialService.queryAllObjByExample(example);
                if (CollectionUtils.isEmpty(materialList)) {
                    throw new CommonException("\u6ca1\u6709\u6b64\u7269\u6599");
                }
                List<DicGroupItem> dicGroupItemList1 = this.dicGroupItemService.queryItemsByGroupCode("standPackSpce");
                ArrayList<String> standPackSpceList = new ArrayList<String>();
                for (DicGroupItem dicGroupItem : dicGroupItemList1) {
                    String name = dicGroupItem.getName();
                    standPackSpceList.add(name);
                }
                if (!standPackSpceList.contains(standPackSpce)) {
                    throw new CommonException("\u5bfc\u5165\u7684\u6807\u51c6\u5305\u88c5\u89c4\u683c\u4e0d\u5728\u6570\u636e\u5b57\u5178\u91cc");
                }
                ArrayList<String> minPackSpceList = new ArrayList<String>();
                List<DicGroupItem> dicGroupItemList2 = this.dicGroupItemService.queryItemsByGroupCode("minPackSpce");
                for (DicGroupItem dicGroupItem : dicGroupItemList2) {
                    String name = dicGroupItem.getName();
                    minPackSpceList.add(name);
                }
                if (minPackSpceList.contains(minPackSpce)) continue;
                throw new CommonException("\u5bfc\u5165\u7684\u6700\u5c0f\u5305\u88c5\u89c4\u683c\u4e0d\u5728\u6570\u636e\u5b57\u5178\u91cc");
            }
            this.materialService.importMaterialFromExcel(list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4e0b\u8f7d\u7269\u6599\u5305\u88c5\u89c4\u683c\u6a21\u677f", httpMethod="GET")
    @RequestMapping(value={"service/downloadPackagingTemplateExcel"})
    @ResponseBody
    public ModelAndView downloadPackagingTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u7269\u6599\u6807\u51c6\u548c\u6700\u5c0f\u5305\u88c5\u89c4\u683c\u5bfc\u5165\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey2();
            ArrayList list = new ArrayList();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"\u7269\u6599\u4e3b\u6570\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey2() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u4ee3\u7801", (String)"materialCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"factoryName", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6807\u51c6\u5305\u88c5\u89c4\u683c", (String)"standPackSpce", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6700\u5c0f\u5305\u88c5\u89c4\u683c", (String)"minPackSpce", (boolean)true));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u81ea\u52a8\u68c0\u9a8c\u8bbe\u7f6e", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMaterialAutomaticDetectionFromExcel"})
    public ResponseResult<String> importMaterialAutomaticDetectionFromExcel(MultipartHttpServletRequest request) {
        System.out.println("\u5bfc\u5165\u7269\u6599\u81ea\u52a8\u68c0\u9a8c\u8bbe\u7f6e----\u83b7\u53d6\u6587\u4ef6");
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u81ea\u52a8\u68c0\u9a8c\u8bbe\u7f6e----\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u81ea\u52a8\u68c0\u9a8c\u8bbe\u7f6e----\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636ekey----" + key);
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636etitleAndModelKeys----");
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelAutomaticDetection();
        ArrayList<Material> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Material.class);
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u5165\u5f02\u5e38" + e.getMessage());
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.materialService.importMaterialAutomaticDetection(list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u81ea\u52a8\u68c0\u9a8c\u8bbe\u7f6e", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMaterialAutomaticDetectionFromTxt"})
    public ResponseResult<String> importMaterialAutomaticDetectionFromTxt(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);
        String[] keys = new String[]{"materialCode", "materialName", "factoryName", "automaticDetection"};
        try {
            TxtImportResponse importTxt = TxtImportUtils.importTxt((MultipartFile)file, (String)"\t", Material.class, (String[])keys);
            List list = importTxt.getList();
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a\u8bf7\u8f93\u5165\u6570\u636e");
            }
            this.materialService.importMaterialAutomaticDetection(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u7269\u6599\u81ea\u52a8\u68c0\u9a8c\u8bbe\u7f6e\u5bfc\u5165\u6a21\u677f", httpMethod="GET")
    @RequestMapping(value={"service/downloadAutomaticDetectionTemplateExcel"})
    @ResponseBody
    public ModelAndView downloadAutomaticDetectionTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u7269\u6599\u81ea\u52a8\u68c0\u9a8c\u8bbe\u7f6e\u5bfc\u5165\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelAutomaticDetection();
            ArrayList list = new ArrayList();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"\u7269\u6599\u81ea\u52a8\u68c0\u9a8c\u8bbe\u7f6e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelAutomaticDetection() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u6807\u8bc6", (String)"materialCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"factoryName", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u81ea\u52a8\u68c0\u6d4b(Y/N)", (String)"automaticDetection", (boolean)true));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMateriaAutolFromExcel"})
    public ResponseResult<String> importMateriaAutolFromExcel(MultipartHttpServletRequest request) {
        System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e----\u83b7\u53d6\u6587\u4ef6");
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e----\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e----\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
            throw new CommonException("\u65e0\u6cd5\u540c\u65f6\u5904\u7406\u591a\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        }
        String key = (String)fileMap.keySet().iterator().next();
        System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636ekey----" + key);
        MultipartFile uploadFile = (MultipartFile)fileMap.get(key);
        System.out.println("\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636etitleAndModelKeys----");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u53f7", (String)"materialCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialName", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"factoryName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"figureType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u89c4\u683c", (String)"materialSpecification"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6750\u8d28", (String)"texture"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u57fa\u672c\u5355\u4f4d", (String)"basicUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u5173\u952e\u4ef6", (String)"isKeyComponent"));
        ArrayList<Material> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)uploadFile.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Material.class);
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u5165\u5f02\u5e38" + e.getMessage());
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.materialService.importMaterialFromExcel(list);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599")
    @RequestMapping(value={"service/getList"})
    @ResponseBody
    public ResponseResult<List<String>> getList() {
        return ResponseResult.success(this.materialService.selectMaterialCode());
    }
}

