/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.dao.MaterialPropKeyMapper;
import com.els.base.material.entity.MaterialPropKey;
import com.els.base.material.entity.MaterialPropKeyExample;
import com.els.base.material.service.MaterialPropKeyService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialPropKeyService")
public class MaterialPropKeyServiceImpl
implements MaterialPropKeyService {
    @Resource
    protected MaterialPropKeyMapper materialPropKeyMapper;

    @CacheEvict(value={"materialPropKey"}, allEntries=true)
    public void addObj(MaterialPropKey t) {
        if (StringUtils.isBlank((String)t.getPropCode())) {
            throw new CommonException("PropCode\u503c" + t.getPropCode() + "\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u65b0\u589e", "base_canot_be_null", new Object[]{"PropCode\u503c"});
        }
        MaterialPropKeyExample example = new MaterialPropKeyExample();
        MaterialPropKeyExample.Criteria materialPropKeyExampleCriteria = example.createCriteria();
        materialPropKeyExampleCriteria.andProjectIdEqualTo(t.getProjectId());
        materialPropKeyExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
        materialPropKeyExampleCriteria.andPropCodeEqualTo(t.getPropCode());
        List<MaterialPropKey> materialPropKeyList = this.materialPropKeyMapper.selectByExample(example);
        if (materialPropKeyList == null || materialPropKeyList.size() > 0) {
            throw new CommonException("PropCode\u503c\u91cd\u590d\uff0c\u65e0\u6cd5\u65b0\u589e", "base_is_exists", new Object[]{"PropCode\u503c"});
        }
        this.materialPropKeyMapper.insertSelective(t);
    }

    @CacheEvict(value={"materialPropKey"}, allEntries=true)
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.materialPropKeyMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialPropKey"}, allEntries=true)
    public void modifyObj(MaterialPropKey t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        if (StringUtils.isBlank((String)t.getPropCode())) {
            throw new CommonException("PropCode\u503c" + t.getPropCode() + "\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u65b0\u589e", "base_canot_be_null", new Object[]{"PropCode\u503c"});
        }
        MaterialPropKey t2 = this.materialPropKeyMapper.selectByPrimaryKey(t.getId());
        if (t2.getPropCode().equals(t.getPropCode())) {
            this.materialPropKeyMapper.updateByPrimaryKeySelective(t);
        } else {
            MaterialPropKeyExample example = new MaterialPropKeyExample();
            MaterialPropKeyExample.Criteria materialPropKeyExampleCriteria = example.createCriteria();
            materialPropKeyExampleCriteria.andProjectIdEqualTo(t.getProjectId());
            materialPropKeyExampleCriteria.andCompanyIdEqualTo(t.getCompanyId());
            materialPropKeyExampleCriteria.andPropCodeEqualTo(t.getPropCode());
            List<MaterialPropKey> materialPropKeyList = this.materialPropKeyMapper.selectByExample(example);
            if (materialPropKeyList == null || materialPropKeyList.size() > 0) {
                throw new CommonException("PropCode\u503c\u91cd\u590d\uff0c\u65e0\u6cd5\u65b0\u589e", "base_is_exists", new Object[]{"PropCode\u503c"});
            }
            this.materialPropKeyMapper.updateByPrimaryKeySelective(t);
        }
    }

    @Cacheable(value={"materialPropKey"}, keyGenerator="redisKeyGenerator")
    public MaterialPropKey queryObjById(String id) {
        return this.materialPropKeyMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialPropKey"}, keyGenerator="redisKeyGenerator")
    public List<MaterialPropKey> queryAllObjByExample(MaterialPropKeyExample example) {
        return this.materialPropKeyMapper.selectByExample(example);
    }

    @Cacheable(value={"materialPropKey"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialPropKey> queryObjByPage(MaterialPropKeyExample example) {
        PageView<MaterialPropKey> pageView = example.getPageView();
        pageView.setQueryResult(this.materialPropKeyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"materialPropKey"}, allEntries=true)
    public void deleteByExample(MaterialPropKeyExample materialPropKeyExample) {
        Assert.isNotNull((Object)((Object)materialPropKeyExample), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(materialPropKeyExample.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialPropKeyMapper.deleteByExample(materialPropKeyExample);
    }

    @CacheEvict(value={"materialPropKey"}, allEntries=true)
    @Transactional
    public void addAll(List<MaterialPropKey> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.materialPropKeyMapper.insertSelective((MaterialPropKey)record));
    }
}

