/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanySapRelationService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.BaseCommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.command.ConfirmMaterialFileNoticeCmd;
import com.els.base.material.command.CreateMaterialFileNoticeCmd;
import com.els.base.material.entity.MaterialFile;
import com.els.base.material.entity.MaterialFileExample;
import com.els.base.material.entity.MaterialFileNotice;
import com.els.base.material.entity.MaterialFileNoticeExample;
import com.els.base.material.service.MaterialFileNoticeService;
import com.els.base.material.service.MaterialFileService;
import com.els.base.material.utils.ConfirmStatusConverter;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u7269\u6599\u6587\u4ef6\u901a\u77e5\u5355"})
@Controller
@RequestMapping(value={"materialFileNotice"})
public class MaterialFileNoticeController {
    @Resource
    protected MaterialFileNoticeService materialFileNoticeService;
    @Resource
    private MaterialFileService materialFileService;
    @Resource
    private CompanySapRelationService companySapRelationService;
    @Resource
    protected BaseCommandInvoker invoker;
    private static Logger logger = LoggerFactory.getLogger(MaterialFileNoticeController.class);

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u6587\u4ef6\u901a\u77e5\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=true, value="\u7269\u6599\u6587\u6863ID", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="companySapCodes", required=true, value="\u4f9b\u5e94\u5546SAP\u7f16\u7801", paramType="body", dataType="List")})
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody List<String> companySapCodes, String id) {
        Assert.isNotBlank((String)id, (String)"\u7269\u6599\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(companySapCodes, (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
        MaterialFileExample example = new MaterialFileExample();
        example.createCriteria().andIdEqualTo(id);
        List materialFiles = this.materialFileService.queryAllObjByExample((IExample)example);
        CreateMaterialFileNoticeCmd cmd = new CreateMaterialFileNoticeCmd(companySapCodes, (List<MaterialFile>)materialFiles);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u6587\u4ef6\u901a\u77e5\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialFileNotice materialFileNotice) {
        Assert.isNotBlank((String)materialFileNotice.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.materialFileNoticeService.modifyObj(materialFileNotice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u6587\u4ef6\u901a\u77e5\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        MaterialFileNoticeExample example = new MaterialFileNoticeExample();
        example.createCriteria().andIdIn((List)ids);
        this.materialFileNoticeService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u6587\u4ef6\u901a\u77e5\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialFileNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialFileNotice>> purFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialFileNoticeExample example = new MaterialFileNoticeExample();
        example.setOrderByClause("CREATE_TIME DESC");
        example.setPageView((PageView<MaterialFileNotice>)new PageView(pageNo, pageSize));
        MaterialFileNoticeExample.Criteria criteria = example.createCriteria();
        if (wapper != null && CollectionUtils.isNotEmpty((Collection)wapper.getQueryParams())) {
            for (QueryParam queryParam : wapper.getQueryParams()) {
                if (!"material".equals(queryParam.getProperty())) continue;
                criteria.andMaterialCodeLike("%" + queryParam.getValue() + "%");
                example.or().andFileNameLike("%" + queryParam.getValue() + "%");
                example.or().andSupCompanyNameLike("%" + queryParam.getValue() + "%");
                example.or().andSupCompanySapCodeLike("%" + queryParam.getValue() + "%");
                wapper.getQueryParams().remove(queryParam);
                break;
            }
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialFileNoticeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u6587\u6863\u901a\u77e5\uff08\u91c7\u8d2d\u65b9\uff09\u6279\u91cf\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/pur/downloadExcelByPur"})
    @ResponseBody
    public ModelAndView downloadExcelByPur(String queryParams, HttpServletResponse response) {
        try {
            MaterialFileNoticeExample example = new MaterialFileNoticeExample();
            example.setOrderByClause("CREATE_TIME DESC");
            MaterialFileNoticeExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotBlank((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
                if (queryParamWapper != null && CollectionUtils.isNotEmpty((Collection)queryParamWapper.getQueryParams())) {
                    for (QueryParam queryParam : queryParamWapper.getQueryParams()) {
                        if (!"material".equals(queryParam.getProperty())) continue;
                        criteria.andMaterialCodeLike("%" + queryParam.getValue() + "%");
                        example.or().andFileNameLike("%" + queryParam.getValue() + "%");
                        example.or().andSupCompanySapCodeLike("%" + queryParam.getValue() + "%");
                        example.or().andSupCompanyNameLike("%" + queryParam.getValue() + "%");
                        queryParamWapper.getQueryParams().remove(queryParam);
                        break;
                    }
                }
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            }
            List materialFileNoticeList = this.materialFileNoticeService.queryAllObjByExample((IExample)example);
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)materialFileNoticeList, (String)"\u6587\u6863\u901a\u77e5", null, (int)0);
            String fileName = String.format("\u6587\u6863\u901a\u77e5%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    @ApiOperation(value="\u6587\u6863\u901a\u77e5\uff08\u4f9b\u5e94\u5546\uff09\u6279\u91cf\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/sup/downloadExcelBySup"})
    @ResponseBody
    public ModelAndView downloadExcelBySup(String queryParams, HttpServletResponse response) {
        try {
            MaterialFileNoticeExample example = new MaterialFileNoticeExample();
            example.setOrderByClause("CREATE_TIME DESC");
            MaterialFileNoticeExample.Criteria exampleCriteria = example.createCriteria();
            Company company = CompanyUtils.currentCompany();
            QueryParamWapper queryParamWapper = new QueryParamWapper();
            if (StringUtils.isNotBlank((String)queryParams)) {
                queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
                if (queryParamWapper != null && CollectionUtils.isNotEmpty((Collection)queryParamWapper.getQueryParams())) {
                    for (QueryParam queryParam : queryParamWapper.getQueryParams()) {
                        if (!"material".equals(queryParam.getProperty())) continue;
                        exampleCriteria.andMaterialCodeLike("%" + queryParam.getValue() + "%").andSupCompanyIdEqualTo(company.getId());
                        example.or().andFileNameLike("%" + queryParam.getValue() + "%").andSupCompanyIdEqualTo(company.getId());
                        queryParamWapper.getQueryParams().remove(queryParam);
                        logger.info(queryParamWapper.getQueryParams().toString());
                        break;
                    }
                }
            } else {
                example.or().andSupCompanyIdEqualTo(company.getId());
            }
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            List materialFileNoticeList = this.materialFileNoticeService.queryAllObjByExample((IExample)example);
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)materialFileNoticeList, (String)"\u6587\u6863\u901a\u77e5", null, (int)0);
            String fileName = String.format("\u6587\u6863\u901a\u77e5%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    @ApiOperation(value="\u6587\u6863\u901a\u77e5\u9009\u4e2d\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcelSelect"})
    @ResponseBody
    public ModelAndView downloadExcelSelect(@RequestParam(defaultValue="") String ids, HttpServletResponse response) {
        try {
            if (StringUtils.isEmpty((String)ids)) {
                throw new CommonException("\u9009\u4e2d\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
            }
            MaterialFileNoticeExample example = new MaterialFileNoticeExample();
            example.createCriteria().andIdIn((List)Arrays.asList(ids.split(",")));
            List materialFileNoticeList = this.materialFileNoticeService.queryAllObjByExample((IExample)example);
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)materialFileNoticeList, (String)"\u6587\u6863\u901a\u77e5", null, (int)0);
            String fileName = String.format("\u6587\u6863\u901a\u77e5%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    public List<TitleAndModelKey> createTitleAndModelKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        ConfirmStatusConverter confirmStatusConverter = new ConfirmStatusConverter();
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        TitleAndModelKey confirmStatus = ExcelUtils.createTitleAndModelKey((String)"\u786e\u8ba4\u72b6\u6001", (String)"confirmStatus");
        confirmStatus.setToStrConverter((ObjToStrConverter)confirmStatusConverter);
        titleAndModelKeys.add(confirmStatus);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6587\u6863\u7f16\u7801", (String)"fileCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6587\u6863\u540d\u79f0", (String)"fileName"));
        TitleAndModelKey updateTime = ExcelUtils.createTitleAndModelKey((String)"\u66f4\u65b0\u65f6\u95f4", (String)"updateTime");
        updateTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(updateTime);
        TitleAndModelKey sendTime = ExcelUtils.createTitleAndModelKey((String)"\u53d1\u9001\u65f6\u95f4", (String)"sendTime");
        sendTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(sendTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"description"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
        TitleAndModelKey confirmTime = ExcelUtils.createTitleAndModelKey((String)"\u786e\u8ba4\u65f6\u95f4", (String)"confirmTime");
        confirmTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(confirmTime);
        return titleAndModelKeys;
    }

    private void setResponseHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u6587\u4ef6\u901a\u77e5\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialFileNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialFileNotice>> supFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialFileNoticeExample example = new MaterialFileNoticeExample();
        example.setOrderByClause("CREATE_TIME DESC");
        example.setPageView((PageView<MaterialFileNotice>)new PageView(pageNo, pageSize));
        MaterialFileNoticeExample.Criteria criteria = example.createCriteria();
        Company company = CompanyUtils.currentCompany();
        if (wapper != null && CollectionUtils.isNotEmpty((Collection)wapper.getQueryParams())) {
            for (QueryParam queryParam : wapper.getQueryParams()) {
                if (!"material".equals(queryParam.getProperty())) continue;
                criteria.andMaterialCodeLike("%" + queryParam.getValue() + "%").andSupCompanyIdEqualTo(company.getId());
                example.or().andFileNameLike("%" + queryParam.getValue() + "%").andSupCompanyIdEqualTo(company.getId());
                wapper.getQueryParams().remove(queryParam);
                break;
            }
        } else {
            example.or().andSupCompanyIdEqualTo(company.getId());
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialFileNoticeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    public ResponseResult<PageView<MaterialFileNotice>> supFindByPageConfrimed() {
        MaterialFileNoticeExample example = new MaterialFileNoticeExample();
        example.setOrderByClause("CREATE_TIME DESC");
        MaterialFileNoticeExample.Criteria criteria = example.createCriteria();
        Company company = CompanyUtils.currentCompany();
        criteria.andSupCompanyIdEqualTo(company.getId());
        criteria.andConfirmStatusEqualTo(0);
        PageView pageData = this.materialFileNoticeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u786e\u8ba4\u7269\u6599\u6587\u4ef6\u901a\u77e5\u5355")
    @RequestMapping(value={"service/confrimByIds"})
    @ResponseBody
    public ResponseResult<String> confrimByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u786e\u8ba4\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        User user = SpringSecurityUtils.getLoginUser();
        ConfirmMaterialFileNoticeCmd cmd = new ConfirmMaterialFileNoticeCmd(ids, user);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }
}

