/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.command;

import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.MaterialFileNotice;
import com.els.base.material.entity.MaterialFileNoticeExample;
import com.els.base.material.service.MaterialFileNoticeService;
import com.els.base.utils.SpringContextHolder;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ConfirmMaterialFileNoticeCmd
extends BaseCommand {
    private List<String> ids;
    private User user;
    private MaterialFileNoticeService materialFileNoticeService = (MaterialFileNoticeService)SpringContextHolder.getOneBean(MaterialFileNoticeService.class);

    public ConfirmMaterialFileNoticeCmd(List<String> ids, User user) {
        this.ids = ids;
        this.user = user;
    }

    public Object execute(ICommandInvoker iCommandInvoker) {
        MaterialFileNoticeExample example = new MaterialFileNoticeExample();
        example.createCriteria().andIdIn((List)this.ids);
        List list = this.materialFileNoticeService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)list, (String)"\u4e0d\u5b58\u5728\u52fe\u9009\u6570\u636e\uff0c\u8bf7\u5237\u65b0");
        list.stream().forEach(notice -> {
            if (notice.getConfirmStatus() != null && notice.getConfirmStatus().equals(Constant.YES_INT)) {
                throw new CommonException("\u5b58\u5728\u5df2\u786e\u8ba4\u7684\u7269\u6599\u6587\u6863");
            }
        });
        MaterialFileNotice notice2 = new MaterialFileNotice();
        notice2.setConfirmStatus(Constant.YES_INT);
        notice2.setConfirmTime(new Date());
        if (this.user != null) {
            notice2.setConfirmUserId(this.user.getId());
            notice2.setConfirmUserName(this.user.getNickName());
        }
        this.materialFileNoticeService.modifyByExmaple(notice2, example);
        return null;
    }
}

