/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.command;

import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.material.entity.MaterialFile;
import com.els.base.material.entity.MaterialFileExample;
import com.els.base.material.service.MaterialFileService;
import com.els.base.utils.SpringContextHolder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class UploadFileForMaterialCmd
extends BaseCommand<String> {
    private static final long serialVersionUID = 1L;
    private String fileCode;
    private FileData fileUpload;

    public UploadFileForMaterialCmd(String fileCode, FileData fileUpload) {
        this.fileCode = fileCode;
        this.fileUpload = fileUpload;
    }

    public String execute(ICommandInvoker context) {
        Assert.isNotNull((Object)this.fileUpload, (String)"\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.fileUpload.getId(), (String)"\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.fileCode, (String)"\u6587\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MaterialFileExample materialFileExample = new MaterialFileExample();
        materialFileExample.createCriteria().andFileCodeEqualTo(this.fileCode);
        List existMaterialFileList = ((MaterialFileService)SpringContextHolder.getOneBean(MaterialFileService.class)).queryAllObjByExample((IExample)materialFileExample);
        Date now = new Date();
        if (CollectionUtils.isEmpty((Collection)existMaterialFileList)) {
            String fileName = this.fileUpload.getFileName();
            if (StringUtils.isBlank((String)FilenameUtils.getExtension((String)fileName)) && StringUtils.isNotBlank((String)this.fileUpload.getFileSuffix())) {
                fileName = fileName + "." + this.fileUpload.getFileSuffix();
            }
            MaterialFile materialFile = new MaterialFile();
            materialFile.setFileCode(this.fileCode);
            materialFile.setFileId(this.fileUpload.getId());
            materialFile.setFileName(this.fileUpload.getFileName());
            materialFile.setFileRename(this.fileUpload.getFileRename());
            materialFile.setFileSuffix(this.fileUpload.getFileSuffix());
            materialFile.setCompanyId(this.fileUpload.getCompanyId());
            materialFile.setProjectId(this.fileUpload.getProjectId());
            materialFile.setCreateTime(now);
            materialFile.setUpdateTime(now);
            materialFile.setFileVersion(DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            materialFile.setIsEnable(Constant.YES_INT);
            ((MaterialFileService)SpringContextHolder.getOneBean(MaterialFileService.class)).addObj(materialFile);
        } else {
            MaterialFile materialFile = new MaterialFile();
            materialFile.setFileId(this.fileUpload.getId());
            materialFile.setFileRename(this.fileUpload.getFileRename());
            materialFile.setUpdateTime(now);
            materialFile.setFileName(this.fileUpload.getFileName());
            ((MaterialFileService)SpringContextHolder.getOneBean(MaterialFileService.class)).modifyByExample(materialFile, materialFileExample);
        }
        return null;
    }
}

