/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.material.dao.MaterialCategoryMapper;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialCategoryExample;
import com.els.base.material.service.MaterialCategoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7269\u6599\u5206\u7c7b")
@Controller
@RequestMapping(value={"cascadedMaterialCategory"})
public class MaterialCategoryController2 {
    private static final Integer YES_INABLED = 1;
    @Resource
    protected MaterialCategoryService materialCategoryService;
    @Resource
    protected MaterialCategoryMapper materialCategoryMapper;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@ApiParam(value="\u7269\u6599\u5206\u7c7b\u4fe1\u606f") @RequestBody MaterialCategory materialCategory) {
        if (StringUtils.isEmpty((String)materialCategory.getCategoryName())) {
            throw new CommonException("\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)materialCategory.getCategoryCode())) {
            throw new CommonException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (materialCategory.getCategoryCode().length() > 255) {
            throw new CommonException("\u7269\u6599\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7269\u6599\u5206\u7c7b\u7f16\u7801", 255});
        }
        if (materialCategory.getCategoryName().length() > 255) {
            throw new CommonException("\u7269\u6599\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7269\u6599\u5206\u7c7b\u540d\u79f0", 255});
        }
        materialCategory.setId(null);
        materialCategory.setCompanyId(CompanyUtils.currentCompanyId());
        materialCategory.setProjectId(ProjectUtils.getProjectId());
        materialCategory.setIsEnable(YES_INABLED);
        this.materialCategoryService.addObj(materialCategory);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@ApiParam(value="\u7269\u6599\u5206\u7c7b\u4fe1\u606f") @RequestBody MaterialCategory materialCategory) {
        if (StringUtils.isBlank((String)materialCategory.getId())) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        if (StringUtils.isEmpty((String)materialCategory.getCategoryName())) {
            throw new CommonException("\u7269\u6599\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)materialCategory.getCategoryCode())) {
            throw new CommonException("\u7269\u6599\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (materialCategory.getCategoryCode().length() > 255) {
            throw new CommonException("\u7269\u6599\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7269\u6599\u5206\u7c7b\u7f16\u7801", 255});
        }
        if (materialCategory.getCategoryName().length() > 255) {
            throw new CommonException("\u7269\u6599\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7269\u6599\u5206\u7c7b\u540d\u79f0", 255});
        }
        boolean flag = false;
        MaterialCategory obj = (MaterialCategory)this.materialCategoryService.queryObjById(materialCategory.getId());
        if (null == obj) {
            throw new CommonException("\u8be5id\u67e5\u4e0d\u5230\u6570\u636e");
        }
        String categoryCode = obj.getCategoryCode();
        if (StringUtils.isNotBlank((String)categoryCode) && !categoryCode.equals(materialCategory.getCategoryCode())) {
            flag = true;
        }
        if (flag) {
            MaterialCategoryExample materialCategoryExample = new MaterialCategoryExample();
            materialCategoryExample.createCriteria().andProjectIdEqualTo(ProjectUtils.getProjectId()).andCategoryCodeEqualTo(materialCategory.getCategoryCode()).andIsEnableEqualTo(YES_INABLED);
            if (this.materialCategoryMapper.countByExample(materialCategoryExample) > 0) {
                throw new CommonException("\u8be5\u7269\u6599\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728!");
            }
        }
        materialCategory.setUpdateTime(new Date());
        this.materialCategoryService.modifyObj(materialCategory);
        return ResponseResult.success();
    }

    @Transactional
    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@ApiParam(value="\u7269\u6599\u5206\u7c7bID") @RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25", "id_is_blank");
        }
        this.materialCategoryService.deleteObjById(id);
        MaterialCategoryExample example = new MaterialCategoryExample();
        example.createCriteria().andProjectIdEqualTo(ProjectUtils.getProjectId()).andParentIdEqualTo(id);
        if (this.materialCategoryMapper.countByExample(example) > 0) {
            List list = this.materialCategoryService.queryAllObjByExample((IExample)example);
            for (MaterialCategory materialCategory : list) {
                this.materialCategoryService.deleteCascadedMaterialCategoryInfo(materialCategory.getId());
            }
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7id\u67e5\u8be2\u7269\u6599\u5206\u7c7b\u4fe1\u606f")
    @RequestMapping(value={"service/findMaterialCategoryById"})
    @ResponseBody
    public ResponseResult<MaterialCategory> findMaterialCategoryById(@RequestParam(required=true) String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new CommonException("Id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        MaterialCategory materialCategory = (MaterialCategory)this.materialCategoryService.queryObjById(id);
        return ResponseResult.success((Object)materialCategory);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6240\u6709\u7684\u7269\u6599\u5206\u7c7b\u4fe1\u606f\u53ca\u5173\u8054\u7684\u5b50\u7269\u6599\u5206\u7c7b\u4fe1\u606f")
    @RequestMapping(value={"service/findAllMaterialCategoryInfo"})
    @ResponseBody
    public ResponseResult<List<MaterialCategory>> findAllMaterialCategoryInfo() {
        MaterialCategoryExample example = new MaterialCategoryExample();
        example.setOrderByClause("CREATE_TIME DESC");
        example.createCriteria().andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(YES_INABLED).andParentIdIsNull();
        List materialCategoryList = this.materialCategoryService.queryAllObjByExample((IExample)example);
        for (MaterialCategory materialCategory : materialCategoryList) {
            materialCategory.setMaterialCatergoryList(this.materialCategoryService.queryByParentId(materialCategory.getId()));
        }
        return ResponseResult.success((Object)materialCategoryList);
    }
}

