/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialExt;
import com.els.base.material.entity.MaterialExtExample;
import com.els.base.material.entity.MaterialPropKey;
import com.els.base.material.entity.MaterialPropKeyExample;
import com.els.base.material.entity.MaterialPropKeyGroup;
import com.els.base.material.entity.MaterialPropKeyGroupExample;
import com.els.base.material.entity.MaterialPropValue;
import com.els.base.material.entity.MaterialPropValueExample;
import com.els.base.material.service.MaterialPropKeyGroupService;
import com.els.base.material.service.MaterialPropKeyService;
import com.els.base.material.service.MaterialPropValueService;
import com.els.base.material.service.MaterialService;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u7269\u6599")
@Controller
@RequestMapping(value={"material"})
public class MaterialController {
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MaterialPropKeyGroupService materialPropKeyGroupService;
    @Resource
    protected MaterialPropKeyService materialPropKeyService;
    @Resource
    protected MaterialPropValueService materialPropValueService;
    private static Logger logger = LoggerFactory.getLogger(MaterialController.class);

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Material>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Material") @RequestBody(required=false) QueryParamWapper queryParamWapper) {
        MaterialExample example = new MaterialExample();
        example.setPageView((PageView<Material>)new PageView(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CODE ASC");
        MaterialExample.Criteria criteria = example.createCriteria();
        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        PageView pageData = this.materialService.queryObjByPage((IExample)example);
        List materialList = pageData.getQueryResult();
        if (CollectionUtils.isNotEmpty((Collection)materialList)) {
            for (Material material : materialList) {
                if (StringUtils.isBlank((String)material.getCategoryId())) continue;
                MaterialPropKeyGroupExample materialPropKeyGroupExample = new MaterialPropKeyGroupExample();
                MaterialPropKeyGroupExample.Criteria materialPropKeyGroupExampleCriteria = materialPropKeyGroupExample.createCriteria();
                materialPropKeyGroupExampleCriteria.andProjectIdEqualTo(material.getProjectId());
                materialPropKeyGroupExampleCriteria.andCompanyIdEqualTo(material.getCompanyId());
                materialPropKeyGroupExampleCriteria.andMaterialCategoryIdEqualTo(material.getCategoryId());
                List materialPropKeyGroupList = this.materialPropKeyGroupService.queryAllObjByExample((IExample)materialPropKeyGroupExample);
                if (CollectionUtils.isNotEmpty((Collection)materialPropKeyGroupList)) {
                    for (MaterialPropKeyGroup materialPropKeyGroup : materialPropKeyGroupList) {
                        MaterialPropKeyExample materialPropKeyExampleExample = new MaterialPropKeyExample();
                        MaterialPropKeyExample.Criteria materialPropKeyExampleCriteria = materialPropKeyExampleExample.createCriteria();
                        materialPropKeyExampleCriteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
                        materialPropKeyExampleCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
                        materialPropKeyExampleCriteria.andPropKeyGroupIdEqualTo(materialPropKeyGroup.getId());
                        List materialPropKeyList = this.materialPropKeyService.queryAllObjByExample((IExample)materialPropKeyExampleExample);
                        if (CollectionUtils.isNotEmpty((Collection)materialPropKeyList)) {
                            for (MaterialPropKey materialPropKey : materialPropKeyList) {
                                MaterialPropValueExample materialPropValueExample = new MaterialPropValueExample();
                                MaterialPropValueExample.Criteria materialPropValueExampleCriteria = materialPropValueExample.createCriteria();
                                materialPropValueExampleCriteria.andProjectIdEqualTo(material.getProjectId());
                                materialPropValueExampleCriteria.andCompanyIdEqualTo(material.getCompanyId());
                                materialPropValueExampleCriteria.andMaterialIdEqualTo(material.getId());
                                materialPropValueExampleCriteria.andPropKeyGroupIdEqualTo(materialPropKeyGroup.getId());
                                materialPropValueExampleCriteria.andPropKeyIdEqualTo(materialPropKey.getId());
                                materialPropValueExampleCriteria.andPropKeyEqualTo(materialPropKey.getPropKey());
                                List materialPropValueList = this.materialPropValueService.queryAllObjByExample((IExample)materialPropValueExample);
                                if (!CollectionUtils.isNotEmpty((Collection)materialPropValueList) || materialPropValueList.size() <= 0) continue;
                                MaterialPropValue materialPropValue = (MaterialPropValue)materialPropValueList.get(0);
                                materialPropKey.setPropValue(materialPropValue.getPropValue());
                            }
                        }
                        materialPropKeyGroup.setMaterialPropKeyList(materialPropKeyList);
                    }
                }
                material.setMaterialPropKeyGroupList(materialPropKeyGroupList);
            }
        }
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u7269\u6599\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadMaterialExcel"})
    @ResponseBody
    public ModelAndView downloadMaterialExcel(String queryParams, HttpServletResponse response) {
        try {
            MaterialExample example = new MaterialExample();
            example.setOrderByClause("MATERIAL_CODE ASC");
            MaterialExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT);
            if (StringUtils.isNotBlank((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            }
            List materialList = this.materialService.queryAllObjByExample((IExample)example);
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)materialList, (String)"\u7269\u6599\u4e3b\u6570\u636e", null, (int)0);
            String fileName = String.format("\u7269\u6599\u4e3b\u6570\u636e%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    @ApiOperation(value="\u7269\u6599\u9009\u4e2d\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadMaterialExcelSelect"})
    @ResponseBody
    public ModelAndView downloadMaterialExcelSelect(@RequestParam(defaultValue="") String ids, HttpServletResponse response) {
        try {
            if (StringUtils.isEmpty((String)ids)) {
                throw new CommonException("\u9009\u4e2d\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
            }
            MaterialExample example = new MaterialExample();
            example.setOrderByClause("MATERIAL_CODE ASC");
            example.createCriteria().andIdIn((List)Arrays.asList(ids.split(",")));
            List materialList = this.materialService.queryAllObjByExample((IExample)example);
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)materialList, (String)"\u7269\u6599\u4e3b\u6570\u636e", null, (int)0);
            String fileName = String.format("\u7269\u6599\u4e3b\u6570\u636e%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    private void setResponseHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
    }

    public List<TitleAndModelKey> createTitleAndModelKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u53f7", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"description"));
        TitleAndModelKey createTime = ExcelUtils.createTitleAndModelKey((String)"\u521b\u5efa\u65e5\u671f", (String)"createTime");
        createTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(createTime);
        TitleAndModelKey updateTime = ExcelUtils.createTitleAndModelKey((String)"\u4e0a\u6b21\u66f4\u6539\u7684\u65e5\u671f", (String)"updateTime");
        updateTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(updateTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7c7b\u578b", (String)"materialType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7c7b\u578b\u540d\u79f0", (String)"materialTypeDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"basicUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u7ec4", (String)"productGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7ec4", (String)"materialGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7ec4", (String)"materialGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7ec4\u540d\u79f0", (String)"materialGroupDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5916\u90e8\u7269\u6599\u7ec4", (String)"externalMaterialGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5916\u90e8\u7269\u6599\u7ec4\u540d\u79f0", (String)"externalMaterialGroupDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5916\u90e8\u7269\u6599\u7ec4\u540d\u79f0", (String)"externalMaterialGroupDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5c42\u6b21", (String)"productLevel"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5c42\u6b21", (String)"productLevel"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fd\u9645\u6587\u4ef6\u53f7<EAN/UPC)", (String)"internationalDocNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7c7b\u522b", (String)"category"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51c0\u91cd", (String)"netWeight"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6bdb\u91cd<BTCI)", (String)"grossWeight"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91cd\u91cf\u5355\u4f4d", (String)"weightUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f53\u79ef", (String)"volume"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f53\u79ef\u5355\u4f4d", (String)"volumeUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5927\u5c0f/\u91cf\u7eb2", (String)"sizeDimension"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u666e\u901a\u9879\u76ee\u7c7b\u522b\u7ec4", (String)"transportationGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7684\u7a0e\u5206\u7c7b", (String)"materialTaxonomy"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6709\u5173\u5355\u4f4d\u5411\u57fa\u672c\u5355\u4f4d\u8f6c\u6362\u7684\u5206\u5b50<M\u4e2a\u4ea4\u8d27\u5355\u4f4d)NEA", (String)"unitConversionMolecule"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u4f4d\u5230\u57fa\u672c\u5355\u4f4d<BTCI)\u8f6c\u6362\u7684\u5206\u6bcd<N\u4e2a\u57fa\u672c\u5355\u4f4d)1CAR", (String)"unitConversionDenominator"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u914d\u989d\u5206\u914d\u4f7f\u7528", (String)"quotaAllocationUse"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u540e\u7eed\u7269\u6599", (String)"followUpMaterial"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u7c7b", (String)"materialCategory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u7c7b\u63cf\u8ff0", (String)"materialCategoryDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5927\u7c7b", (String)"largeClass"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5927\u7c7b\u63cf\u8ff0", (String)"largeClassDesc"));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="GET", value="\u542f\u7528/\u7981\u6b62\u7269\u6599\u4fe1\u606f")
    @RequestMapping(value={"service/isEnable"})
    @ResponseBody
    public ResponseResult<Integer> isEnable(@ApiParam(value="\u7269\u6599id") String id, @ApiParam(value="\u542f\u7528\u4f201,\u7981\u7528\u4f200") Integer isEnable) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e3a\u7a7a,\u542f\u7528/\u7981\u6b62\u4f01\u4e1a\u5931\u8d25", "id_is_blank");
        }
        int result = this.materialService.isEnable(id, isEnable);
        return ResponseResult.success((Object)result);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599")
    @RequestMapping(value={"service/findByExtPage"})
    @ResponseBody
    public ResponseResult<PageView<Material>> findByExtPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialExt") @RequestBody(required=false) QueryParamWapper queryParamWapper) {
        MaterialExtExample extexample = new MaterialExtExample();
        extexample.setPageView((PageView<MaterialExt>)new PageView(pageNo, pageSize));
        extexample.setOrderByClause("MATERIAL_CODE ASC");
        MaterialExtExample.Criteria criteria = extexample.createCriteria();
        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        MaterialExample example = new MaterialExample();
        example.setPageView((PageView<Material>)new PageView(pageNo, pageSize));
        PageView<Material> pageData = this.materialService.queryExtByPage(example, extexample);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u66f4\u6539JIT\u8ba1\u5212\u6807\u8bc6")
    @RequestMapping(value={"service/isJit"})
    @ResponseBody
    public ResponseResult<String> isJit(@RequestBody MaterialExt materialExt, @ApiParam(value="\u662f\u4f20Y,\u5426\u4f20N") String jitItem) {
        if (StringUtils.isBlank((String)materialExt.getId())) {
            throw new CommonException("id\u4e3a\u7a7a,\u66f4\u6539\u5931\u8d25", "id_is_blank");
        }
        MaterialExtExample example = new MaterialExtExample();
        example.createCriteria().andIdEqualTo(materialExt.getId()).andFactoryEqualTo(materialExt.getFactory()).andMaterialCodeEqualTo(materialExt.getMaterialCode());
        if (materialExt.getPurGroup() != null) {
            example.createCriteria().andPurGroupEqualTo(materialExt.getPurGroup());
        }
        if (jitItem.equals("0")) {
            materialExt.setJitItem("0");
        } else {
            materialExt.setJitItem("1");
        }
        this.materialService.modifyMaterialExtByExample(materialExt, example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u54c1\u7c7b")
    @RequestMapping(value={"service/findForCategory"})
    @ResponseBody
    public ResponseResult<PageView<Material>> findForCategory(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6materialCategory") @RequestParam(required=false) String materialCategory) {
        MaterialExample example = new MaterialExample();
        example.setPageView((PageView<Material>)new PageView(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CATEGORY ASC");
        MaterialExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((String)materialCategory)) {
            criteria.andMaterialCategoryLike("%" + materialCategory + "%");
        }
        criteria.andMaterialCategoryIsNotNull();
        PageView<Material> pageData = this.materialService.queryMaterialCategoryByPage(example);
        return ResponseResult.success(pageData);
    }
}

