/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.MaterialFile;
import com.els.base.material.entity.MaterialFileExample;
import com.els.base.material.service.MaterialFileService;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u7269\u6599\u6587\u4ef6\u8868")
@Controller
@RequestMapping(value={"materialFile"})
public class MaterialFileController {
    @Resource
    protected MaterialFileService materialFileService;
    private static Logger logger = LoggerFactory.getLogger(MaterialFileController.class);

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u6587\u4ef6\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterialFile materialFile) {
        this.materialFileService.addObj(materialFile);
        return ResponseResult.success((Object)materialFile.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u6587\u4ef6\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialFile materialFile) {
        Assert.isNotBlank((String)materialFile.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.materialFileService.modifyObj(materialFile);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u6587\u4ef6\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        MaterialFileExample example = new MaterialFileExample();
        example.createCriteria().andIdIn((List)ids);
        this.materialFileService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u6587\u4ef6\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialFile", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialFile>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialFileExample example = new MaterialFileExample();
        example.setOrderByClause("UPDATE_TIME DESC ");
        example.setPageView((PageView<MaterialFile>)new PageView(pageNo, pageSize));
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialFileService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u8bbe\u8ba1\u6587\u6863\u67e5\u8be2\u6279\u91cf\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ModelAndView downloadExcel(String queryParams, HttpServletResponse response) {
        try {
            MaterialFileExample example = new MaterialFileExample();
            example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
            if (StringUtils.isNotBlank((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            }
            List materialFileList = this.materialFileService.queryAllObjByExample((IExample)example);
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)materialFileList, (String)"\u8bbe\u8ba1\u6587\u6863", null, (int)0);
            String fileName = String.format("\u8bbe\u8ba1\u6587\u6863%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    @ApiOperation(value="\u8bbe\u8ba1\u6587\u6863\u67e5\u8be2\u9009\u4e2d\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcelSelect"})
    @ResponseBody
    public ModelAndView downloadExcelSelect(@RequestParam(defaultValue="") String ids, HttpServletResponse response) {
        try {
            if (StringUtils.isEmpty((String)ids)) {
                throw new CommonException("\u9009\u4e2d\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
            }
            MaterialFileExample example = new MaterialFileExample();
            example.createCriteria().andIdIn((List)Arrays.asList(ids.split(",")));
            List materialFileList = this.materialFileService.queryAllObjByExample((IExample)example);
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)materialFileList, (String)"\u8bbe\u8ba1\u6587\u6863", null, (int)0);
            String fileName = String.format("\u8bbe\u8ba1\u6587\u6863%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    public List<TitleAndModelKey> createTitleAndModelKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6587\u6863\u7f16\u7801", (String)"fileCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6587\u6863\u540d\u79f0", (String)"fileName"));
        TitleAndModelKey updateTime = ExcelUtils.createTitleAndModelKey((String)"\u66f4\u65b0\u65f6\u95f4", (String)"updateTime");
        updateTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(updateTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"description"));
        return titleAndModelKeys;
    }

    private void setResponseHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u6700\u65b0\u7248\u672c\u6587\u6863")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialFile", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findLatestVersionFile"})
    @ResponseBody
    public ResponseResult<List<MaterialFile>> findLatestVersionFile(@RequestParam(required=true) String materialId) {
        return ResponseResult.success(this.materialFileService.queryByMaterialIdList(Arrays.asList(materialId)));
    }
}

