/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.material.entity.MaterialPropKey;
import com.els.base.material.entity.MaterialPropKeyExample;
import com.els.base.material.entity.MaterialPropValueExample;
import com.els.base.material.service.MaterialPropKeyService;
import com.els.base.material.service.MaterialPropValueService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7269\u6599\u5c5e\u6027key")
@Controller
@RequestMapping(value={"materialPropKey"})
public class MaterialPropKeyController {
    @Resource
    protected MaterialPropKeyService materialPropKeyService;
    @Resource
    protected MaterialPropValueService materialPropValueService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u5c5e\u6027key")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterialPropKey materialPropKey) {
        materialPropKey.setId(null);
        materialPropKey.setProjectId(ProjectUtils.getProjectId());
        materialPropKey.setCompanyId(CompanyUtils.currentCompanyId());
        this.materialPropKeyService.addObj(materialPropKey);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u5c5e\u6027key")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialPropKey materialPropKey) {
        materialPropKey.setProjectId(ProjectUtils.getProjectId());
        materialPropKey.setCompanyId(CompanyUtils.currentCompanyId());
        if (StringUtils.isBlank((String)materialPropKey.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "id_is_blank");
        }
        this.materialPropKeyService.modifyObj(materialPropKey);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u5c5e\u6027key")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25", "id_is_blank");
        }
        this.materialPropKeyService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u5c5e\u6027key")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialPropKey>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialPropKey") @RequestBody(required=false) List<QueryParam> params) {
        MaterialPropKeyExample example = new MaterialPropKeyExample();
        example.setPageView((PageView<MaterialPropKey>)new PageView(pageNo, pageSize));
        MaterialPropKeyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(params)) {
            CriteriaUtils.addCriterion((Object)criteria, params);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        PageView pageData = this.materialPropKeyService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eMaterialPropKeyId\u67e5\u8be2\u5c5e\u6027key\u662f\u5426\u88ab\u6709\u7269\u6599\u5728\u4f7f\u7528")
    @RequestMapping(value={"service/findByMaterialPropKeyIdIsDelete"})
    @ResponseBody
    public ResponseResult<String> findByMaterialPropKeyIdIsDelete(@RequestParam(required=true) String materialPropKeyId) {
        if (StringUtils.isBlank((String)materialPropKeyId)) {
            throw new CommonException("id \u4e3a\u7a7a", "id_is_blank");
        }
        MaterialPropValueExample example = new MaterialPropValueExample();
        MaterialPropValueExample.Criteria criteria = example.createCriteria();
        criteria.andPropKeyIdEqualTo(materialPropKeyId);
        List materialPropValueList = this.materialPropValueService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)materialPropValueList)) {
            return ResponseResult.success((Object)"false");
        }
        return ResponseResult.success((Object)"true");
    }
}

