/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.material.dao.CateoryPurchaserMapper;
import com.els.base.material.entity.CateoryPurchaser;
import com.els.base.material.entity.CateoryPurchaserExample;
import com.els.base.material.service.CateoryPurchaserService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCateoryPurchaserService")
public class CateoryPurchaserServiceImpl
implements CateoryPurchaserService {
    @Resource
    protected CateoryPurchaserMapper cateoryPurchaserMapper;

    @CacheEvict(value={"cateoryPurchaser"}, allEntries=true)
    public void addObj(CateoryPurchaser t) {
        this.cateoryPurchaserMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"cateoryPurchaser"}, allEntries=true)
    public void addAll(List<CateoryPurchaser> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.cateoryPurchaserMapper.insertBatch(list);
    }

    @CacheEvict(value={"cateoryPurchaser"}, allEntries=true)
    public void deleteObjById(String id) {
        this.cateoryPurchaserMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"cateoryPurchaser"}, allEntries=true)
    public void deleteByExample(CateoryPurchaserExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.cateoryPurchaserMapper.deleteByExample(example);
    }

    @CacheEvict(value={"cateoryPurchaser"}, allEntries=true)
    public void modifyObj(CateoryPurchaser t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.cateoryPurchaserMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"cateoryPurchaser"}, keyGenerator="redisKeyGenerator")
    public CateoryPurchaser queryObjById(String id) {
        return this.cateoryPurchaserMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"cateoryPurchaser"}, keyGenerator="redisKeyGenerator")
    public List<CateoryPurchaser> queryAllObjByExample(CateoryPurchaserExample example) {
        return this.cateoryPurchaserMapper.selectByExample(example);
    }

    @Cacheable(value={"cateoryPurchaser"}, keyGenerator="redisKeyGenerator")
    public PageView<CateoryPurchaser> queryObjByPage(CateoryPurchaserExample example) {
        PageView<CateoryPurchaser> pageView = example.getPageView();
        pageView.setQueryResult(this.cateoryPurchaserMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void modifyObjByExample(CateoryPurchaser cateoryPurchaser, CateoryPurchaserExample example) {
        this.cateoryPurchaserMapper.updateByExampleSelective(cateoryPurchaser, example);
    }
}

