/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.materialprice.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.materialprice.dao.MaterialPriceMapper;
import com.els.base.materialprice.entity.MaterialPrice;
import com.els.base.materialprice.entity.MaterialPriceExample;
import com.els.base.materialprice.service.MaterialPriceService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMaterialPriceService")
public class MaterialPriceServiceImpl
implements MaterialPriceService {
    @Resource
    protected MaterialPriceMapper materialPriceMapper;

    @CacheEvict(value={"materialPrice"}, allEntries=true)
    public void addObj(MaterialPrice t) {
        this.materialPriceMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"materialPrice"}, allEntries=true)
    public void addAll(List<MaterialPrice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.materialPriceMapper.insertBatch(list);
    }

    @CacheEvict(value={"materialPrice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialPriceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialPrice"}, allEntries=true)
    public void deleteByExample(MaterialPriceExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialPriceMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialPrice"}, allEntries=true)
    public void modifyObj(MaterialPrice t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.materialPriceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialPrice"}, keyGenerator="redisKeyGenerator")
    public MaterialPrice queryObjById(String id) {
        return this.materialPriceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialPrice"}, keyGenerator="redisKeyGenerator")
    public List<MaterialPrice> queryAllObjByExample(MaterialPriceExample example) {
        return this.materialPriceMapper.selectByExample(example);
    }

    @Cacheable(value={"materialPrice"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialPrice> queryObjByPage(MaterialPriceExample example) {
        PageView<MaterialPrice> pageView = example.getPageView();
        pageView.setQueryResult(this.materialPriceMapper.selectByExampleByPage(example));
        return pageView;
    }
}

