/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.materialstore.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.material.entity.Material;
import com.els.base.material.service.MaterialService;
import com.els.base.materialstore.dao.MaterialStoreMapper;
import com.els.base.materialstore.entity.MaterialStore;
import com.els.base.materialstore.entity.MaterialStoreExample;
import com.els.base.materialstore.enums.CheckStoreEnum;
import com.els.base.materialstore.service.MaterialStoreService;
import com.els.base.materialstore.web.vo.CheckStoreVO;
import com.els.base.materialstoresetting.entity.MaterialStoreSetting;
import com.els.base.materialstoresetting.service.MaterialStoreSettingService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMaterialStoreService")
public class MaterialStoreServiceImpl
implements MaterialStoreService {
    @Resource
    protected MaterialStoreMapper materialStoreMapper;
    @Resource
    protected MaterialStoreSettingService materialStoreSettingService;
    @Resource
    protected MaterialService materialService;

    @CacheEvict(value={"materialStore"}, allEntries=true)
    public void addObj(MaterialStore t) {
        this.materialStoreMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"materialStore"}, allEntries=true)
    public void addAll(List<MaterialStore> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.materialStoreMapper.insertBatch(list);
    }

    @CacheEvict(value={"materialStore"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialStoreMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialStore"}, allEntries=true)
    public void deleteByExample(MaterialStoreExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialStoreMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialStore"}, allEntries=true)
    public void modifyObj(MaterialStore t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.materialStoreMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialStore"}, keyGenerator="redisKeyGenerator")
    public MaterialStore queryObjById(String id) {
        return this.materialStoreMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialStore"}, keyGenerator="redisKeyGenerator")
    public List<MaterialStore> queryAllObjByExample(MaterialStoreExample example) {
        return this.materialStoreMapper.selectByExample(example);
    }

    @Cacheable(value={"materialStore"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialStore> queryObjByPage(MaterialStoreExample example) {
        PageView<MaterialStore> pageView = example.getPageView();
        pageView.setQueryResult(this.materialStoreMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"materialStore"}, keyGenerator="redisKeyGenerator")
    public boolean checkStoreNumber(MaterialStore materialStore) {
        List<MaterialStore> materialStores = this.getListByMateriaCode(materialStore.getMaterialCode(), materialStore.getStoreId());
        AtomicInteger code = new AtomicInteger(0);
        materialStores.forEach(mk -> {
            if (0 >= mk.getStoreNumber() || materialStore.getStoreNumber() >= mk.getStoreNumber() - mk.getLockStoreNumber()) {
                code.set(1);
            }
        });
        return 1 == code.get();
    }

    @Override
    @Cacheable(value={"materialStore"}, keyGenerator="redisKeyGenerator")
    public boolean checkStoreNumber(List<MaterialStore> materialStores) {
        Assert.isNotEmpty(materialStores, (String)"\u64cd\u4f5c\u7684\u6570\u636e\u9879\u4e3a\u7a7a\uff01\u68c0\u67e5\u5931\u8d25");
        AtomicInteger code = new AtomicInteger(0);
        materialStores.forEach(materialStore -> {
            if (this.checkStoreNumber((MaterialStore)materialStore)) {
                code.set(1);
            }
        });
        return 1 == code.get();
    }

    @Override
    @CacheEvict(value={"materialStore"}, allEntries=true)
    public void callOutStore(MaterialStore materialStore) {
        List<MaterialStore> materialStores = this.getListByMateriaCode(materialStore.getMaterialCode(), materialStore.getStoreId());
        int number = materialStore.getStoreNumber();
        materialStores.forEach(mk -> {
            if (0 >= mk.getLockStoreNumber() || 0 >= mk.getStoreNumber() || number >= mk.getLockStoreNumber() || number >= mk.getStoreNumber()) {
                Assert.isNotNull(null, (String)"\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u51fa\u5e93");
            }
            mk.setLockStoreNumber(mk.getLockStoreNumber() - number);
            mk.setStoreNumber(mk.getStoreNumber() - number);
            this.modifyObj((MaterialStore)mk);
        });
    }

    @Override
    @CacheEvict(value={"materialStore"}, allEntries=true)
    @Transactional
    public void callOutStore(List<MaterialStore> materialStores) {
        Assert.isNotEmpty(materialStores, (String)"\u64cd\u4f5c\u7684\u6570\u636e\u9879\u4e3a\u7a7a\uff01\u68c0\u67e5\u5931\u8d25");
        materialStores.forEach(materialStore -> this.callOutStore((MaterialStore)materialStore));
    }

    @Override
    @CacheEvict(value={"materialStore"}, allEntries=true)
    public void callInStore(MaterialStore materialStore) {
        MaterialStoreExample materialStoreExample = new MaterialStoreExample();
        materialStoreExample.createCriteria().andMaterialCodeEqualTo(materialStore.getMaterialCode()).andStoreIdEqualTo(materialStore.getStoreId());
        List<MaterialStore> materialStores = this.materialStoreMapper.selectByExample(materialStoreExample);
        if (null == materialStores || 0 >= materialStores.size()) {
            this.setMaterialInfo(materialStore);
            this.setDepartmentInfo(materialStore);
            this.addObj(materialStore);
        } else {
            materialStores.forEach(mk -> {
                if (0 == mk.getStoreNumber()) {
                    mk.setStoreNumber(materialStore.getStoreNumber());
                } else {
                    mk.setStoreNumber(mk.getStoreNumber() + materialStore.getStoreNumber());
                }
                this.modifyObj((MaterialStore)mk);
            });
        }
    }

    private void setDepartmentInfo(MaterialStore materialStore) {
        MaterialStoreSetting materialStoreSetting = (MaterialStoreSetting)this.materialStoreSettingService.queryObjById(materialStore.getStoreId());
        materialStore.setCompanyId(materialStoreSetting.getCompanyId());
        materialStore.setCompanyName(materialStoreSetting.getCompanyName());
        materialStore.setDepartmentId(materialStoreSetting.getDepartmentId());
        materialStore.setDepartmentName(materialStoreSetting.getDepartmentName());
        materialStore.setStoreName(materialStoreSetting.getStoreName());
        materialStore.setMobilePhone(materialStoreSetting.getMobilePhone());
        materialStore.setWorkNum(materialStoreSetting.getWorkNum());
    }

    @Override
    @CacheEvict(value={"materialStore"}, allEntries=true)
    @Transactional
    public void callInStore(List<MaterialStore> materialStores) {
        Assert.isNotEmpty(materialStores, (String)"\u64cd\u4f5c\u7684\u6570\u636e\u9879\u4e3a\u7a7a\uff01\u68c0\u67e5\u5931\u8d25");
        materialStores.forEach(materialStore -> this.callInStore((MaterialStore)materialStore));
    }

    @Override
    @CacheEvict(value={"materialStore"}, allEntries=true)
    public void lockStoreNumber(MaterialStore materialStore) {
        if (this.checkStoreNumber(materialStore)) {
            Assert.isNotNull(null, (String)"\u6682\u65e0\u53ef\u7528\u5e93\u5b58\uff0c\u5e93\u5b58\u9501\u5b9a\u5931\u8d25");
        }
        List<MaterialStore> materialStores = this.getListByMateriaCode(materialStore.getMaterialCode(), materialStore.getStoreId());
        materialStores.forEach(mk -> {
            mk.setLockStoreNumber(mk.getLockStoreNumber() + materialStore.getStoreNumber());
            this.modifyObj((MaterialStore)mk);
        });
    }

    @Override
    @CacheEvict(value={"materialStore"}, allEntries=true)
    @Transactional
    public void lockStoreNumber(List<MaterialStore> materialStores) {
        Assert.isNotEmpty(materialStores, (String)"\u64cd\u4f5c\u7684\u6570\u636e\u9879\u4e3a\u7a7a\uff01\u9501\u5e93\u5b58\u5931\u8d25");
        materialStores.forEach(materialStore -> this.lockStoreNumber((MaterialStore)materialStore));
    }

    @Override
    public List<CheckStoreVO> checkStoreNumberReturnList(List<CheckStoreVO> checkStoreVOS) {
        AtomicInteger code = new AtomicInteger(0);
        checkStoreVOS.forEach(checkStore -> {
            MaterialStore materialStore = new MaterialStore();
            materialStore.setMaterialCode(checkStore.getMaterialCode());
            materialStore.setStoreNumber(checkStore.getGetNumber());
            materialStore.setStoreId(checkStore.getStoreId());
            if (this.checkStoreNumber(materialStore)) {
                checkStore.setIsOk(CheckStoreEnum.NO.getCode());
            } else {
                checkStore.setIsOk(CheckStoreEnum.YES.getCode());
            }
        });
        return checkStoreVOS;
    }

    @Cacheable(value={"materialStore"}, keyGenerator="redisKeyGenerator")
    public List<MaterialStore> getListByMateriaCode(String materialCode, String storeId) {
        MaterialStoreExample materialStoreExample = new MaterialStoreExample();
        materialStoreExample.createCriteria().andMaterialCodeEqualTo(materialCode).andStoreIdEqualTo(storeId);
        List<MaterialStore> materialStores = this.materialStoreMapper.selectByExample(materialStoreExample);
        Assert.isNotEmpty(materialStores, (String)"\u5c1a\u672a\u627e\u5230\u5bf9\u5e94\u7269\u6599");
        return materialStores;
    }

    private void setMaterialInfo(MaterialStore materialStore) {
        Material material = this.materialService.queryObjByCode(materialStore.getMaterialCode());
        materialStore.setCategoryId(material.getCategoryId());
        materialStore.setCategoryName(material.getCategoryName());
        materialStore.setMaterialName(material.getMaterialName());
        materialStore.setMaterialCode(material.getMaterialCode());
        materialStore.setMaterialSpecification(material.getMaterialSpecification());
        materialStore.setDescription(material.getDescription());
        materialStore.setCurrency(material.getCurrency());
        materialStore.setCreateTime(material.getCreateTime());
        materialStore.setUpdateTime(material.getUpdateTime());
        materialStore.setCreateUserName(material.getCreateUserName());
        materialStore.setCreateUserId(material.getCreateUserId());
        materialStore.setBrandName(material.getBrandName());
        materialStore.setLockStoreNumber(0);
    }
}

