/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.materialstoresetting.service.impl;

import com.els.base.company.entity.Department;
import com.els.base.company.service.DepartmentService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.materialstoresetting.dao.MaterialStoreSettingMapper;
import com.els.base.materialstoresetting.entity.MaterialStoreSetting;
import com.els.base.materialstoresetting.entity.MaterialStoreSettingExample;
import com.els.base.materialstoresetting.service.MaterialStoreSettingService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMaterialStoreSettingService")
public class MaterialStoreSettingServiceImpl
implements MaterialStoreSettingService {
    @Resource
    protected MaterialStoreSettingMapper materialStoreSettingMapper;
    @Resource
    private DepartmentService departmentService;

    @CacheEvict(value={"materialStoreSetting"}, allEntries=true)
    public void addObj(MaterialStoreSetting t) {
        this.checkTypeExist(t);
        this.materialStoreSettingMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"materialStoreSetting"}, allEntries=true)
    public void addAll(List<MaterialStoreSetting> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            this.checkTypeExist((MaterialStoreSetting)item);
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.materialStoreSettingMapper.insertBatch(list);
    }

    @CacheEvict(value={"materialStoreSetting"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialStoreSettingMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialStoreSetting"}, allEntries=true)
    public void deleteByExample(MaterialStoreSettingExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialStoreSettingMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialStoreSetting"}, allEntries=true)
    public void modifyObj(MaterialStoreSetting t) {
        this.checkTypeExist(t);
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.materialStoreSettingMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialStoreSetting"}, keyGenerator="redisKeyGenerator")
    public MaterialStoreSetting queryObjById(String id) {
        return this.materialStoreSettingMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialStoreSetting"}, keyGenerator="redisKeyGenerator")
    public List<MaterialStoreSetting> queryAllObjByExample(MaterialStoreSettingExample example) {
        return this.materialStoreSettingMapper.selectByExample(example);
    }

    @Cacheable(value={"materialStoreSetting"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialStoreSetting> queryObjByPage(MaterialStoreSettingExample example) {
        PageView<MaterialStoreSetting> pageView = example.getPageView();
        pageView.setQueryResult(this.materialStoreSettingMapper.selectByExampleByPage(example));
        return pageView;
    }

    private void checkTypeExist(MaterialStoreSetting storeSetting) {
        MaterialStoreSettingExample example = new MaterialStoreSettingExample();
        if (StringUtils.isNotBlank((String)storeSetting.getId())) {
            if (StringUtils.isBlank((String)storeSetting.getDepartmentId())) {
                example.createCriteria().andCompanyIdEqualTo(storeSetting.getCompanyId()).andStoreTypeEqualTo(storeSetting.getStoreType()).andIdNotEqualTo(storeSetting.getId());
            } else {
                example.createCriteria().andCompanyIdEqualTo(storeSetting.getCompanyId()).andDepartmentIdEqualTo(storeSetting.getDepartmentId()).andStoreTypeEqualTo(storeSetting.getStoreType()).andIdNotEqualTo(storeSetting.getId());
            }
        } else if (StringUtils.isBlank((String)storeSetting.getDepartmentId())) {
            example.createCriteria().andCompanyIdEqualTo(storeSetting.getCompanyId()).andStoreTypeEqualTo(storeSetting.getStoreType());
        } else {
            example.createCriteria().andCompanyIdEqualTo(storeSetting.getCompanyId()).andDepartmentIdEqualTo(storeSetting.getDepartmentId()).andStoreTypeEqualTo(storeSetting.getStoreType());
        }
        int count = this.materialStoreSettingMapper.countByExample(example);
        if (count > 0) {
            Assert.isNotNull(null, (String)"\u5df2\u5b58\u5728\u4ed3\u5e93\u7c7b\u578b\uff01\u65b0\u589e\u5931\u8d25");
        }
    }

    @Override
    public List<MaterialStoreSetting> getLists(String userId) {
        List institution = this.departmentService.getDepartIdsByUserId(userId);
        List institutionIds = institution.stream().map(Department::getId).collect(Collectors.toList());
        List departments = this.departmentService.getInstitutionIdsByUserId(userId);
        List departmentIds = departments.stream().map(Department::getId).collect(Collectors.toList());
        MaterialStoreSettingExample example = new MaterialStoreSettingExample();
        example.createCriteria().andInstitutionIdIn(institutionIds);
        MaterialStoreSettingExample.Criteria criteria = example.createCriteria().andDepartmentIdIn(departmentIds);
        example.or(criteria);
        return this.queryAllObjByExample(example);
    }
}

