-- ----------------------------
-- 物料价格表
-- ----------------------------
-- DROP TABLE "T_BASE_MATERIAL_PRICE";
CREATE TABLE "T_BASE_MATERIAL_PRICE"
(
    "ID"                       VARCHAR2(32 BYTE) NOT NULL,
    "MATERIAL_PRICE_NO"        VARCHAR2(255 BYTE),
    "MATERIAL_PRICE_ORIGIN"    VARCHAR2(255 BYTE),
    "BIDDING_NO"               VARCHAR2(255 BYTE),
    "BIDDING_ITEM_NO"          VARCHAR2(255 BYTE),
    "ENQUIRY_NO"               VARCHAR2(255 BYTE),
    "ENQUIRY_ITEM_NO"          VARCHAR2(255 BYTE),
    "TAX_RATE"                 NUMBER(11, 2),
    "TAX_CODE"                 VARCHAR2(255 BYTE),
    "APPROVE_CODE"             VARCHAR2(255 BYTE),
    "APPROVE_STATUS"           VARCHAR2(255 BYTE),
    "CATEGORY_ID"              VARCHAR2(32 BYTE),
    "CATEGORY_NAME"            VARCHAR2(255 BYTE),
    "MATERIAL_NAME"            VARCHAR2(255 BYTE),
    "MATERIAL_CODE"            VARCHAR2(255 BYTE),
    "MATERIAL_SPECIFICATION"   VARCHAR2(255 BYTE),
    "DESCRIPTION"              NVARCHAR2(255),
    "CURRENCY"                 NVARCHAR2(255),
    "PRICE"                    NUMBER(11, 2),
    "WEIGHT"                   VARCHAR2(20 BYTE),
    "FACTORY_NAME"             VARCHAR2(255 BYTE),
    "BASIC_UNIT"               VARCHAR2(255 BYTE),
    "ORDER_UNIT"               VARCHAR2(255 BYTE),
    "MINIMUM_PACKING_QUANTITY" VARCHAR2(255 BYTE),
    "MINIMUN_ORDER_QUANTITY"   VARCHAR2(255 BYTE),
    "PRICE_UNIT"               VARCHAR2(255 BYTE),
    "FIGURE_TYPE"              NVARCHAR2(255),
    "MATERIAL_TYPE"            NVARCHAR2(255),
    "SAFE_STOCK"               NVARCHAR2(255),
    "NORMAL_PRICE"             NUMBER(11, 2),
    "BRAND_NAME"               NVARCHAR2(255),
    "FACTORY"                  VARCHAR2(255 CHAR),
    "PLACE_OF_STOCK"           VARCHAR2(50 BYTE),
    "CATEGORY"                 VARCHAR2(255 CHAR),
    "NET_WEIGHT"               NUMBER(11, 2),
    "GROSS_WEIGHT"             NUMBER(11, 2),
    "WEIGHT_UNIT"              VARCHAR2(255 CHAR),
    "VOLUME"                   VARCHAR2(255 CHAR),
    "VOLUME_UNIT"              VARCHAR2(255 CHAR),
    "SIZE_DIMENSION"           VARCHAR2(255 BYTE),
    "LENGTH_WIDTH_HEIGHT"      NUMBER(11, 2),
    "MATERIAL_CATEGORY"        VARCHAR2(255 CHAR),
    "MATERIAL_CATEGORY_DESC"   VARCHAR2(255 CHAR),
    "BATCH_SIZE"               VARCHAR2(255 CHAR),
    "MATERIAL_GROUP"           VARCHAR2(255 BYTE),
    "MATERIAL_GROUP_DESC"      VARCHAR2(255 BYTE),
    "MATERIAL_TYPE_DESC"       VARCHAR2(255 BYTE),
    "MATERIAL_COLOUR"          VARCHAR2(255 BYTE),
    "VALID_START_TIME"         DATE,
    "VALID_END_TIME"           DATE,
    "CREATE_TIME"              DATE,
    "UPDATE_TIME"              DATE,
    "CREATE_USER_ID"           VARCHAR2(255 CHAR),
    "UPDATE_USER_ID"           VARCHAR2(255 CHAR),
    "CREATE_USER_NAME"         VARCHAR2(255 CHAR),
    "UPDATE_USER_NAME"         VARCHAR2(255 CHAR),
    "CATEGORY_CODE"            VARCHAR2(255 BYTE),
    "TOTAL_GROUPID"            VARCHAR2(32 BYTE),
    "TOTAL_GROUP_NAME"         VARCHAR2(255 BYTE),
    "ACCOUNT_SET_ID"           VARCHAR2(32 BYTE),
    "ACCOUNT_SET_NAME"         VARCHAR2(255 BYTE),
    "ACCOUNT_CODE"             VARCHAR2(255 BYTE),
    "INSTITUTIONS_ID"          VARCHAR2(32 BYTE),
    "INSTITUTIONS_NAME"        VARCHAR2(255 BYTE),
    "IN_THE_ORGANIZATION_ID"   VARCHAR2(255 BYTE),
    "IN_THE_ORGANIZATION_NAME" VARCHAR2(255 BYTE),
    "DEPART_ID"                VARCHAR2(32 BYTE),
    "DEPART_NAME"              VARCHAR2(255 BYTE)
);

COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_PRICE_NO" IS '物料价格编号';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_PRICE_ORIGIN" IS '物料价格来源，1招标，2询价，3导入';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."BIDDING_NO" IS '招标单号';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."BIDDING_ITEM_NO" IS '招标行号';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."ENQUIRY_NO" IS '询价单号';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."ENQUIRY_ITEM_NO" IS '询价单行号';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."TAX_CODE" IS '税率编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."APPROVE_CODE" IS '审批编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."APPROVE_STATUS" IS '审批状态';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."CATEGORY_ID" IS '物料分类id';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."CATEGORY_NAME" IS '物料分类名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_SPECIFICATION" IS '物料规格';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."DESCRIPTION" IS '物料描述';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."CURRENCY" IS '币种';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."PRICE" IS '物料价格';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."WEIGHT" IS '物料单重';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."FACTORY_NAME" IS '工厂名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."BASIC_UNIT" IS '基本单位';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."ORDER_UNIT" IS '订单单位';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MINIMUM_PACKING_QUANTITY" IS '最小包装量';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MINIMUN_ORDER_QUANTITY" IS '最小订单量';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."PRICE_UNIT" IS '价格单位';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."FIGURE_TYPE" IS '图号';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_TYPE" IS '物料类型';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."SAFE_STOCK" IS '安全库存';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."NORMAL_PRICE" IS '标准价格';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."BRAND_NAME" IS '品牌';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."FACTORY" IS '工厂';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."PLACE_OF_STOCK" IS '库存地点';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."CATEGORY" IS '类别';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."NET_WEIGHT" IS '净重';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."GROSS_WEIGHT" IS '毛重';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."WEIGHT_UNIT" IS '重量单位';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."VOLUME" IS '体积';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."VOLUME_UNIT" IS '体积单位';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."SIZE_DIMENSION" IS '大小/量纲';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."LENGTH_WIDTH_HEIGHT" IS '长*宽*高';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_CATEGORY" IS '品类';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_CATEGORY_DESC" IS '品类描述';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."BATCH_SIZE" IS '批量大小';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_GROUP" IS '物料组';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_GROUP_DESC" IS '物料组描述';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_TYPE_DESC" IS '物料类型名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."MATERIAL_COLOUR" IS '物料颜色';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."VALID_START_TIME" IS '价格有效期开始';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."VALID_END_TIME" IS '价格有效期结束';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."CREATE_USER_ID" IS '创建人ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."UPDATE_USER_ID" IS '更新人ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."CREATE_USER_NAME" IS '更新人ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."UPDATE_USER_NAME" IS '更新人ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."CATEGORY_CODE" IS '物料分类编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."TOTAL_GROUPID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_MATERIAL_PRICE"."DEPART_NAME" IS '部门名称';
COMMENT ON TABLE "T_BASE_MATERIAL_PRICE" IS '物料价格表';


ALTER TABLE "T_BASE_MATERIAL_PRICE"
    ADD PRIMARY KEY ("ID");

