/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.command;

import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.entity.MaterialApplyExample;
import com.els.base.material.entity.MaterialApplyItemExample;
import com.els.base.material.service.MaterialApplyItemService;
import com.els.base.material.service.MaterialApplyService;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.utils.SpringContextHolder;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class MaterialApplyDeleteCmd
extends BaseCommand<String> {
    private List<String> ids;

    public MaterialApplyDeleteCmd(List<String> ids) {
        this.ids = ids;
    }

    @Transactional
    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.ids);
        this.process(this.ids);
        return null;
    }

    private void process(List<String> ids) {
        MaterialApplyService materialApplyService = (MaterialApplyService)SpringContextHolder.getOneBean(MaterialApplyService.class);
        MaterialApplyItemService materialApplyItemService = (MaterialApplyItemService)SpringContextHolder.getOneBean(MaterialApplyItemService.class);
        MaterialApplyItemExample materialApplyItemExample = new MaterialApplyItemExample();
        materialApplyItemExample.createCriteria().andApplyIdIn((List)ids);
        materialApplyItemService.deleteByExample((IExample)materialApplyItemExample);
        MaterialApplyExample example = new MaterialApplyExample();
        example.createCriteria().andIdIn((List)ids);
        materialApplyService.deleteByExample((IExample)example);
    }

    private void check(List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01");
        MaterialApplyService materialApplyService = (MaterialApplyService)SpringContextHolder.getOneBean(MaterialApplyService.class);
        MaterialApplyExample example = new MaterialApplyExample();
        MaterialApplyExample.Criteria criteria1 = example.createCriteria().andIdIn((List)ids).andApproveStatusEqualTo(ApproveStatusEnum.APPLYING.getValue());
        MaterialApplyExample.Criteria criteria2 = example.createCriteria().andIdIn((List)ids).andApproveStatusEqualTo(ApproveStatusEnum.APPROVE_PASS.getValue());
        example.or(criteria2);
        int i = materialApplyService.countByExample(example);
        if (i > 0) {
            throw new CommonException("\u63d0\u4ea4\u7684\u5355\u636e\u53ef\u80fd\u5305\u542b\u4e86\u5ba1\u6279\u4e2d\u6216\u8005\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }
}

