/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.dao.MaterialApplyMapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialApply;
import com.els.base.material.entity.MaterialApplyExample;
import com.els.base.material.entity.MaterialApplyItem;
import com.els.base.material.entity.MaterialApplyItemExample;
import com.els.base.material.service.MaterialApplyItemService;
import com.els.base.material.service.MaterialApplyService;
import com.els.base.material.service.MaterialService;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMaterialApplyService")
public class MaterialApplyServiceImpl
implements MaterialApplyService,
ITaskListener {
    @Resource
    protected MaterialApplyMapper materialApplyMapper;
    @Resource
    protected MaterialApplyItemService materialApplyItemService;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected GenerateCodeService generateCodeService;

    @CacheEvict(value={"materialApply"}, allEntries=true)
    @Transactional
    public Map<String, Object> processResult(Map<String, Object> objectMap) throws Exception {
        return null;
    }

    @CacheEvict(value={"materialApply"}, allEntries=true)
    @Transactional
    public void listen(TaskOperateEvent event) {
        String businessId = event.getBusinessId();
        Assert.isNotBlank((String)businessId, (String)"\u7269\u6599\u7533\u8bf7\u5355\u5355\u636eID\u4e3a\u7a7a");
        MaterialApplyExample applyExample = new MaterialApplyExample();
        applyExample.createCriteria().andIdEqualTo(event.getBusinessId());
        MaterialApply apply = new MaterialApply();
        apply.setId(businessId);
        if (event.isFinished() && event.isPass()) {
            apply.setApproveStatus(ApproveStatusEnum.APPROVE_PASS.getValue());
            this.writeToMaterial(event);
            apply.setWriteFlag(Constant.YES_INT);
        } else if (event.isFinished() && !event.isPass()) {
            apply.setApproveStatus(ApproveStatusEnum.APPROVE_REFUSE.getValue());
        }
        this.materialApplyMapper.updateByExampleSelective(apply, applyExample);
    }

    private void writeToMaterial(TaskOperateEvent event) {
        MaterialApplyItemExample example = new MaterialApplyItemExample();
        String businessId = event.getBusinessId();
        example.createCriteria().andApplyIdEqualTo(businessId);
        List materialApplyItems = this.materialApplyItemService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)materialApplyItems)) {
            ArrayList<Material> list = new ArrayList<Material>();
            for (int i = 0; i < materialApplyItems.size(); ++i) {
                MaterialApplyItem materialApplyItem = (MaterialApplyItem)materialApplyItems.get(i);
                Material material = new Material();
                BeanUtils.copyProperties((Object)materialApplyItem, (Object)material);
                material.setCategory(materialApplyItem.getCategoryCode());
                material.setIsEnable(Constant.YES_INT);
                material.setSapCreateTime(new Date());
                material.setCreateTime(new Date());
                User assigneeUser = event.getAssigneeUser();
                material.setCreateUserName(assigneeUser.getLoginName());
                material.setCreateUserId(assigneeUser.getId());
                material.setId(UUIDGenerator.generateUUID());
                material.setApplyId(materialApplyItem.getApplyId());
                material.setApplyNo(materialApplyItem.getApplyNo());
                material.setApplyItemNo(i + 1);
                String materialCode = this.generateCodeService.getNextCode("MATERIAL_CODE");
                material.setMaterialCode(materialCode);
                materialApplyItem.setMaterialCode(materialCode);
                this.materialApplyItemService.modifyObj(materialApplyItem);
                list.add(material);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                this.materialService.addAll(list);
            }
        }
    }

    @Override
    @Cacheable(value={"materialApply"}, keyGenerator="redisKeyGenerator")
    public int countByExample(MaterialApplyExample example) {
        return this.materialApplyMapper.countByExample(example);
    }

    @Override
    @CacheEvict(value={"materialApply"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(MaterialApply record, MaterialApplyExample example) {
        return this.materialApplyMapper.updateByExampleSelective(record, example);
    }

    @Transactional
    @CacheEvict(value={"materialApply"}, allEntries=true)
    public void addObj(MaterialApply t) {
        this.materialApplyMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"materialApply"}, allEntries=true)
    public void addAll(List<MaterialApply> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.materialApplyMapper.insertBatch(list);
    }

    @CacheEvict(value={"materialApply"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialApplyMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialApply"}, allEntries=true)
    public void deleteByExample(MaterialApplyExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialApplyMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialApply"}, allEntries=true)
    public void modifyObj(MaterialApply t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.materialApplyMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialApply"}, keyGenerator="redisKeyGenerator")
    public MaterialApply queryObjById(String id) {
        return this.materialApplyMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialApply"}, keyGenerator="redisKeyGenerator")
    public List<MaterialApply> queryAllObjByExample(MaterialApplyExample example) {
        return this.materialApplyMapper.selectByExample(example);
    }

    @Cacheable(value={"materialApply"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialApply> queryObjByPage(MaterialApplyExample example) {
        PageView<MaterialApply> pageView = example.getPageView();
        pageView.setQueryResult(this.materialApplyMapper.selectByExampleByPage(example));
        return pageView;
    }
}

