/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.material.dao.MaterialCategoryMapper;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialCategoryExample;
import com.els.base.material.entity.MaterialCategoryImportEntity;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialCategoryService")
public class MaterialCategoryServiceImpl
implements MaterialCategoryService {
    @Resource
    protected MaterialCategoryMapper materialCategoryMapper;

    @Override
    @CacheEvict(value={"materialCategory"}, allEntries=true)
    public void importMaterialCategory(String projectId, String companyId, List<MaterialCategoryImportEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date nowDate = new Date();
        MaterialCategory materialCategory = new MaterialCategory();
        for (MaterialCategoryImportEntity Pitem : list) {
            MaterialCategory ExistMaterialCategory;
            MaterialCategoryExample.Criteria criteria;
            MaterialCategoryExample materialCategoryExample;
            materialCategory = new MaterialCategory();
            materialCategory.setIsEnable(Constant.YES_INT);
            if (StringUtils.isNotEmpty((String)Pitem.getpCategoryCode())) {
                materialCategory.setCategoryCode(Pitem.getpCategoryCode());
                materialCategory.setCategoryName(Pitem.getpCategoryName());
                materialCategory.setCompanyId(companyId);
                materialCategory.setProjectId(projectId);
                materialCategory.setUpdateTime(nowDate);
                if (!this.isExists(Pitem.getpCategoryCode()).booleanValue()) {
                    if (StringUtils.isEmpty((String)Pitem.getpCategoryName())) {
                        throw new CommonException("\u7269\u6599\u5206\u7c7b\u4ee3\u7801" + Pitem.getpCategoryCode() + "\u7684\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u5165!");
                    }
                    materialCategory.setCreateTime(nowDate);
                    this.addObj(materialCategory);
                    materialCategoryExample = new MaterialCategoryExample();
                    criteria = materialCategoryExample.createCriteria();
                    criteria.andCategoryCodeEqualTo(Pitem.getpCategoryCode());
                    ExistMaterialCategory = this.materialCategoryMapper.selectByExample(materialCategoryExample).get(0);
                    materialCategory.setParentId(ExistMaterialCategory.getId());
                } else {
                    materialCategoryExample = new MaterialCategoryExample();
                    criteria = materialCategoryExample.createCriteria();
                    criteria.andCategoryCodeEqualTo(Pitem.getpCategoryCode());
                    ExistMaterialCategory = this.materialCategoryMapper.selectByExample(materialCategoryExample).get(0);
                    if (StringUtils.isNotEmpty((String)Pitem.getpCategoryName())) {
                        ExistMaterialCategory.setCategoryName(Pitem.getpCategoryName());
                    }
                    this.modifyObj(ExistMaterialCategory);
                    materialCategory.setParentId(ExistMaterialCategory.getId());
                }
                materialCategory.setId(UUIDGenerator.generateUUID());
                materialCategory.setCategoryCode(Pitem.getCategoryCode());
                materialCategory.setCategoryName(Pitem.getCategoryName());
                materialCategory.setCompanyId(companyId);
                materialCategory.setProjectId(projectId);
                materialCategory.setUpdateTime(nowDate);
                if (StringUtils.isEmpty((String)Pitem.getCategoryName())) {
                    throw new CommonException("\u7269\u6599\u5206\u7c7b\u4ee3\u7801" + Pitem.getCategoryCode() + "\u7684\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u5165!");
                }
                if (!this.isExists(Pitem.getCategoryCode()).booleanValue()) {
                    materialCategory.setCreateTime(nowDate);
                    this.addObj(materialCategory);
                    continue;
                }
                materialCategoryExample = new MaterialCategoryExample();
                criteria = materialCategoryExample.createCriteria();
                criteria.andCategoryCodeEqualTo(Pitem.getCategoryCode());
                ExistMaterialCategory = this.materialCategoryMapper.selectByExample(materialCategoryExample).get(0);
                ExistMaterialCategory.setParentId(materialCategory.getParentId());
                ExistMaterialCategory.setCategoryName(Pitem.getpCategoryName());
                this.modifyObj(ExistMaterialCategory);
                continue;
            }
            materialCategory.setId(UUIDGenerator.generateUUID());
            materialCategory.setCategoryCode(Pitem.getCategoryCode());
            materialCategory.setCategoryName(Pitem.getCategoryName());
            materialCategory.setCompanyId(companyId);
            materialCategory.setProjectId(projectId);
            materialCategory.setUpdateTime(nowDate);
            if (!this.isExists(Pitem.getCategoryCode()).booleanValue()) {
                materialCategory.setCreateTime(nowDate);
                this.addObj(materialCategory);
                continue;
            }
            materialCategoryExample = new MaterialCategoryExample();
            criteria = materialCategoryExample.createCriteria();
            criteria.andCategoryCodeEqualTo(Pitem.getCategoryCode());
            ExistMaterialCategory = this.materialCategoryMapper.selectByExample(materialCategoryExample).get(0);
            materialCategory.setId(ExistMaterialCategory.getId());
            this.modifyObj(materialCategory);
        }
    }

    @Override
    public Boolean isExists(String materialCategoryCode) {
        if (StringUtils.isBlank((String)materialCategoryCode)) {
            throw new IllegalArgumentException("parameter materialCode is null");
        }
        MaterialCategoryExample materialCategoryExample = new MaterialCategoryExample();
        MaterialCategoryExample.Criteria criteria = materialCategoryExample.createCriteria();
        criteria.andCategoryCodeEqualTo(materialCategoryCode);
        int count = this.materialCategoryMapper.countByExample(materialCategoryExample);
        if (count > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Cacheable(value={"materialCategory"}, keyGenerator="redisKeyGenerator")
    public int countByExample(MaterialCategoryExample example) {
        return this.materialCategoryMapper.countByExample(example);
    }

    @CacheEvict(value={"materialCategory"}, allEntries=true)
    public void addObj(MaterialCategory t) {
        MaterialCategoryExample materialCategoryExample = new MaterialCategoryExample();
        materialCategoryExample.createCriteria().andProjectIdEqualTo(t.getProjectId()).andCategoryCodeEqualTo(t.getCategoryCode()).andIsEnableEqualTo(Constant.YES_INT);
        if (this.materialCategoryMapper.countByExample(materialCategoryExample) > 0) {
            throw new CommonException("\u8be5\u7269\u6599\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728!");
        }
        t.setCreateTime(new Date());
        t.setUpdateTime(new Date());
        this.materialCategoryMapper.insertSelective(t);
    }

    @CacheEvict(value={"materialCategory"}, allEntries=true)
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialCategoryMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialCategory"}, allEntries=true)
    public void modifyObj(MaterialCategory t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialCategoryMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialCategory"}, keyGenerator="redisKeyGenerator")
    public MaterialCategory queryObjById(String id) {
        return this.materialCategoryMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialCategory"}, keyGenerator="redisKeyGenerator")
    public List<MaterialCategory> queryAllObjByExample(MaterialCategoryExample example) {
        return this.materialCategoryMapper.selectByExample(example);
    }

    @Cacheable(value={"materialCategory"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialCategory> queryObjByPage(MaterialCategoryExample example) {
        PageView<MaterialCategory> pageView = example.getPageView();
        pageView.setQueryResult(this.materialCategoryMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"materialCategory"}, allEntries=true)
    public void deleteCascadedMaterialCategoryInfo(String parentId) {
        if (StringUtils.isBlank((String)parentId)) {
            throw new CommonException("\u4e0a\u4e00\u7ea7\u4f20\u7684id\u4e3a\u7a7a!");
        }
        this.materialCategoryMapper.deleteByPrimaryKey(parentId);
        MaterialCategoryExample materialCategoryExample = new MaterialCategoryExample();
        materialCategoryExample.createCriteria().andParentIdEqualTo(parentId).andIsEnableEqualTo(Constant.YES_INT);
        List<MaterialCategory> list = this.materialCategoryMapper.selectByExample(materialCategoryExample);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (MaterialCategory materialCategory : list) {
            this.deleteCascadedMaterialCategoryInfo(materialCategory.getId());
        }
    }

    @Override
    @Cacheable(value={"materialCategory"}, keyGenerator="redisKeyGenerator")
    public List<MaterialCategory> queryByParentId(String parentId) {
        if (StringUtils.isBlank((String)parentId)) {
            return null;
        }
        MaterialCategoryExample example = new MaterialCategoryExample();
        example.createCriteria().andParentIdEqualTo(parentId).andIsEnableEqualTo(Constant.YES_INT);
        List<MaterialCategory> list = this.materialCategoryMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        for (MaterialCategory materialCategory : list) {
            materialCategory.setMaterialCatergoryList(this.queryByParentId(materialCategory.getId()));
        }
        return list;
    }

    @CacheEvict(value={"materialCategory"}, allEntries=true)
    public void deleteByExample(MaterialCategoryExample example) {
        Assert.isNotNull((Object)((Object)example), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialCategoryMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialCategory"}, allEntries=true)
    @Transactional
    public void addAll(List<MaterialCategory> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (MaterialCategory materialCategory : list) {
            materialCategory.setId(UUIDGenerator.generateUUID());
        }
        this.materialCategoryMapper.insertBatch(list);
    }

    @Override
    public List<MaterialCategory> queryTree(List<MaterialCategory> materialCategoryList) {
        if (CollectionUtils.isNotEmpty(materialCategoryList)) {
            materialCategoryList.forEach(this::queryTree);
        }
        return materialCategoryList;
    }

    @Override
    public MaterialCategory queryTree(MaterialCategory materialCategory) {
        MaterialCategoryExample example = new MaterialCategoryExample();
        example.createCriteria().andProjectIdEqualTo(ProjectUtils.getProjectId()).andCompanyIdEqualTo(ProjectUtils.getCompanyId()).andIsEnableEqualTo(Constant.YES_INT).andParentIdEqualTo(materialCategory.getId());
        List<MaterialCategory> children = this.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(children)) {
            materialCategory.setMaterialCatergoryList(children);
            this.queryTree(children);
        }
        return materialCategory;
    }
}

