/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.material.dao.MaterialPropValueMapper;
import com.els.base.material.entity.MaterialPropValue;
import com.els.base.material.entity.MaterialPropValueExample;
import com.els.base.material.service.MaterialPropValueService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialPropValueService")
public class MaterialPropValueServiceImpl
implements MaterialPropValueService {
    @Resource
    protected MaterialPropValueMapper materialPropValueMapper;

    @CacheEvict(value={"materialPropValue"}, allEntries=true)
    public void addObj(MaterialPropValue t) {
        this.materialPropValueMapper.insertSelective(t);
    }

    @CacheEvict(value={"materialPropValue"}, allEntries=true)
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialPropValueMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialPropValue"}, allEntries=true)
    public void modifyObj(MaterialPropValue t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialPropValueMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialPropValue"}, keyGenerator="redisKeyGenerator")
    public MaterialPropValue queryObjById(String id) {
        return this.materialPropValueMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialPropValue"}, keyGenerator="redisKeyGenerator")
    public List<MaterialPropValue> queryAllObjByExample(MaterialPropValueExample example) {
        return this.materialPropValueMapper.selectByExample(example);
    }

    @Cacheable(value={"materialPropValue"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialPropValue> queryObjByPage(MaterialPropValueExample example) {
        PageView<MaterialPropValue> pageView = example.getPageView();
        pageView.setQueryResult(this.materialPropValueMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"materialPropValue"}, allEntries=true)
    public void deleteByExample(MaterialPropValueExample materialPropValueExample) {
        this.materialPropValueMapper.deleteByExample(materialPropValueExample);
    }

    @CacheEvict(value={"materialPropValue"}, allEntries=true)
    @Transactional
    public void addAll(List<MaterialPropValue> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.materialPropValueMapper.insertSelective((MaterialPropValue)record));
    }
}

