/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.CateoryPurchaser;
import com.els.base.material.entity.CateoryPurchaserExample;
import com.els.base.material.service.CateoryPurchaserService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"T_BASE_CATEORY_PURCHASER"})
@Controller
@RequestMapping(value={"cateoryPurchaser"})
public class CateoryPurchaserController {
    @Resource
    protected CateoryPurchaserService cateoryPurchaserService;
    private static Logger logger = LoggerFactory.getLogger(CateoryPurchaserController.class);

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaT_BASE_CATEORY_PURCHASER")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CateoryPurchaser cateoryPurchaser) {
        this.cateoryPurchaserService.addObj(cateoryPurchaser);
        return ResponseResult.success((Object)cateoryPurchaser.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91T_BASE_CATEORY_PURCHASER")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CateoryPurchaser cateoryPurchaser) {
        Assert.isNotBlank((String)cateoryPurchaser.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.cateoryPurchaserService.modifyObj(cateoryPurchaser);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664T_BASE_CATEORY_PURCHASER")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        CateoryPurchaserExample example = new CateoryPurchaserExample();
        example.createCriteria().andIdIn((List)ids);
        this.cateoryPurchaserService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2T_BASE_CATEORY_PURCHASER")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CateoryPurchaser", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CateoryPurchaser>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CateoryPurchaserExample example = new CateoryPurchaserExample();
        example.setPageView((PageView<CateoryPurchaser>)new PageView(pageNo, pageSize));
        CateoryPurchaserExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.cateoryPurchaserService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u54c1\u7c7b\u7ba1\u7406\u5458\u5217\u8868\u6279\u91cf\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ModelAndView downloadExcel(String queryParams, HttpServletResponse response) {
        try {
            CateoryPurchaserExample example = new CateoryPurchaserExample();
            if (StringUtils.isNotBlank((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            }
            List cateoryPurchaserList = this.cateoryPurchaserService.queryAllObjByExample((IExample)example);
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)cateoryPurchaserList, (String)"\u54c1\u7c7b\u7ba1\u7406\u5458\u5217\u8868", null, (int)0);
            String fileName = String.format("\u54c1\u7c7b\u7ba1\u7406\u5458\u5217\u8868%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    @ApiOperation(value="\u54c1\u7c7b\u7ba1\u7406\u5458\u5217\u8868\u9009\u4e2d\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcelSelect"})
    @ResponseBody
    public ModelAndView downloadExcelSelect(@RequestParam(defaultValue="") String ids, HttpServletResponse response) {
        try {
            if (StringUtils.isEmpty((String)ids)) {
                throw new CommonException("\u9009\u4e2d\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
            }
            CateoryPurchaserExample example = new CateoryPurchaserExample();
            example.createCriteria().andIdIn((List)Arrays.asList(ids.split(",")));
            List cateoryPurchaserList = this.cateoryPurchaserService.queryAllObjByExample((IExample)example);
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)cateoryPurchaserList, (String)"\u54c1\u7c7b\u7ba1\u7406\u5458\u5217\u8868", null, (int)0);
            String fileName = String.format("\u54c1\u7c7b\u7ba1\u7406\u5458\u5217\u8868%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    public List<TitleAndModelKey> createTitleAndModelKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u54c1\u7c7b", (String)"materialCategory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u54c1\u7c7b\u63cf\u8ff0", (String)"materialCategoryDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u7c7b\u91c7\u8d2d\u5458", (String)"categoryPurchaser"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u7c7b\u91c7\u8d2d\u54582", (String)"categoryPurchaser2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u7c7b\u91c7\u8d2d\u5458\u540d\u79f0", (String)"categoryPurchaserName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u7c7b\u91c7\u8d2d\u5458\u540d\u79f02", (String)"categoryPurchaserName2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba1\u6279\u4eba\u540d\u79f0", (String)"categoryApproverName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba1\u6279\u4eba", (String)"categoryApprover"));
        return titleAndModelKeys;
    }

    private void setResponseHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
    }
}

