/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialCategoryExample;
import com.els.base.material.entity.MaterialCategoryImportEntity;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.service.MaterialService;
import com.els.base.material.vo.MaterialCategoryImportVO;
import com.els.base.utils.txtImport.TxtImportResponse;
import com.els.base.utils.txtImport.TxtImportUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u7269\u6599\u5206\u7c7b"})
@Controller
@RequestMapping(value={"materialCategory"})
public class MaterialCategoryController {
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MaterialCategoryService materialCategoryService;
    @Resource
    protected GenerateCodeService generateCodeService;

    @ApiOperation(value="\u4e0b\u8f7d\u7269\u6599\u5206\u7c7b\u5bfc\u5165\u6a21\u677f(Excel)", httpMethod="GET")
    @RequestMapping(value={"service/downloadTemplateExcel"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadMaterialTemplate() throws IOException {
        ClassPathResource resource = new ClassPathResource("import/MaterialCategory.xlsx");
        InputStream inputStream = resource.getInputStream();
        HttpHeaders headers = new HttpHeaders();
        String format = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        String fileName = "\u7269\u6599\u5206\u7c7bExcel\u5bfc\u5165\u6a21\u677f_" + format + ".xlsx";
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", URLEncoder.encode(fileName, "UTF-8")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)new InputStreamResource(inputStream));
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u5206\u7c7b", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMateriaCategorylFromExcel"})
    public ResponseResult<String> importMateriaCategorylFromExcel(@RequestParam(value="file") MultipartFile file) {
        List list = new ArrayList();
        try {
            InputStream inputStream = file.getInputStream();
            ImportParams params = new ImportParams();
            list = ExcelImportUtil.importExcel((InputStream)inputStream, MaterialCategoryImportVO.class, (ImportParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException(e.getMessage());
        }
        Assert.isNotEmpty(list, (String)"Excel\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        String projectId = ProjectUtils.getProjectId();
        String companyId = ProjectUtils.getCompanyId();
        for (Iterator importEntity : list) {
            String nextCode = this.generateCodeService.getNextCode("MATERIAL_CATEGORY_CODE");
            ((MaterialCategoryImportVO)((Object)importEntity)).setCategoryCode(nextCode);
        }
        Map<String, List<MaterialCategoryImportVO>> categoryImpor = list.stream().collect(Collectors.groupingBy(item -> item.getParentCategoryName() + "_" + item.getCategoryName()));
        for (String key : categoryImpor.keySet()) {
            List<MaterialCategoryImportVO> list2 = categoryImpor.get(key);
            if (list2.size() <= 1) continue;
            throw new CommonException("\u4e0a\u7ea7\u7684\u7269\u6599\u540d\u79f0\u3010" + list2.get(0).getParentCategoryName() + "\u3011\u4e0d\u80fd\u5bfc\u5165\u91cd\u590d\u7684\u7269\u6599\u5206\u7c7b\u540d\u79f0");
        }
        for (MaterialCategoryImportVO importVO : list) {
            MaterialCategoryExample example1 = new MaterialCategoryExample();
            example1.createCriteria().andCategoryNameEqualTo(importVO.getParentCategoryName()).andCategoryCodeEqualTo(importVO.getParentCategoryCode());
            List categorys = this.materialCategoryService.queryAllObjByExample((IExample)example1);
            if (CollectionUtils.isEmpty((Collection)categorys)) {
                throw new CommonException("\u4e0a\u7ea7\u7269\u6599\u540d\u79f0\u3010" + importVO.getParentCategoryName() + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            example1.clear();
            example1.createCriteria().andCategoryNameEqualTo(importVO.getCategoryName()).andParentIdEqualTo(((MaterialCategory)categorys.get(0)).getId());
            int i = this.materialCategoryService.countByExample(example1);
            if (i <= 0) continue;
            throw new CommonException("\u7cfb\u7edf\u4e2d\u540c\u4e00\u4e0a\u7ea7\u7269\u6599\u5206\u7c7b\u540d\u79f0\u3010" + importVO.getParentCategoryName() + "\u3011\u5df2\u7ecf\u5b58\u5728\u7269\u6599\u5206\u7c7b\u540d\u79f0\u3010" + importVO.getCategoryName() + "\u3011");
        }
        List<MaterialCategoryImportEntity> firstLevel = list.stream().filter(tmp -> tmp.getParentCategoryCode() == null).map(MaterialCategoryImportEntity::new).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(firstLevel)) {
            this.materialCategoryService.importMaterialCategory(projectId, companyId, firstLevel);
        }
        Map<String, List> otherLevel = list.stream().filter(tmp -> tmp.getParentCategoryCode() != null).map(MaterialCategoryImportEntity::new).collect(Collectors.toMap(MaterialCategoryImportEntity::getpCategoryCode, tmp -> {
            LinkedList<MaterialCategoryImportEntity> l = new LinkedList<MaterialCategoryImportEntity>();
            l.add((MaterialCategoryImportEntity)tmp);
            return l;
        }, (tmp1, tmp2) -> {
            tmp1.addAll(tmp2);
            return tmp1;
        }));
        int amount = 1;
        while (otherLevel.size() > 0 && amount > 0) {
            LinkedList<String> needToBeRemoved = new LinkedList<String>();
            for (Map.Entry<String, List> tmp3 : otherLevel.entrySet()) {
                String parentCode = tmp3.getKey();
                if (!this.materialCategoryService.isExists(parentCode).booleanValue()) continue;
                this.materialCategoryService.importMaterialCategory(projectId, companyId, tmp3.getValue());
                needToBeRemoved.add(tmp3.getKey());
            }
            needToBeRemoved.forEach(otherLevel::remove);
            amount = needToBeRemoved.size();
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u5206\u7c7b", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMateriaCategorylFromTxt"})
    public ResponseResult<String> importMateriaCategorylFromTxt(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);
        String[] keys = new String[]{"categoryCode", "categoryName", "pCategoryCode", "pCategoryName"};
        try {
            TxtImportResponse importTxt = TxtImportUtils.importTxt((MultipartFile)file, (String)"\t", MaterialCategoryImportEntity.class, (String[])keys);
            List list = importTxt.getList();
            this.materialCategoryService.importMaterialCategory(ProjectUtils.getProjectId(), ProjectUtils.getCompanyId(), list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    private MultipartFile vaildTxtFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".txt")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301txt");
        }
        return file;
    }
}

