-- ----------------------------
-- 物料品类表
-- ----------------------------
-- DROP TABLE "T_BASE_CATEORY_PURCHASER";
CREATE TABLE "T_BASE_CATEORY_PURCHASER"
(
    "ID"                       VARCHAR2(32 BYTE) NOT NULL,
    "MATERIAL_CATEGORY_DESC"   VARCHAR2(255 BYTE),
    "MATERIAL_CATEGORY"        VARCHAR2(255 BYTE),
    "CATEGORY_PURCHASER"       VARCHAR2(255 BYTE),
    "CATEGORY_PURCHASER_ID"    VARCHAR2(32 BYTE),
    "CATEGORY_PURCHASER_NAME"  VARCHAR2(255 BYTE),
    "IS_ENABLE"                NUMBER(1) DEFAULT 1,
    "CATEGORY_PURCHASER2"      VARCHAR2(255 BYTE),
    "CATEGORY_PURCHASER_ID2"   VARCHAR2(32 BYTE),
    "CATEGORY_PURCHASER_NAME2" VARCHAR2(255 BYTE),
    "CATEGORY_APPROVER"        VARCHAR2(255 BYTE),
    "CATEGORY_APPROVER_NAME"   VARCHAR2(255 BYTE)
);

COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."MATERIAL_CATEGORY_DESC" IS '物料品类描述';
COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."MATERIAL_CATEGORY" IS '物料品类';
COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."CATEGORY_PURCHASER" IS '品类采购员';
COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."CATEGORY_PURCHASER_ID" IS '品类采购员id';
COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."CATEGORY_PURCHASER_NAME" IS '品类采购员名称';
COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."IS_ENABLE" IS '是否可用：0不可用 ；1可用';
COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."CATEGORY_PURCHASER2" IS '品类采购员2';
COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."CATEGORY_PURCHASER_ID2" IS '品类采购员id2';
COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."CATEGORY_PURCHASER_NAME2" IS '品类采购员名称2';
COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."CATEGORY_APPROVER" IS '审批人';
COMMENT ON COLUMN "T_BASE_CATEORY_PURCHASER"."CATEGORY_APPROVER_NAME" IS '审批人名称';
COMMENT ON TABLE "T_BASE_CATEORY_PURCHASER" IS '物料品类表';


ALTER TABLE "T_BASE_CATEORY_PURCHASER"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 物料分类
-- ----------------------------
-- DROP TABLE "T_BASE_MATERIAL_CATEGORY";
CREATE TABLE "T_BASE_MATERIAL_CATEGORY"
(
    "ID"            NVARCHAR2(32) NOT NULL,
    "PROJECT_ID"    NVARCHAR2(32),
    "COMPANY_ID"    NVARCHAR2(32) NOT NULL,
    "CATEGORY_NAME" NVARCHAR2(255),
    "CATEGORY_CODE" NVARCHAR2(255),
    "CREATE_TIME"   DATE,
    "UPDATE_TIME"   DATE,
    "IS_ENABLE"     NUMBER(11),
    "PARENT_ID"     VARCHAR2(32 CHAR)
);

COMMENT ON COLUMN "T_BASE_MATERIAL_CATEGORY"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_CATEGORY"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_MATERIAL_CATEGORY"."COMPANY_ID" IS '公司id';
COMMENT ON COLUMN "T_BASE_MATERIAL_CATEGORY"."CATEGORY_NAME" IS '分类名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_CATEGORY"."CATEGORY_CODE" IS '分类编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_CATEGORY"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_CATEGORY"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_CATEGORY"."IS_ENABLE" IS '是否可用，0不可用，1可用';
COMMENT ON COLUMN "T_BASE_MATERIAL_CATEGORY"."PARENT_ID" IS '上级主键';
COMMENT ON TABLE "T_BASE_MATERIAL_CATEGORY" IS '物料分类';


ALTER TABLE "T_BASE_MATERIAL_CATEGORY"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 供应商物料号关系表
-- ----------------------------
-- DROP TABLE "T_BASE_MATERIAL_CODE";
CREATE TABLE "T_BASE_MATERIAL_CODE"
(
    "ID"                    NVARCHAR2(32) NOT NULL,
    "PROJECT_ID"            NVARCHAR2(32),
    "MATERIAL_ID"           NVARCHAR2(32),
    "MATERIAL_CODE"         NVARCHAR2(32),
    "MATERIAL_NAME"         NVARCHAR2(255),
    "COMPANY_ID"            NVARCHAR2(32),
    "COMPANY_NAME"          NVARCHAR2(255),
    "COMPANY_CODE"          NVARCHAR2(32),
    "COMPANY_MATERIAL_CODE" NVARCHAR2(32),
    "COMPANY_MATERIAL_NAME" NVARCHAR2(255),
    "CREATE_TIME"           DATE,
    "UPDATE_TIME"           DATE,
    "IS_ENABLE"             NUMBER(11)
);

COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."MATERIAL_ID" IS '采购方物料ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."MATERIAL_CODE" IS '采购方物料编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."MATERIAL_NAME" IS '采购商物料名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."COMPANY_ID" IS '公司主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."COMPANY_CODE" IS '供应商公司编号';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."COMPANY_MATERIAL_CODE" IS '供应商料号编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."COMPANY_MATERIAL_NAME" IS '供应商物料名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_CODE"."IS_ENABLE" IS '是否可用，0不可用，1可用';
COMMENT ON TABLE "T_BASE_MATERIAL_CODE" IS '供应商物料号关系表';


ALTER TABLE "T_BASE_MATERIAL_CODE"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 物料拓展表
-- ----------------------------
-- DROP TABLE "T_LIBY_MATERIAL_EXT";
CREATE TABLE "T_LIBY_MATERIAL_EXT"
(
    "MATERIAL_ID"      VARCHAR2(32 BYTE),
    "MATERIAL_CODE"    VARCHAR2(32 BYTE),
    "FACTORY"          VARCHAR2(32 BYTE),
    "PUR_GROUP"        VARCHAR2(255 BYTE),
    "JIT_ITEM"         VARCHAR2(100 BYTE),
    "MATERIAL_DESC"    VARCHAR2(255 BYTE),
    "FACTORY_NAME"     VARCHAR2(255 BYTE),
    "BACK_STATUS"      NUMBER(7),
    "UPDATE_TIME"      DATE,
    "UPDATE_USER_NAME" VARCHAR2(255 BYTE),
    "IS_ENABLE"        NUMBER(7),
    "BACK_TIME"        DATE,
    "ID"               VARCHAR2(32 BYTE) DEFAULT sys_guid() NOT NULL
);

COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."MATERIAL_ID" IS '物料id';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."FACTORY" IS '工厂编码';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."PUR_GROUP" IS '采购组';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."JIT_ITEM" IS 'jit标识:0-非jit,1-jit';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."FACTORY_NAME" IS '工厂名称';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."BACK_STATUS" IS '回写状态：1未回写、2已回写、3回写失败';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."UPDATE_USER_NAME" IS '更新人';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."IS_ENABLE" IS '是否可用：0-不可用，1可用';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."BACK_TIME" IS '回写时间';
COMMENT ON COLUMN "T_LIBY_MATERIAL_EXT"."ID" IS '主键';
COMMENT ON TABLE "T_LIBY_MATERIAL_EXT" IS '物料拓展表';

ALTER TABLE "T_LIBY_MATERIAL_EXT"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 物料文件表
-- ----------------------------
-- DROP TABLE "T_BASE_MATERIAL_FILE";
CREATE TABLE "T_BASE_MATERIAL_FILE"
(
    "ID"                      VARCHAR2(32 BYTE)             NOT NULL,
    "PROJECT_ID"              VARCHAR2(32 BYTE),
    "COMPANY_ID"              VARCHAR2(32 BYTE),
    "MATERIAL_NAME"           VARCHAR2(255 BYTE),
    "MATERIAL_CODE"           VARCHAR2(255 BYTE),
    "DESCRIPTION"             VARCHAR2(255 BYTE),
    "CREATE_TIME"             DATE               DEFAULT NULL,
    "UPDATE_TIME"             DATE               DEFAULT NULL,
    "PARENT_ID"               VARCHAR2(32 BYTE),
    "FILE_SUFFIX"             VARCHAR2(255 BYTE) DEFAULT '',
    "FILE_VERSION"            VARCHAR2(255 BYTE) DEFAULT '' NOT NULL,
    "MATERIAL_ID"             VARCHAR2(32 BYTE),
    "FILE_CODE"               VARCHAR2(255 BYTE)            NOT NULL,
    "FILE_ID"                 VARCHAR2(32 BYTE),
    "FILE_NAME"               VARCHAR2(255 BYTE) DEFAULT '',
    "FILE_RENAME"             VARCHAR2(255 BYTE) DEFAULT '',
    "FILE_TYPE"               VARCHAR2(255 BYTE) DEFAULT '',
    "MATERIAL_CATEGORY"       VARCHAR2(255 BYTE),
    "CATEGORY_PURCHASER"      VARCHAR2(255 BYTE),
    "CATEGORY_PURCHASER_ID"   VARCHAR2(32 BYTE),
    "CATEGORY_PURCHASER_NAME" VARCHAR2(255 BYTE),
    "IS_ENABLE"               NUMBER(3)
);

COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."COMPANY_ID" IS '公司ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."MATERIAL_CODE" IS '物料标识';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."DESCRIPTION" IS '物料描述';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."PARENT_ID" IS '上级ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_SUFFIX" IS '文件后缀';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_VERSION" IS '文件后缀';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_CODE" IS '文件编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_ID" IS '文件ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_NAME" IS '附件名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_RENAME" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_TYPE" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."MATERIAL_CATEGORY" IS '物料品类';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."CATEGORY_PURCHASER" IS '品类采购员';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."CATEGORY_PURCHASER_ID" IS '品类采购员id';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."CATEGORY_PURCHASER_NAME" IS '品类采购员名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."IS_ENABLE" IS '是否可用';
COMMENT ON TABLE "T_BASE_MATERIAL_FILE" IS '物料文件表';


ALTER TABLE "T_BASE_MATERIAL_FILE"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 物料文件历史表
-- ----------------------------
-- DROP TABLE "T_BASE_MATERIAL_FILE_HIS";
CREATE TABLE "T_BASE_MATERIAL_FILE_HIS"
(
    "ID"                      VARCHAR2(32 BYTE)             NOT NULL,
    "PROJECT_ID"              VARCHAR2(32 BYTE),
    "COMPANY_ID"              VARCHAR2(32 BYTE),
    "MATERIAL_NAME"           VARCHAR2(255 BYTE),
    "MATERIAL_CODE"           VARCHAR2(255 BYTE),
    "DESCRIPTION"             VARCHAR2(255 BYTE),
    "CREATE_TIME"             DATE               DEFAULT NULL,
    "UPDATE_TIME"             DATE               DEFAULT NULL,
    "PARENT_ID"               VARCHAR2(32 BYTE),
    "FILE_SUFFIX"             VARCHAR2(255 BYTE) DEFAULT '',
    "FILE_VERSION"            VARCHAR2(255 BYTE) DEFAULT '' NOT NULL,
    "MATERIAL_ID"             VARCHAR2(32 BYTE)             NOT NULL,
    "FILE_CODE"               VARCHAR2(255 BYTE)            NOT NULL,
    "FILE_ID"                 VARCHAR2(32 BYTE),
    "FILE_NAME"               VARCHAR2(255 BYTE) DEFAULT '',
    "FILE_RENAME"             VARCHAR2(255 BYTE) DEFAULT '',
    "FILE_TYPE"               VARCHAR2(255 BYTE) DEFAULT '',
    "MATERIAL_CATEGORY"       VARCHAR2(255 BYTE),
    "CATEGORY_PURCHASER"      VARCHAR2(255 BYTE),
    "CATEGORY_PURCHASER_ID"   VARCHAR2(32 BYTE),
    "CATEGORY_PURCHASER_NAME" VARCHAR2(255 BYTE),
    "IS_ENABLE"               NUMBER(3)
);

COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."COMPANY_ID" IS '公司ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."MATERIAL_CODE" IS '物料标识';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."DESCRIPTION" IS '物料描述';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."PARENT_ID" IS '上级ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_SUFFIX" IS '文件后缀';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_VERSION" IS '文件后缀';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_CODE" IS '文件编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_ID" IS '文件ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_NAME" IS '附件名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_RENAME" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_TYPE" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."MATERIAL_CATEGORY" IS '物料品类';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."CATEGORY_PURCHASER" IS '品类采购员';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."CATEGORY_PURCHASER_ID" IS '品类采购员id';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."CATEGORY_PURCHASER_NAME" IS '品类采购员名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."IS_ENABLE" IS '是否可用';
COMMENT ON TABLE "T_BASE_MATERIAL_FILE_HIS" IS '物料文件历史表';


ALTER TABLE "T_BASE_MATERIAL_FILE_HIS"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 物料文件表
-- ----------------------------
-- DROP TABLE "T_BASE_MATERIAL_FILE_NOTICE";
CREATE TABLE "T_BASE_MATERIAL_FILE_NOTICE"
(
    "ID"                      VARCHAR2(32 BYTE)             NOT NULL,
    "PROJECT_ID"              VARCHAR2(32 BYTE),
    "COMPANY_ID"              VARCHAR2(32 BYTE),
    "MATERIAL_NAME"           VARCHAR2(255 BYTE),
    "MATERIAL_CODE"           VARCHAR2(255 BYTE),
    "DESCRIPTION"             VARCHAR2(255 BYTE),
    "CREATE_TIME"             DATE               DEFAULT NULL,
    "UPDATE_TIME"             DATE               DEFAULT NULL,
    "FILE_SUFFIX"             VARCHAR2(255 BYTE) DEFAULT '',
    "FILE_VERSION"            VARCHAR2(255 BYTE) DEFAULT '' NOT NULL,
    "MATERIAL_ID"             VARCHAR2(32 BYTE),
    "FILE_CODE"               VARCHAR2(255 BYTE)            NOT NULL,
    "FILE_ID"                 VARCHAR2(32 BYTE),
    "FILE_NAME"               VARCHAR2(255 BYTE) DEFAULT '',
    "FILE_RENAME"             VARCHAR2(255 BYTE) DEFAULT '',
    "FILE_TYPE"               VARCHAR2(255 BYTE) DEFAULT '',
    "MATERIAL_CATEGORY"       VARCHAR2(255 BYTE),
    "CATEGORY_PURCHASER"      VARCHAR2(255 BYTE),
    "CATEGORY_PURCHASER_ID"   VARCHAR2(32 BYTE),
    "CATEGORY_PURCHASER_NAME" VARCHAR2(255 BYTE),
    "SUP_COMPANY_ID"          VARCHAR2(32 BYTE)             NOT NULL,
    "SUP_COMPANY_NAME"        VARCHAR2(255 BYTE),
    "SUP_COMPANY_SRM_CODE"    VARCHAR2(100 BYTE),
    "SUP_COMPANY_SAP_CODE"    VARCHAR2(100 BYTE),
    "SEND_TIME"               DATE               DEFAULT NULL,
    "CONFIRM_TIME"            DATE,
    "CONFIRM_STATUS"          NUMBER(1)          DEFAULT 0,
    "CONFIRM_USER_ID"         VARCHAR2(32 BYTE),
    "CONFIRM_USER_NAME"       VARCHAR2(255 BYTE)
)
;
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."COMPANY_ID" IS '公司ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."MATERIAL_CODE" IS '物料标识';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."DESCRIPTION" IS '物料描述';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_SUFFIX" IS '文件后缀';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_VERSION" IS '文件版本';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_CODE" IS '文件编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_ID" IS '文件ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_NAME" IS '附件名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_RENAME" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_TYPE" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."MATERIAL_CATEGORY" IS '物料品类';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CATEGORY_PURCHASER" IS '品类采购员';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CATEGORY_PURCHASER_ID" IS '品类采购员id';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CATEGORY_PURCHASER_NAME" IS '品类采购员名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."SUP_COMPANY_ID" IS '供应商企业id';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."SUP_COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."SEND_TIME" IS '发送时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CONFIRM_TIME" IS '确认时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CONFIRM_STATUS" IS '确认状态：0：未确认；1：已确认';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CONFIRM_USER_ID" IS '确认人ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CONFIRM_USER_NAME" IS '确认人名称';
COMMENT ON TABLE "T_BASE_MATERIAL_FILE_NOTICE" IS '物料文件表';


ALTER TABLE "T_BASE_MATERIAL_FILE_NOTICE"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 物料
-- ----------------------------
-- DROP TABLE "T_BASE_MATERIAL";
CREATE TABLE "T_BASE_MATERIAL"
(
    "ID"                             NVARCHAR2(32) NOT NULL,
    "PROJECT_ID"                     NVARCHAR2(32),
    "COMPANY_ID"                     NVARCHAR2(32),
    "DEPARTMENT_ID"                  NVARCHAR2(32),
    "DEPARTMENT_NAME"                NVARCHAR2(255),
    "CATEGORY_ID"                    NVARCHAR2(32),
    "CATEGORY_NAME"                  NVARCHAR2(255),
    "MATERIAL_NAME"                  NVARCHAR2(255),
    "MATERIAL_CODE"                  NVARCHAR2(255),
    "MATERIAL_SPECIFICATION"         NVARCHAR2(255),
    "DESCRIPTION"                    NVARCHAR2(255),
    "CURRENCY"                       NVARCHAR2(255),
    "PRICE"                          NUMBER,
    "CREATE_TIME"                    DATE       DEFAULT sysdate,
    "UPDATE_TIME"                    DATE       DEFAULT sysdate,
    "CREATE_USER_NAME"               NVARCHAR2(255),
    "CREATE_USER_ID"                 NVARCHAR2(32),
    "IS_ENABLE"                      NUMBER(11) DEFAULT 1,
    "WEIGHT"                         NVARCHAR2(20),
    "FACTORY_NAME"                   NVARCHAR2(255),
    "BASIC_UNIT"                     NVARCHAR2(255),
    "ORDER_UNIT"                     NVARCHAR2(255),
    "PURCHASE_TYPE"                  NVARCHAR2(255),
    "SPECIAL_PURCHASE_TYPE"          NVARCHAR2(255),
    "RECEIPT_PROCESSING_TIME"        NVARCHAR2(100),
    "EXTERNAL_WAREHOUSE"             NVARCHAR2(255),
    "PURCHASING_STAFF"               NVARCHAR2(255),
    "LEADTIME"                       NVARCHAR2(255),
    "MINIMUM_PACKING_QUANTITY"       NVARCHAR2(255),
    "MINIMUN_ORDER_QUANTITY"         NVARCHAR2(255),
    "PRICE_UNIT"                     NVARCHAR2(255),
    "UNIT_CONVERSION_MOLECULE"       NVARCHAR2(255),
    "UNIT_CONVERSION_DENOMINATOR"    NVARCHAR2(255),
    "FIGURE_TYPE"                    NVARCHAR2(255),
    "MATERIAL_TYPE"                  NVARCHAR2(255),
    "CENTRALIZE_CODE"                NVARCHAR2(255),
    "CENTRALIZE_NAME"                NVARCHAR2(255),
    "SAFE_STOCK"                     NVARCHAR2(255),
    "NORMAL_PRICE"                   NUMBER(11, 2),
    "COMMERCIAL_PRICE"               NUMBER(11, 2),
    "BRAND_NAME"                     NVARCHAR2(255),
    "ACCOMMODATION"                  NVARCHAR2(255),
    "STORAGE_CONDITION"              NVARCHAR2(255),
    "SIGNATURE"                      NVARCHAR2(255),
    "PRODUCT_GROUP"                  NVARCHAR2(255),
    "SUBJECT_GROUP"                  NVARCHAR2(255),
    "PROJECT_TYPE_GROUP"             NVARCHAR2(255),
    "TRANSPORTATION_GROUP"           NVARCHAR2(255),
    "EMBARKATION_GROUP"              NVARCHAR2(255),
    "PURCHASE_CODE"                  NVARCHAR2(255),
    "SOURCE_LIST"                    NVARCHAR2(255),
    "SAP_CREATE_TIME"                DATE,
    "SAP_UPDATE_TIME"                DATE,
    "SAP_DELETE_TAG"                 NVARCHAR2(32),
    "SAP_FREEZE_TAG"                 NVARCHAR2(32),
    "LOG_PRO_GROUP"                  VARCHAR2(255 BYTE),
    "FACTORY"                        VARCHAR2(255 CHAR),
    "PLACE_OF_STOCK"                 VARCHAR2(50 BYTE),
    "SALE_ORGANIZATION"              VARCHAR2(50 CHAR),
    "DISTRIBUTION_CHANNEL"           VARCHAR2(255 BYTE),
    "EXTERNAL_MATERIAL_GROUP"        VARCHAR2(255 BYTE),
    "PRODUCT_LEVEL"                  VARCHAR2(255 CHAR),
    "INTERNATIONAL_DOC_NUMBER"       VARCHAR2(255 BYTE),
    "CATEGORY"                       VARCHAR2(255 CHAR),
    "NET_WEIGHT"                     NUMBER(11, 2),
    "GROSS_WEIGHT"                   NUMBER(11, 2),
    "WEIGHT_UNIT"                    VARCHAR2(255 CHAR),
    "VOLUME"                         VARCHAR2(255 CHAR),
    "VOLUME_UNIT"                    VARCHAR2(255 CHAR),
    "SIZE_DIMENSION"                 VARCHAR2(255 BYTE),
    "MATERIAL_PRICING_GROUP"         VARCHAR2(255 CHAR),
    "PROJECT_CATEGORY_GROUP"         VARCHAR2(255 CHAR),
    "INSPECTION_UNIT"                VARCHAR2(255 CHAR),
    "PROFIT_CENTER"                  VARCHAR2(255 CHAR),
    "DELIVERY_UNIT_MEASUREMENT_UNIT" VARCHAR2(255 CHAR),
    "DELIVERY_UNIT"                  VARCHAR2(255 CHAR),
    "MATERIAL_TAXONOMY"              VARCHAR2(255 CHAR),
    "BATCH_REQUIRED_ID"              VARCHAR2(255 CHAR),
    "PUR_GROUP"                      VARCHAR2(255 BYTE),
    "AUTOMATIC_PUR_ORDER_ID"         VARCHAR2(255 BYTE),
    "PUR_VALUE_CODE"                 VARCHAR2(255 CHAR),
    "QUOTA_ALLOCATION_USE"           VARCHAR2(255 CHAR),
    "MATERIAL_REQUIRE_PLAN_TYPE"     VARCHAR2(255 CHAR),
    "MATERIAL_REQUIRE_PLAN_GROUP"    VARCHAR2(255 CHAR),
    "REORDER_POINT"                  VARCHAR2(255 CHAR),
    "MAX_BATCH_SIZE"                 VARCHAR2(255 CHAR),
    "MIN_BATCH_SIZE"                 VARCHAR2(255 CHAR),
    "FIXED_BATCH_SIZE"               VARCHAR2(255 BYTE),
    "PUR_ORDER_NUMBER_ROUDING"       VARCHAR2(255 CHAR),
    "FACTORY_PRODUCTION_TIME"        NUMBER(11, 2),
    "DELIVERY_STOCK_PLACE"           VARCHAR2(255 CHAR),
    "PLANNED_LEADTIME"               NUMBER(11, 2),
    "SCHEDULING_MARGIN_KEY"          VARCHAR2(255 CHAR),
    "SAFETY_STOCK"                   VARCHAR2(255 CHAR),
    "MAX_INVENTORY_LEVEL"            VARCHAR2(255 CHAR),
    "LOWEST_SAFE_STOCK_LIMIT"        VARCHAR2(255 CHAR),
    "PLAN_STRATEGY_GROUP"            VARCHAR2(255 CHAR),
    "INTEGRATED_MRP_ID"              VARCHAR2(255 CHAR),
    "REPLACEABLE_MATERIAL_METHOD"    VARCHAR2(255 CHAR),
    "ABORT_INDICATOR"                VARCHAR2(255 CHAR),
    "FOLLOW_UP_MATERIAL"             VARCHAR2(255 CHAR),
    "INTERRUPTION_DATE"              DATE,
    "PRODUCTION_SCHEDULER"           VARCHAR2(255 CHAR),
    "UNRESTRICTED_OVERDELIVERY"      VARCHAR2(255 BYTE),
    "EVALUATION_CLASS"               VARCHAR2(255 CHAR),
    "PRICE_CONTROL"                  VARCHAR2(255 CHAR),
    "STANDARD_PRICE"                 NUMBER(11, 2),
    "MAVING_AVG_PRICE"               NUMBER(11, 2),
    "COST_ACCOUNTING"                VARCHAR2(255 CHAR),
    "MATERIAL_SOURCE"                VARCHAR2(255 CHAR),
    "SALE_NUMBER"                    VARCHAR2(255 CHAR),
    "SALE_NUMBER_DESC"               VARCHAR2(255 CHAR),
    "LENGTH_WIDTH_HEIGHT"            NUMBER(11, 2),
    "MATERIAL_CATEGORY"              VARCHAR2(255 CHAR),
    "MATERIAL_CATEGORY_DESC"         VARCHAR2(255 CHAR),
    "JIT_ITEM"                       VARCHAR2(255 CHAR),
    "QUOTA_ARRANGEMENT"              VARCHAR2(255 CHAR),
    "BATCH_SIZE"                     VARCHAR2(255 CHAR),
    "MATERIAL_GROUP"                 VARCHAR2(255 BYTE),
    "MATERIAL_GROUP_DESC"            VARCHAR2(255 BYTE),
    "LARGE CLASS"                    VARCHAR2(255 BYTE),
    "RESERVE5"                       VARCHAR2(255 BYTE),
    "EXTERNAL_MATERIAL_GROUP_DESC"   VARCHAR2(255 BYTE),
    "MATERIAL_TYPE_DESC"             VARCHAR2(255 BYTE),
    "LARGE CLASS_DESC"               VARCHAR2(255 BYTE)
);
COMMENT ON COLUMN "T_BASE_MATERIAL"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_MATERIAL"."COMPANY_ID" IS '公司ID';
COMMENT ON COLUMN "T_BASE_MATERIAL"."DEPARTMENT_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_MATERIAL"."DEPARTMENT_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_MATERIAL"."CATEGORY_ID" IS '物料分类id';
COMMENT ON COLUMN "T_BASE_MATERIAL"."CATEGORY_NAME" IS '物料分类名称';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_CODE" IS '物料标识';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_SPECIFICATION" IS '物料规格';
COMMENT ON COLUMN "T_BASE_MATERIAL"."DESCRIPTION" IS '物料描述';
COMMENT ON COLUMN "T_BASE_MATERIAL"."CURRENCY" IS '币种';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PRICE" IS '物料价格';
COMMENT ON COLUMN "T_BASE_MATERIAL"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_MATERIAL"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_MATERIAL"."CREATE_USER_NAME" IS '创建人名称';
COMMENT ON COLUMN "T_BASE_MATERIAL"."CREATE_USER_ID" IS '创建人';
COMMENT ON COLUMN "T_BASE_MATERIAL"."IS_ENABLE" IS '是否可用，0不可用，1可用';
COMMENT ON COLUMN "T_BASE_MATERIAL"."WEIGHT" IS '物料单重';
COMMENT ON COLUMN "T_BASE_MATERIAL"."FACTORY_NAME" IS '工厂名称';
COMMENT ON COLUMN "T_BASE_MATERIAL"."BASIC_UNIT" IS '基本单位';
COMMENT ON COLUMN "T_BASE_MATERIAL"."ORDER_UNIT" IS '订单单位';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PURCHASE_TYPE" IS '采购类型';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SPECIAL_PURCHASE_TYPE" IS '特殊采购类型';
COMMENT ON COLUMN "T_BASE_MATERIAL"."RECEIPT_PROCESSING_TIME" IS '以天计算的收处理时间';
COMMENT ON COLUMN "T_BASE_MATERIAL"."EXTERNAL_WAREHOUSE" IS '外部采购仓储地点';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PURCHASING_STAFF" IS '采购人员';
COMMENT ON COLUMN "T_BASE_MATERIAL"."LEADTIME" IS 'LEADTIME，天数';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MINIMUM_PACKING_QUANTITY" IS '最小包装量';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MINIMUN_ORDER_QUANTITY" IS '最小订单量';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PRICE_UNIT" IS '价格单位';
COMMENT ON COLUMN "T_BASE_MATERIAL"."UNIT_CONVERSION_MOLECULE" IS '单位换算分子';
COMMENT ON COLUMN "T_BASE_MATERIAL"."UNIT_CONVERSION_DENOMINATOR" IS '单位换算分母';
COMMENT ON COLUMN "T_BASE_MATERIAL"."FIGURE_TYPE" IS '图号';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_TYPE" IS '物料类型';
COMMENT ON COLUMN "T_BASE_MATERIAL"."CENTRALIZE_CODE" IS '独立/集中code';
COMMENT ON COLUMN "T_BASE_MATERIAL"."CENTRALIZE_NAME" IS '独立/集中描述';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SAFE_STOCK" IS '安全库存';
COMMENT ON COLUMN "T_BASE_MATERIAL"."NORMAL_PRICE" IS '标准价格';
COMMENT ON COLUMN "T_BASE_MATERIAL"."COMMERCIAL_PRICE" IS '商业价格';
COMMENT ON COLUMN "T_BASE_MATERIAL"."BRAND_NAME" IS '品牌';
COMMENT ON COLUMN "T_BASE_MATERIAL"."ACCOMMODATION" IS '实验室/办公室(办公地点）';
COMMENT ON COLUMN "T_BASE_MATERIAL"."STORAGE_CONDITION" IS '存储条件';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SIGNATURE" IS '签样字段标识';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PRODUCT_GROUP" IS '产品组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SUBJECT_GROUP" IS '科目设置组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PROJECT_TYPE_GROUP" IS '项目类别组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."TRANSPORTATION_GROUP" IS '运输组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."EMBARKATION_GROUP" IS '装载组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PURCHASE_CODE" IS '采购价值码';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SOURCE_LIST" IS '货源清单';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SAP_CREATE_TIME" IS '导入的创建时间';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SAP_UPDATE_TIME" IS '导入的更新时间';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SAP_DELETE_TAG" IS '导入的删除标识';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SAP_FREEZE_TAG" IS '导入的冻结标识';
COMMENT ON COLUMN "T_BASE_MATERIAL"."LOG_PRO_GROUP" IS '后勤处理组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."FACTORY" IS '工厂';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PLACE_OF_STOCK" IS '库存地点';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SALE_ORGANIZATION" IS '销售组织';
COMMENT ON COLUMN "T_BASE_MATERIAL"."DISTRIBUTION_CHANNEL" IS '分销渠道';
COMMENT ON COLUMN "T_BASE_MATERIAL"."EXTERNAL_MATERIAL_GROUP" IS '外部物料组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PRODUCT_LEVEL" IS '产品层次';
COMMENT ON COLUMN "T_BASE_MATERIAL"."INTERNATIONAL_DOC_NUMBER" IS '国际文件号';
COMMENT ON COLUMN "T_BASE_MATERIAL"."CATEGORY" IS '类别';
COMMENT ON COLUMN "T_BASE_MATERIAL"."NET_WEIGHT" IS '净重';
COMMENT ON COLUMN "T_BASE_MATERIAL"."GROSS_WEIGHT" IS '毛重';
COMMENT ON COLUMN "T_BASE_MATERIAL"."WEIGHT_UNIT" IS '重量单位';
COMMENT ON COLUMN "T_BASE_MATERIAL"."VOLUME" IS '体积';
COMMENT ON COLUMN "T_BASE_MATERIAL"."VOLUME_UNIT" IS '体积单位';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SIZE_DIMENSION" IS '大小/量纲';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_PRICING_GROUP" IS '物料定价组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PROJECT_CATEGORY_GROUP" IS '来自物料主文件的项目类别组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."INSPECTION_UNIT" IS '可用性检查的检查组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PROFIT_CENTER" IS '利润中心';
COMMENT ON COLUMN "T_BASE_MATERIAL"."DELIVERY_UNIT_MEASUREMENT_UNIT" IS '交货单位的计量单位';
COMMENT ON COLUMN "T_BASE_MATERIAL"."DELIVERY_UNIT" IS '交货单位';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_TAXONOMY" IS '物料的税分类';
COMMENT ON COLUMN "T_BASE_MATERIAL"."BATCH_REQUIRED_ID" IS '批次管理需求的标识';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PUR_GROUP" IS '采购组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."AUTOMATIC_PUR_ORDER_ID" IS '允许自动采购订单标识';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PUR_VALUE_CODE" IS '采购价值代码';
COMMENT ON COLUMN "T_BASE_MATERIAL"."QUOTA_ALLOCATION_USE" IS '配额分配使用';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_REQUIRE_PLAN_TYPE" IS '物料需求计划类型';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_REQUIRE_PLAN_GROUP" IS '物料需求计划组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."REORDER_POINT" IS '重订购点';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MAX_BATCH_SIZE" IS '最大批量大小';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MIN_BATCH_SIZE" IS '最小批量大小';
COMMENT ON COLUMN "T_BASE_MATERIAL"."FIXED_BATCH_SIZE" IS '固定批量大小';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PUR_ORDER_NUMBER_ROUDING" IS '采购订单数量的舍入值';
COMMENT ON COLUMN "T_BASE_MATERIAL"."FACTORY_PRODUCTION_TIME" IS '厂内生产时间';
COMMENT ON COLUMN "T_BASE_MATERIAL"."DELIVERY_STOCK_PLACE" IS '发货库存地点';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PLANNED_LEADTIME" IS '以天计的计划交货时间';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SCHEDULING_MARGIN_KEY" IS '浮动的计划边际码';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SAFETY_STOCK" IS '安全库存';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MAX_INVENTORY_LEVEL" IS '最大库存水平';
COMMENT ON COLUMN "T_BASE_MATERIAL"."LOWEST_SAFE_STOCK_LIMIT" IS '安全库存的下限';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PLAN_STRATEGY_GROUP" IS '计划策略组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."INTEGRATED_MRP_ID" IS '综合MRP标识';
COMMENT ON COLUMN "T_BASE_MATERIAL"."REPLACEABLE_MATERIAL_METHOD" IS '选择可替换物料单的方法';
COMMENT ON COLUMN "T_BASE_MATERIAL"."ABORT_INDICATOR" IS '中止指示符';
COMMENT ON COLUMN "T_BASE_MATERIAL"."FOLLOW_UP_MATERIAL" IS '后续物料';
COMMENT ON COLUMN "T_BASE_MATERIAL"."INTERRUPTION_DATE" IS '中断日期';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PRODUCTION_SCHEDULER" IS '生产调度员';
COMMENT ON COLUMN "T_BASE_MATERIAL"."UNRESTRICTED_OVERDELIVERY" IS '允许未限制的过量交货';
COMMENT ON COLUMN "T_BASE_MATERIAL"."EVALUATION_CLASS" IS '评估类';
COMMENT ON COLUMN "T_BASE_MATERIAL"."PRICE_CONTROL" IS '价格控制';
COMMENT ON COLUMN "T_BASE_MATERIAL"."STANDARD_PRICE" IS '标准价格';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MAVING_AVG_PRICE" IS '移动平均价格';
COMMENT ON COLUMN "T_BASE_MATERIAL"."COST_ACCOUNTING" IS '物料根据数量结构进行成本核算';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_SOURCE" IS '物料相关的源';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SALE_NUMBER" IS '销售编码';
COMMENT ON COLUMN "T_BASE_MATERIAL"."SALE_NUMBER_DESC" IS '销售编码描述';
COMMENT ON COLUMN "T_BASE_MATERIAL"."LENGTH_WIDTH_HEIGHT" IS '长*宽*高';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_CATEGORY" IS '品类';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_CATEGORY_DESC" IS '品类描述';
COMMENT ON COLUMN "T_BASE_MATERIAL"."JIT_ITEM" IS 'JIT计划标识 ';
COMMENT ON COLUMN "T_BASE_MATERIAL"."QUOTA_ARRANGEMENT" IS '配额安排';
COMMENT ON COLUMN "T_BASE_MATERIAL"."BATCH_SIZE" IS '批量大小';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_GROUP" IS '物料组';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_GROUP_DESC" IS '物料组描述';
COMMENT ON COLUMN "T_BASE_MATERIAL"."LARGE CLASS" IS '大类';
COMMENT ON COLUMN "T_BASE_MATERIAL"."RESERVE5" IS '预留5';
COMMENT ON COLUMN "T_BASE_MATERIAL"."EXTERNAL_MATERIAL_GROUP_DESC" IS '外部物料组名称';
COMMENT ON COLUMN "T_BASE_MATERIAL"."MATERIAL_TYPE_DESC" IS '物料类型名称';
COMMENT ON COLUMN "T_BASE_MATERIAL"."LARGE CLASS_DESC" IS '大类名称';
COMMENT ON TABLE "T_BASE_MATERIAL" IS '物料';


ALTER TABLE "T_BASE_MATERIAL"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 物料属性分类
-- ----------------------------
-- DROP TABLE "T_BASE_MATERIAL_PROP_KEY_GROUP";
CREATE TABLE "T_BASE_MATERIAL_PROP_KEY_GROUP"
(
    "ID"                   NVARCHAR2(32) NOT NULL,
    "PROJECT_ID"           NVARCHAR2(32),
    "COMPANY_ID"           NVARCHAR2(32),
    "MATERIAL_CATEGORY_ID" NVARCHAR2(32),
    "GROUP_NAME"           NVARCHAR2(255),
    "GROUP_CODE"           NVARCHAR2(255)
);

COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY_GROUP"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY_GROUP"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY_GROUP"."COMPANY_ID" IS '公司id';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY_GROUP"."MATERIAL_CATEGORY_ID" IS '物料分类ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY_GROUP"."GROUP_NAME" IS '分类名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY_GROUP"."GROUP_CODE" IS '分类编码';
COMMENT ON TABLE "T_BASE_MATERIAL_PROP_KEY_GROUP" IS '物料属性分类';

ALTER TABLE "T_BASE_MATERIAL_PROP_KEY_GROUP"
    ADD PRIMARY KEY ("ID");

-- ----------------------------
-- 物料属性key
-- ----------------------------
-- DROP TABLE "T_BASE_MATERIAL_PROP_KEY";
CREATE TABLE "T_BASE_MATERIAL_PROP_KEY"
(
    "ID"                   NVARCHAR2(32) NOT NULL,
    "PROJECT_ID"           NVARCHAR2(32),
    "COMPANY_ID"           NVARCHAR2(32),
    "MATERIAL_CATEGORY_ID" NVARCHAR2(32),
    "PROP_KEY_GROUP_ID"    NVARCHAR2(32),
    "PROP_CODE"            NVARCHAR2(255),
    "PROP_KEY"             NVARCHAR2(255),
    "PROP_REMARK"          NVARCHAR2(255),
    "IS_ENABLE"            NUMBER(11) DEFAULT 1,
    "CREATE_TIME"          DATE       DEFAULT sysdate
);
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY"."COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY"."MATERIAL_CATEGORY_ID" IS '分类id';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY"."PROP_KEY_GROUP_ID" IS '属性分组key值ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY"."PROP_CODE" IS '属性code值';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY"."PROP_KEY" IS '属性key';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY"."PROP_REMARK" IS '物料特性名称备注';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY"."IS_ENABLE" IS '是否可用，1可用，0不可用';
COMMENT ON COLUMN "T_BASE_MATERIAL_PROP_KEY"."CREATE_TIME" IS '创建时间';
COMMENT ON TABLE "T_BASE_MATERIAL_PROP_KEY" IS '物料属性key';

ALTER TABLE "T_BASE_MATERIAL_PROP_KEY"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 供应商物料
-- ----------------------------
-- DROP TABLE "T_BASE_SUPPLIER_MATERIAL";
CREATE TABLE "T_BASE_SUPPLIER_MATERIAL"
(
    "ID"                     NVARCHAR2(255) NOT NULL,
    "PROJECT_ID"             NVARCHAR2(255),
    "COMPANY_ID"             NVARCHAR2(255),
    "SUPPLIER_CODE"          NVARCHAR2(255),
    "SUPPLIER_MATERIAL"      NVARCHAR2(255),
    "MATERIAL_CODE"          NVARCHAR2(255),
    "MATERIAL_VERSION"       NVARCHAR2(255),
    "VERSION"                NVARCHAR2(255),
    "BRAND"                  NVARCHAR2(255),
    "PRODUCT_AREA"           NVARCHAR2(255),
    "MIN_PACKAGE"            NVARCHAR2(255),
    "MSD_RANK"               NVARCHAR2(255),
    "ESD_RANK"               NVARCHAR2(255),
    "PCB_RANK"               NVARCHAR2(255),
    "LED_RANK"               NVARCHAR2(255),
    "PRINT_SIZE"             NVARCHAR2(255),
    "CREATE_TIME"            DATE DEFAULT sysdate,
    "CREATE_USER"            NVARCHAR2(20),
    "LAST_UPDATE_TIME"       DATE,
    "LAST_UPDATE_USER"       NVARCHAR2(20),
    "MATERIAL_DESC"          NVARCHAR2(255),
    "MATERIAL_ID"            NVARCHAR2(255),
    "SUPPLIER_NAME"          NVARCHAR2(255),
    "PUR_COMPANY_ID"         NVARCHAR2(255),
    "PUR_COMPANY_NAME"       NVARCHAR2(255),
    "SUPPLIER_MATERIAL_DESC" NVARCHAR2(255),
    "SUP_MODEL"              NVARCHAR2(255),
    "PUR_COMPANY_CODE"       VARCHAR2(255 BYTE),
    "MATREIAL_NAME"          VARCHAR2(255 BYTE),
    "COMPANY_SAP_CODE"       VARCHAR2(255 BYTE),
    "LENGTH"                 NUMBER(10, 3),
    "WIDTH"                  NUMBER(10, 3),
    "HEIGHT"                 NUMBER(10, 3),
    "GROSS_WEIGHT"           NUMBER(10, 3),
    "NET_WEIGHT"             NUMBER(10, 3),
    "BRAND_TYPE"             VARCHAR2(255 BYTE)
);

COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."SUPPLIER_CODE" IS '供应商编码';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."SUPPLIER_MATERIAL" IS '供应商物料';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."MATERIAL_CODE" IS '华阳物料';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."MATERIAL_VERSION" IS '华阳物料版本';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."VERSION" IS '软件版本SVER';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."BRAND" IS '品牌';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."PRODUCT_AREA" IS '产地';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."MIN_PACKAGE" IS '最小包装';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."MSD_RANK" IS 'MSD等级';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."ESD_RANK" IS 'ESD等级';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."PCB_RANK" IS 'PCB等级';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."LED_RANK" IS 'LED等级';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."PRINT_SIZE" IS '打印尺寸';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."MATERIAL_ID" IS '物料id';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."SUPPLIER_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."PUR_COMPANY_ID" IS '客户公司编码';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."PUR_COMPANY_NAME" IS '客户公司名称';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."SUPPLIER_MATERIAL_DESC" IS '供应商物料描述';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."SUP_MODEL" IS '型号';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."PUR_COMPANY_CODE" IS '公司编码';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."MATREIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."COMPANY_SAP_CODE" IS '供应商sap编码';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."LENGTH" IS '长度';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."WIDTH" IS '宽度';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."HEIGHT" IS '高度';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."GROSS_WEIGHT" IS '毛重';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."NET_WEIGHT" IS '净重';
COMMENT ON COLUMN "T_BASE_SUPPLIER_MATERIAL"."BRAND_TYPE" IS '品牌类型';
COMMENT ON TABLE "T_BASE_SUPPLIER_MATERIAL" IS '供应商物料';


ALTER TABLE "T_BASE_SUPPLIER_MATERIAL"
    ADD PRIMARY KEY ("ID");




