CREATE TABLE "T_MATERIAL_STORE"
(
    "ID"                             NVARCHAR2(32) NOT NULL,
    "COMPANY_ID"                     NVARCHAR2(32),
    "COMPANY_NAME"                  NVARCHAR2(32),
    "DEPARTMENT_ID"                  NVARCHAR2(32),
    "DEPARTMENT_NAME"                  NVARCHAR2(32),
    "CATEGORY_ID"                    NVARCHAR2(32),
    "CATEGORY_NAME"                  NVARCHAR2(255),
    "MATERIAL_NAME"                  NVARCHAR2(255),
    "MATERIAL_CODE"                  NVARCHAR2(255),
    "MATERIAL_SPECIFICATION"         NVARCHAR2(255),
    "DESCRIPTION"                    NVARCHAR2(255),
    "CURRENCY"                       NVARCHAR2(255),
    "PRICE"                          NUMBER(7,3) DEFAULT 0,
    "CREATE_TIME"                    DATE,
    "UPDATE_TIME"                    DATE,
    "CREATE_USER_NAME"               NVARCHAR2(255),
    "CREATE_USER_ID"                 NVARCHAR2(32),
    "PRICE_UNIT"                     NVARCHAR2(255),
    "BRAND_NAME"                     NVARCHAR2(255),
    "STORE_NUMBER"                   NUMBER(7,0) DEFAULT 0,
    "LOCK_STORE_NUMBER"              NUMBER(7,0) DEFAULT 0,
    "STORE_ID"                 VARCHAR2(50),
    "STORE_NAME"                 VARCHAR2(50),
    "BASIC_UNIT"                     NVARCHAR2(255),
	PRIMARY KEY("ID")

);
COMMENT ON COLUMN "T_MATERIAL_STORE"."ID" IS '主键';
COMMENT ON COLUMN "T_MATERIAL_STORE"."COMPANY_ID" IS '机构id';
COMMENT ON COLUMN "T_MATERIAL_STORE"."COMPANY_NAME" IS '机构名称';
COMMENT ON COLUMN "T_MATERIAL_STORE"."DEPARTMENT_ID" IS '部门id';
COMMENT ON COLUMN "T_MATERIAL_STORE"."DEPARTMENT_NAME" IS '部门名称';
COMMENT ON COLUMN "T_MATERIAL_STORE"."CATEGORY_ID" IS '物料分类id';
COMMENT ON COLUMN "T_MATERIAL_STORE"."CATEGORY_NAME" IS '物料分类名称';
COMMENT ON COLUMN "T_MATERIAL_STORE"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_MATERIAL_STORE"."MATERIAL_CODE" IS '物料标识';
COMMENT ON COLUMN "T_MATERIAL_STORE"."MATERIAL_SPECIFICATION" IS '物料规格';
COMMENT ON COLUMN "T_MATERIAL_STORE"."DESCRIPTION" IS '物料描述';
COMMENT ON COLUMN "T_MATERIAL_STORE"."CURRENCY" IS '币种';
COMMENT ON COLUMN "T_MATERIAL_STORE"."PRICE" IS '物料价格';
COMMENT ON COLUMN "T_MATERIAL_STORE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_MATERIAL_STORE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_MATERIAL_STORE"."CREATE_USER_NAME" IS '创建人名称';
COMMENT ON COLUMN "T_MATERIAL_STORE"."CREATE_USER_ID" IS '创建人';
COMMENT ON COLUMN "T_MATERIAL_STORE"."PRICE_UNIT" IS '价格单位';
COMMENT ON COLUMN "T_MATERIAL_STORE"."BRAND_NAME" IS '品牌';
COMMENT ON COLUMN "T_MATERIAL_STORE"."STORE_NUMBER" IS '库存数量';
COMMENT ON COLUMN "T_MATERIAL_STORE"."LOCK_STORE_NUMBER" IS '占用数量';
COMMENT ON COLUMN "T_MATERIAL_STORE"."STORE_ID" IS '仓库id';
COMMENT ON COLUMN "T_MATERIAL_STORE"."STORE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_MATERIAL_STORE"."BASIC_UNIT" IS '基本单位';
COMMENT ON TABLE "T_MATERIAL_STORE" IS '库存表';