/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.command;

import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.service.user.UserService;
import com.els.base.material.entity.CateoryPurchaser;
import com.els.base.material.entity.CateoryPurchaserExample;
import com.els.base.material.service.CateoryPurchaserService;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ImportCategoryPurchaserCmd
extends BaseCommand {
    private static final long serialVersionUID = 1L;
    private List<CateoryPurchaser> cateoryPurchaserList;
    private CateoryPurchaserService cateoryPurchaserService = (CateoryPurchaserService)SpringContextHolder.getOneBean(CateoryPurchaserService.class);
    private UserService userService = (UserService)SpringContextHolder.getOneBean(UserService.class);

    public ImportCategoryPurchaserCmd(List<CateoryPurchaser> cateoryPurchaserList) {
        this.cateoryPurchaserList = cateoryPurchaserList;
    }

    public Object execute(ICommandInvoker iCommandInvoker) {
        this.init(this.cateoryPurchaserList);
        List list = this.cateoryPurchaserService.queryAllObjByExample((IExample)new CateoryPurchaserExample());
        this.cateoryPurchaserList.stream().forEach(cateoryPurchaser -> this.createOrUpdate((CateoryPurchaser)cateoryPurchaser, list));
        return null;
    }

    private void init(List<CateoryPurchaser> cateoryPurchaserList) {
        Set<String> workNums1 = cateoryPurchaserList.stream().map(CateoryPurchaser::getCategoryPurchaser).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toSet());
        Set workNums2 = cateoryPurchaserList.stream().map(CateoryPurchaser::getCategoryPurchaser2).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toSet());
        workNums1.addAll(workNums2);
        List<User> users = this.getUser(workNums1);
        if (CollectionUtils.isEmpty(users)) {
            return;
        }
        for (CateoryPurchaser cateoryPurchaser : cateoryPurchaserList) {
            if (StringUtils.isBlank((String)cateoryPurchaser.getCategoryPurchaser()) && StringUtils.isBlank((String)cateoryPurchaser.getCategoryPurchaser2())) continue;
            for (User user : users) {
                if (user.getWorkNum().equals(cateoryPurchaser.getCategoryPurchaser())) {
                    cateoryPurchaser.setCategoryPurchaserId(user.getId());
                }
                if (!user.getWorkNum().equals(cateoryPurchaser.getCategoryPurchaser2())) continue;
                cateoryPurchaser.setCategoryPurchaserId2(user.getId());
            }
        }
    }

    private List<User> getUser(Set<String> workNums) {
        if (CollectionUtils.isEmpty(workNums)) {
            return null;
        }
        ArrayList<String> workNumList = new ArrayList<String>(workNums);
        UserExample example = new UserExample();
        example.createCriteria().andWorkNumIn(workNumList);
        List users = this.userService.queryAllObjByExample((IExample)example);
        return users;
    }

    private void createOrUpdate(CateoryPurchaser cateoryPurchaser, List<CateoryPurchaser> list) {
        boolean isExist = list.stream().anyMatch(purchaser -> purchaser.getMaterialCategory().equals(cateoryPurchaser.getMaterialCategory()));
        if (isExist) {
            CateoryPurchaserExample example = new CateoryPurchaserExample();
            example.createCriteria().andMaterialCategoryEqualTo(cateoryPurchaser.getMaterialCategory());
            this.cateoryPurchaserService.modifyObjByExample(cateoryPurchaser, example);
        } else {
            this.cateoryPurchaserService.addObj(cateoryPurchaser);
        }
    }
}

