/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.command;

import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.CateoryPurchaser;
import com.els.base.material.entity.CateoryPurchaserExample;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialFile;
import com.els.base.material.entity.MaterialFileExample;
import com.els.base.material.service.CateoryPurchaserService;
import com.els.base.material.service.MaterialFileService;
import com.els.base.material.service.MaterialService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ImportMaterialFileCmd
extends BaseCommand<List<MaterialFile>> {
    private static final long serialVersionUID = 1L;
    private List<MaterialFile> materialFileTree;
    private MaterialFileService materialFileService = (MaterialFileService)SpringContextHolder.getOneBean(MaterialFileService.class);
    private MaterialService materialService = (MaterialService)SpringContextHolder.getOneBean(MaterialService.class);
    private CateoryPurchaserService cateoryPurchaserService = (CateoryPurchaserService)SpringContextHolder.getOneBean(CateoryPurchaserService.class);
    private UserService userService = (UserService)SpringContextHolder.getOneBean(UserService.class);

    public ImportMaterialFileCmd(List<MaterialFile> materialFileList) {
        this.materialFileTree = materialFileList;
    }

    public List<MaterialFile> execute(ICommandInvoker context) {
        List<MaterialFile> materialFileList = this.transformTreeToList(this.materialFileTree, null);
        this.valid(materialFileList);
        this.initMaterialInfo(materialFileList);
        this.initFileInfo(materialFileList);
        this.initCategoryPurchaserInfo(materialFileList);
        this.addMaterialFile(materialFileList);
        this.deleteRepeatFile(materialFileList);
        return materialFileList;
    }

    private void deleteRepeatFile(List<MaterialFile> materialFileList) {
        List fileCodeList = materialFileList.stream().map(MaterialFile::getFileCode).distinct().collect(Collectors.toList());
        MaterialFileExample example = new MaterialFileExample();
        example.createCriteria().andFileCodeIn(fileCodeList).andMaterialCodeIsNull();
        this.materialFileService.deleteByExample((IExample)example);
    }

    private List<MaterialFile> transformTreeToList(List<MaterialFile> materialFileTree, MaterialFile parent) {
        Assert.isNotNull(materialFileTree, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<MaterialFile> materialFileList = new ArrayList<MaterialFile>();
        for (MaterialFile materialFile : materialFileTree) {
            materialFile.setId(UUIDGenerator.generateUUID());
            if (parent != null) {
                materialFile.setParentId(parent.getId());
            }
            materialFileList.add(materialFile);
            if (!CollectionUtils.isNotEmpty(materialFile.getSubFiles())) continue;
            List<MaterialFile> subFiles = this.transformTreeToList(materialFile.getSubFiles(), materialFile);
            materialFileList.addAll(subFiles);
        }
        return materialFileList;
    }

    private void initCategoryPurchaserInfo(List<MaterialFile> materialFileList) {
        List categoryList = materialFileList.stream().map(materialFile -> materialFile.getMaterialCode().substring(0, 3)).distinct().collect(Collectors.toList());
        CateoryPurchaserExample example = new CateoryPurchaserExample();
        example.createCriteria().andMaterialCategoryIn(categoryList);
        List cateoryPurchasers = this.cateoryPurchaserService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)cateoryPurchasers)) {
            this.logger.warn(String.format("EVENT=\u5bfc\u5165\u6587\u4ef6\u7269\u6599\u4fe1\u606f|MSG=\u54c1\u7c7b\u5bf9\u5e94\u91c7\u8d2d\u5458\u4e0d\u5b58\u5728 [%s]", categoryList));
            return;
        }
        if (categoryList.size() != cateoryPurchasers.size()) {
            String notFoundcategorys = categoryList.stream().filter(category -> cateoryPurchasers.stream().noneMatch(cateoryPurchaser -> cateoryPurchaser.getMaterialCategory().equals(category))).collect(Collectors.joining(","));
            this.logger.warn(String.format("EVENT=\u5bfc\u5165\u6587\u4ef6\u7269\u6599\u4fe1\u606f|MSG=\u54c1\u7c7b\u5bf9\u5e94\u91c7\u8d2d\u5458\u4e0d\u5b58\u5728 [%s]", notFoundcategorys));
        }
        this.completeCateoryPurchaser(cateoryPurchasers);
        block0: for (CateoryPurchaser cateoryPurchaser : cateoryPurchasers) {
            for (MaterialFile materialFile2 : materialFileList) {
                if (!cateoryPurchaser.getMaterialCategory().equals(materialFile2.getMaterialCode().substring(0, 3))) continue;
                materialFile2.setCategoryPurchaserId(cateoryPurchaser.getCategoryPurchaserId2());
                materialFile2.setCategoryPurchaserName(cateoryPurchaser.getCategoryPurchaserName2());
                continue block0;
            }
        }
    }

    private void completeCateoryPurchaser(List<CateoryPurchaser> cateoryPurchasers) {
        for (CateoryPurchaser cateoryPurchaser : cateoryPurchasers) {
            User user;
            if (StringUtils.isBlank((String)cateoryPurchaser.getCategoryPurchaserId()) && (user = this.getUser(cateoryPurchaser.getCategoryPurchaser())) != null) {
                cateoryPurchaser.setCategoryPurchaserId(user.getId());
            }
            if (!StringUtils.isBlank((String)cateoryPurchaser.getCategoryPurchaserId2()) || (user = this.getUser(cateoryPurchaser.getCategoryPurchaser2())) == null) continue;
            cateoryPurchaser.setCategoryPurchaserId2(user.getId());
        }
    }

    private User getUser(String workNum) {
        UserExample example = new UserExample();
        example.createCriteria().andWorkNumEqualTo(workNum);
        List users = this.userService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return null;
        }
        return (User)users.get(0);
    }

    private void addMaterialFile(List<MaterialFile> materialFileList) {
        List materialCode = materialFileList.stream().map(MaterialFile::getMaterialCode).distinct().collect(Collectors.toList());
        MaterialFileExample example = new MaterialFileExample();
        example.createCriteria().andMaterialCodeIn(materialCode);
        MaterialFile tmp = new MaterialFile();
        tmp.setIsEnable(Constant.NO_INT);
        this.materialFileService.modifyByExample(tmp, example);
        Date now = new Date();
        for (MaterialFile materialFile : materialFileList) {
            materialFile.setCreateTime(now);
            materialFile.setUpdateTime(now);
            materialFile.setIsEnable(Constant.YES_INT);
        }
        this.materialFileService.addAll(materialFileList);
    }

    private void initFileInfo(List<MaterialFile> materialFileList) {
        List fileCodeList = materialFileList.stream().map(MaterialFile::getFileCode).distinct().collect(Collectors.toList());
        MaterialFileExample example = new MaterialFileExample();
        example.createCriteria().andFileCodeIn(fileCodeList);
        List existFileList = this.materialFileService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)existFileList)) {
            return;
        }
        block0: for (MaterialFile materialFile : materialFileList) {
            for (MaterialFile existFile : existFileList) {
                if (!materialFile.getFileCode().equals(existFile.getFileCode())) continue;
                materialFile.setFileId(existFile.getFileId());
                materialFile.setFileSuffix(existFile.getFileSuffix());
                materialFile.setFileName(existFile.getFileName());
                materialFile.setFileRename(existFile.getFileRename());
                continue block0;
            }
        }
    }

    private void initMaterialInfo(List<MaterialFile> materialFileList) {
        List materialCodeList = materialFileList.stream().map(MaterialFile::getMaterialCode).distinct().collect(Collectors.toList());
        MaterialExample example = new MaterialExample();
        example.createCriteria().andMaterialCodeIn(materialCodeList);
        List materialList = this.materialService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)materialList)) {
            this.logger.warn(String.format("EVENT=\u5bfc\u5165\u6587\u4ef6\u7269\u6599\u4fe1\u606f|MSG=\u7269\u6599\u4e3b\u6570\u636e\u4e0d\u5b58\u5728 [%s]", StringUtils.join(materialCodeList, (String)",")));
            return;
        }
        if (materialCodeList.size() != materialList.size()) {
            String notFoundMaterialCodes = materialCodeList.stream().filter(materialCode -> materialList.stream().noneMatch(material -> material.getMaterialCode().equals(materialCode))).collect(Collectors.joining(","));
            this.logger.warn(String.format("EVENT=\u5bfc\u5165\u6587\u4ef6\u7269\u6599\u4fe1\u606f|MSG=\u7269\u6599\u4e3b\u6570\u636e\u4e0d\u5b58\u5728 [%s]", notFoundMaterialCodes));
        }
        for (Material material : materialList) {
            for (MaterialFile materialFile : materialFileList) {
                if (!material.getMaterialCode().equals(materialFile.getMaterialCode())) continue;
                materialFile.setMaterialId(material.getId());
                materialFile.setMaterialName(material.getMaterialName());
                materialFile.setDescription(material.getDescription());
                this.logger.debug(String.format("\u672c\u6b21\u5bfc\u5165\uff0c\u7269\u6599[%s],\u6587\u6863\u6e05\u5355[%s]", material.getMaterialCode(), materialFile.getFileName()));
            }
        }
    }

    private void valid(List<MaterialFile> materialFileList) {
        Assert.isNotNull(materialFileList, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        materialFileList.forEach(materialFile -> {
            Assert.isNotBlank((String)materialFile.getProjectId(), (String)"\u9879\u76eeId\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)materialFile.getCompanyId(), (String)"\u516c\u53f8Id\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)materialFile.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)materialFile.getFileCode(), (String)"\u6587\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)materialFile.getFileVersion(), (String)"\u6587\u4ef6\u7684\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            if (CollectionUtils.isNotEmpty(materialFile.getSubFiles())) {
                this.valid(materialFile.getSubFiles());
            }
        });
        this.validFileCodeAndName(materialFileList);
    }

    private void validFileCodeAndName(List<MaterialFile> materialFileList) {
        HashMap<String, String> fileCodeAndNameMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(materialFileList)) {
            return;
        }
        for (MaterialFile materialFile : materialFileList) {
            String fileCode = materialFile.getFileCode();
            boolean isExist = fileCodeAndNameMap.keySet().contains(fileCode);
            if (isExist) {
                if (StringUtils.equals((String)((String)fileCodeAndNameMap.get(fileCode)), (String)materialFile.getFileName())) continue;
                throw new CommonException("\u6587\u4ef6\u7f16\u7801[%s]\uff0c\u5b58\u5728\u4e0d\u540c\u7684\u6587\u4ef6\u540d[%s, %s]", fileCode, new Object[]{fileCodeAndNameMap.get(fileCode), materialFile.getFileName()});
            }
            fileCodeAndNameMap.put(materialFile.getFileCode(), materialFile.getFileName());
        }
    }
}

