/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.command;

import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.MaterialApply;
import com.els.base.material.entity.MaterialApplyExample;
import com.els.base.material.entity.MaterialApplyItemExample;
import com.els.base.material.service.MaterialApplyItemService;
import com.els.base.material.service.MaterialApplyService;
import com.els.base.material.service.impl.MaterialApplyServiceImpl;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.service.WorkFlowService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;

public class MaterialApplyApproveCmd
extends BaseCommand<String> {
    private List<MaterialApply> materialApplies;

    public List<MaterialApply> getMaterialApplies() {
        return this.materialApplies;
    }

    public void setMaterialApplies(List<MaterialApply> materialApplies) {
        this.materialApplies = materialApplies;
    }

    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.materialApplies);
        this.fill(this.materialApplies);
        this.process(this.materialApplies);
        return null;
    }

    private void process(List<MaterialApply> materialApplies) {
        List ids = materialApplies.stream().map(MaterialApply::getId).collect(Collectors.toList());
        Assert.isNotEmpty(ids, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6838\uff01");
        MaterialApplyExample example = new MaterialApplyExample();
        example.createCriteria().andIdIn(ids);
        MaterialApplyService materialApplyService = (MaterialApplyService)SpringContextHolder.getOneBean(MaterialApplyService.class);
        List list = materialApplyService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        MaterialApplyItemService materialApplyItemService = (MaterialApplyItemService)SpringContextHolder.getOneBean(MaterialApplyItemService.class);
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        for (MaterialApply materialApply : list) {
            String materialApplyStr = "material_apply";
            String materialApplyNewStr = "material_apply_new";
            MaterialApplyItemExample example1 = new MaterialApplyItemExample();
            example1.createCriteria().andApplyIdEqualTo(materialApply.getId()).andExistsFlagEqualTo(Constant.NO_INT);
            ProcessStartVO vo = null;
            int i = materialApplyItemService.countByExample(example1);
            if (i > 0) {
                vo = ProcessStartVO.newInstance((String)materialApplyNewStr, (String)materialApply.getApplyNo(), (String)materialApply.getId(), (String)("/material/materialsRequisition?id=" + materialApply.getId()));
                materialApply.setApproveNo(materialApplyNewStr);
            } else {
                vo = ProcessStartVO.newInstance((String)materialApplyStr, (String)materialApply.getApplyNo(), (String)materialApply.getId(), (String)("/material/materialsRequisition?id=" + materialApply.getId()));
                materialApply.setApproveNo(materialApplyStr);
            }
            vo.setListenerClass(MaterialApplyServiceImpl.class);
            ProcessInstance startProcess = workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            materialApply.setApproveStatus(ApproveStatusEnum.APPLYING.getValue());
            materialApplyService.modifyObj(materialApply);
        }
    }

    private void fill(List<MaterialApply> materialApplies) {
    }

    private void check(List<MaterialApply> materialApplies) {
        Assert.isNotEmpty(materialApplies, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u5ba1\u6279\u7684\u6570\u636e\uff01");
        MaterialApplyService materialApplyService = (MaterialApplyService)SpringContextHolder.getOneBean(MaterialApplyService.class);
        List collect = materialApplies.stream().map(MaterialApply::getId).collect(Collectors.toList());
        MaterialApplyExample example = new MaterialApplyExample();
        MaterialApplyExample.Criteria criteria1 = example.createCriteria().andIdIn(collect).andApproveStatusEqualTo(ApproveStatusEnum.APPLYING.getValue());
        MaterialApplyExample.Criteria criteria2 = example.createCriteria().andIdIn(collect).andApproveStatusEqualTo(ApproveStatusEnum.APPROVE_PASS.getValue());
        example.or(criteria2);
        int i = materialApplyService.countByExample(example);
        if (i > 0) {
            throw new CommonException("\u63d0\u4ea4\u7684\u5355\u636e\u53ef\u80fd\u5305\u542b\u4e86\u5ba1\u6279\u4e2d\u6216\u8005\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }
}

