/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.command;

import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.MaterialApply;
import com.els.base.material.entity.MaterialApplyItem;
import com.els.base.material.entity.MaterialApplyItemExample;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialApplyItemService;
import com.els.base.material.service.MaterialApplyService;
import com.els.base.material.service.MaterialService;
import com.els.base.utils.SpringContextHolder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MaterialApplyUpdateCmd
extends BaseCommand<String> {
    private MaterialApply materialApply;

    public MaterialApplyUpdateCmd(MaterialApply materialApply) {
        this.materialApply = materialApply;
    }

    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.materialApply);
        this.fill(this.materialApply);
        this.process(this.materialApply);
        return null;
    }

    private void process(MaterialApply materialApply) {
        MaterialApplyService materialApplyService = (MaterialApplyService)SpringContextHolder.getOneBean(MaterialApplyService.class);
        MaterialApplyItemService materialApplyItemService = (MaterialApplyItemService)SpringContextHolder.getOneBean(MaterialApplyItemService.class);
        materialApplyService.modifyObj(materialApply);
        MaterialApplyItemExample example = new MaterialApplyItemExample();
        example.createCriteria().andApplyIdEqualTo(materialApply.getId());
        materialApplyItemService.deleteByExample((IExample)example);
        List<MaterialApplyItem> materialApplyItemList = materialApply.getMaterialApplyItemList();
        for (MaterialApplyItem materialApplyItem : materialApplyItemList) {
            materialApplyItem.setApplyId(materialApply.getId());
            materialApplyItem.setApplyNo(materialApply.getApplyNo());
            materialApplyItem.setMaterialCode(null);
            if (!ObjectUtils.isEmpty((Object)materialApplyItem.getCategoryCode())) {
                materialApplyItem.setExistsFlag(Constant.YES_INT);
                continue;
            }
            materialApplyItem.setExistsFlag(Constant.NO_INT);
        }
        materialApplyItemService.addAll(materialApplyItemList);
    }

    private void fill(MaterialApply materialApply) {
        materialApply.setIsEnable(Constant.YES_INT);
        materialApply.setWriteFlag(Constant.NO_INT);
        materialApply.setUpdateTime(new Date());
    }

    private void check(MaterialApply materialApply) {
        Assert.isNotBlank((String)materialApply.getId(), (String)"\u66f4\u65b0\u6570\u636e\uff0cID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        List<MaterialApplyItem> materialApplyItemList = materialApply.getMaterialApplyItemList();
        Assert.isNotEmpty(materialApplyItemList, (String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u7533\u8bf7\u884c");
        MaterialApplyService materialApplyService = (MaterialApplyService)SpringContextHolder.getOneBean(MaterialApplyService.class);
        MaterialApply materialApply1 = (MaterialApply)materialApplyService.queryObjById(materialApply.getId());
        Assert.isNotNull((Object)materialApply1, (String)"\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        this.checkMyself(materialApplyItemList);
        this.checkMaterial(materialApplyItemList);
    }

    private void checkMaterial(List<MaterialApplyItem> materialApplyItemList) {
        for (int i = 0; i < materialApplyItemList.size(); ++i) {
            boolean b3;
            MaterialApplyItem materialApplyItem = materialApplyItemList.get(i);
            boolean b = !StringUtils.isEmpty((Object)materialApplyItem.getCategoryCode());
            boolean b1 = !StringUtils.isEmpty((Object)materialApplyItem.getBrandName());
            boolean b2 = !StringUtils.isEmpty((Object)materialApplyItem.getMaterialColour());
            boolean bl = b3 = !StringUtils.isEmpty((Object)materialApplyItem.getMaterialSpecification());
            if (!b || !b1 || !b2 || !b3) continue;
            MaterialService generateCodeService = (MaterialService)SpringContextHolder.getOneBean(MaterialService.class);
            MaterialExample example = new MaterialExample();
            example.createCriteria().andCategoryEqualTo(materialApplyItem.getCategoryCode()).andBrandNameEqualTo(materialApplyItem.getBrandName()).andMaterialColourEqualTo(materialApplyItem.getMaterialColour()).andMaterialSpecificationEqualTo(materialApplyItem.getMaterialSpecification());
            int i1 = generateCodeService.countByExample(example);
            if (i1 <= 0) continue;
            throw new CommonException("\u7b2c" + (i + 1) + "\u6761\u8bb0\u5f55\uff0c\u7269\u6599\u5206\u7c7b\u540d\u79f0\u3001\u54c1\u724c\u3001\u989c\u8272\u3001\u89c4\u683c \u5728\u7269\u6599\u5e93\u91cc\u9762\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!");
        }
    }

    private void checkMyself(List<MaterialApplyItem> materialApplyItemList) {
        for (int i = 0; i < materialApplyItemList.size(); ++i) {
            MaterialApplyItem materialApplyItem = materialApplyItemList.get(i);
            Assert.isNotNull((Object)materialApplyItem.getInventoryFlag(), (String)("\u7b2c" + (i + 1) + "\u6761\u8bb0\u5f55\uff0c\u8bf7\u586b\u5199\u662f\u5426\u7eb3\u5165\u5e93\u5b58!"));
            if (ObjectUtils.isEmpty((Object)materialApplyItem.getCategoryCode()) && ObjectUtils.isEmpty((Object)materialApplyItem.getExistsFlag())) {
                throw new CommonException("\u7b2c" + (i + 1) + "\u6761\u8bb0\u5f55\uff0c\u7269\u6599\u5206\u7c7b\u6216\u8005\u7269\u6599\u662f\u5426\u5b58\u5728\u5fc5\u987b\u586b\u5199\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5!");
            }
            Assert.isNotBlank((String)materialApplyItem.getBrandName(), (String)("\u7b2c" + (i + 1) + "\u6761\u8bb0\u5f55\uff0c\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5"));
            Assert.isNotBlank((String)materialApplyItem.getMaterialColour(), (String)("\u7b2c" + (i + 1) + "\u6761\u8bb0\u5f55\uff0c\u989c\u8272\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5"));
            Assert.isNotBlank((String)materialApplyItem.getMaterialSpecification(), (String)("\u7b2c" + (i + 1) + "\u6761\u8bb0\u5f55\uff0c\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5"));
        }
        Map<String, Long> detailMap = materialApplyItemList.stream().filter(p -> !StringUtils.isEmpty((Object)p.getCategoryCode())).collect(Collectors.groupingBy(this::fetchGroupKey, Collectors.counting()));
        if (!CollectionUtils.isEmpty(detailMap)) {
            for (Long value : detailMap.values()) {
                if (value <= 1L) continue;
                throw new CommonException("\u7269\u6599\u5206\u7c7b\u540d\u79f0\u3001\u54c1\u724c\u3001\u989c\u8272\u3001\u89c4\u683c \u5728\u7269\u6599\u7533\u8bf7\u884c\u91cc\u9762\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!");
            }
        }
    }

    private String fetchGroupKey(MaterialApplyItem materialApplyItem) {
        return materialApplyItem.getCategoryCode().trim() + materialApplyItem.getBrandName().trim() + materialApplyItem.getMaterialColour().trim() + materialApplyItem.getMaterialSpecification().trim();
    }
}

