/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.material.dao.MaterialApplyItemMapper;
import com.els.base.material.entity.MaterialApplyItem;
import com.els.base.material.entity.MaterialApplyItemExample;
import com.els.base.material.service.MaterialApplyItemService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMaterialApplyItemService")
public class MaterialApplyItemServiceImpl
implements MaterialApplyItemService {
    @Resource
    protected MaterialApplyItemMapper materialApplyItemMapper;

    @Override
    @Cacheable(value={"materialApplyItem"}, keyGenerator="redisKeyGenerator")
    public int countByExample(MaterialApplyItemExample example) {
        return this.materialApplyItemMapper.countByExample(example);
    }

    @CacheEvict(value={"materialApplyItem"}, allEntries=true)
    public void addObj(MaterialApplyItem t) {
        this.materialApplyItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"materialApplyItem"}, allEntries=true)
    public void addAll(List<MaterialApplyItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.materialApplyItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"materialApplyItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialApplyItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialApplyItem"}, allEntries=true)
    public void deleteByExample(MaterialApplyItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialApplyItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialApplyItem"}, allEntries=true)
    public void modifyObj(MaterialApplyItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.materialApplyItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialApplyItem"}, keyGenerator="redisKeyGenerator")
    public MaterialApplyItem queryObjById(String id) {
        return this.materialApplyItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialApplyItem"}, keyGenerator="redisKeyGenerator")
    public List<MaterialApplyItem> queryAllObjByExample(MaterialApplyItemExample example) {
        return this.materialApplyItemMapper.selectByExample(example);
    }

    @Cacheable(value={"materialApplyItem"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialApplyItem> queryObjByPage(MaterialApplyItemExample example) {
        PageView<MaterialApplyItem> pageView = example.getPageView();
        pageView.setQueryResult(this.materialApplyItemMapper.selectByExampleByPage(example));
        return pageView;
    }
}

