/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.material.dao.MaterialCodeMapper;
import com.els.base.material.entity.MaterialCode;
import com.els.base.material.entity.MaterialCodeExample;
import com.els.base.material.service.MaterialCodeService;
import com.els.base.material.service.MaterialService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialCodeService")
public class MaterialCodeServiceImpl
implements MaterialCodeService {
    @Resource
    protected MaterialCodeMapper materialCodeMapper;
    @Resource
    protected MaterialService materialService;

    @CacheEvict(value={"materialCode"}, allEntries=true)
    public void addObj(MaterialCode t) {
        this.materialCodeMapper.insertSelective(t);
    }

    @CacheEvict(value={"materialCode"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialCodeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialCode"}, allEntries=true)
    public void modifyObj(MaterialCode t) {
        this.materialCodeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialCode"}, keyGenerator="redisKeyGenerator")
    public MaterialCode queryObjById(String id) {
        return this.materialCodeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialCode"}, keyGenerator="redisKeyGenerator")
    public List<MaterialCode> queryAllObjByExample(MaterialCodeExample example) {
        return this.materialCodeMapper.selectByExample(example);
    }

    @Cacheable(value={"materialCode"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialCode> queryObjByPage(MaterialCodeExample example) {
        PageView<MaterialCode> pageView = example.getPageView();
        pageView.setQueryResult(this.materialCodeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"materialCode"}, allEntries=true)
    public void deleteByExample(MaterialCodeExample example) {
        Assert.isNotNull((Object)((Object)example), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialCodeMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialCode"}, allEntries=true)
    @Transactional
    public void addAll(List<MaterialCode> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.materialCodeMapper.insertSelective((MaterialCode)record));
    }
}

