/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.material.dao.MaterialFileMapper;
import com.els.base.material.entity.MaterialFile;
import com.els.base.material.entity.MaterialFileExample;
import com.els.base.material.service.MaterialFileService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMaterialFileService")
public class MaterialFileServiceImpl
implements MaterialFileService {
    @Resource
    protected MaterialFileMapper materialFileMapper;

    @CacheEvict(value={"materialFile"}, allEntries=true)
    public void addObj(MaterialFile t) {
        this.materialFileMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"materialFile"}, allEntries=true)
    public void addAll(List<MaterialFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.materialFileMapper.insertBatch(list);
    }

    @CacheEvict(value={"materialFile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialFile"}, allEntries=true)
    public void deleteByExample(MaterialFileExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialFileMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialFile"}, allEntries=true)
    public void modifyObj(MaterialFile t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.materialFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialFile"}, keyGenerator="redisKeyGenerator")
    public MaterialFile queryObjById(String id) {
        return this.materialFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialFile"}, keyGenerator="redisKeyGenerator")
    public List<MaterialFile> queryAllObjByExample(MaterialFileExample example) {
        return this.materialFileMapper.selectByExample(example);
    }

    @Cacheable(value={"materialFile"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialFile> queryObjByPage(MaterialFileExample example) {
        PageView<MaterialFile> pageView = example.getPageView();
        pageView.setQueryResult(this.materialFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"materialFile"}, allEntries=true)
    public void modifyByExample(MaterialFile materialFile, MaterialFileExample materialFileExample) {
        this.materialFileMapper.updateByExampleSelective(materialFile, materialFileExample);
    }

    @Override
    @Cacheable(value={"materialFile"}, keyGenerator="redisKeyGenerator")
    public List<MaterialFile> queryByMaterialCodeList(List<String> materialCodeList) {
        if (CollectionUtils.isEmpty(materialCodeList)) {
            return null;
        }
        List<MaterialFile> fileList = this.materialFileMapper.selectLatestVersionByMaterialCode(materialCodeList);
        return fileList.stream().filter(this.distinctByFileCode()).collect(Collectors.toList());
    }

    @Override
    @Cacheable(value={"materialFile"}, keyGenerator="redisKeyGenerator")
    public List<MaterialFile> queryByMaterialIdList(List<String> materialIdList) {
        if (CollectionUtils.isEmpty(materialIdList)) {
            return null;
        }
        List<MaterialFile> fileList = this.materialFileMapper.selectLatestVersionByMaterialId(materialIdList);
        return fileList.stream().filter(this.distinctByFileCode()).collect(Collectors.toList());
    }

    private Predicate<? super MaterialFile> distinctByFileCode() {
        HashSet fileCodeSet = new HashSet();
        return file -> fileCodeSet.add(String.format("m-%s,f-%s", file.getMaterialCode(), file.getFileCode()));
    }

    @Override
    @CacheEvict(value={"materialFile"}, allEntries=true)
    public void insertHisByMaterialCode(String materialCode) {
        this.materialFileMapper.insertHisByMaterialCode(materialCode);
    }

    @Override
    @Cacheable(value={"materialFile"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialFile> queryHisObjByPage(MaterialFileExample example) {
        PageView<MaterialFile> pageView = example.getPageView();
        pageView.setQueryResult(this.materialFileMapper.selectHisByExampleByPage(example));
        return pageView;
    }
}

