/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.command.MaterialAddCmd;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.service.MaterialService;
import com.els.base.material.vo.MaterialExportVO;
import com.els.base.material.vo.MaterialImportVO;
import com.els.base.material.vo.MaterialVO;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u7269\u6599\u7ba1\u7406"})
@Controller
@RequestMapping(value={"material"})
public class MaterialController {
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MaterialCategoryService materialCategoryService;
    @Resource
    protected ICommandInvoker invoker;
    @Resource
    protected GenerateCodeService generateCodeService;
    private static Logger logger = LoggerFactory.getLogger(MaterialController.class);

    @ApiOperation(value="\u4e0b\u8f7d\u7269\u6599Excel\u6a21\u677f", httpMethod="POST")
    @RequestMapping(value={"service/downloadMaterialTemplate"})
    public ResponseEntity<InputStreamResource> downloadMaterialTemplate() throws IOException {
        ClassPathResource resource = new ClassPathResource("import/MaterialImport.xlsx");
        InputStream inputStream = resource.getInputStream();
        HttpHeaders headers = new HttpHeaders();
        String fileName = "\u7269\u6599Excel\u5bfc\u5165\u6a21\u677f.xlsx";
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", URLEncoder.encode(fileName, "UTF-8")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)new InputStreamResource(inputStream));
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e", httpMethod="POST")
    @RequestMapping(value={"service/importExcel"})
    @ResponseBody
    public ResponseResult<String> importFromExcel(@RequestParam(value="file") MultipartFile file) {
        if (file.isEmpty()) {
            throw new CommonException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List list = new ArrayList();
        try {
            InputStream inputStream = file.getInputStream();
            ImportParams params = new ImportParams();
            params.setTitleRows(1);
            list = ExcelImportUtil.importExcel((InputStream)inputStream, MaterialImportVO.class, (ImportParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException(e.getMessage());
        }
        Assert.isNotEmpty(list, (String)"Excel\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        String projectId = ProjectUtils.getProjectId();
        User loginUser = SpringSecurityUtils.getLoginUser();
        ArrayList<Material> materials = new ArrayList<Material>();
        for (MaterialImportVO materialImportVO : list) {
            Material material = new Material();
            BeanUtils.copyProperties((Object)materialImportVO, (Object)material);
            material.setId(UUIDGenerator.generateUUID());
            material.setProjectId(projectId);
            material.setCreateTime(new Date());
            material.setIsEnable(Constant.YES_INT);
            material.setCreateUserId(loginUser.getId());
            material.setCreateUserName(loginUser.getLoginName());
            String materialCode = this.generateCodeService.getNextCode("MATERIAL_CODE");
            material.setMaterialCode(materialCode);
            materials.add(material);
        }
        Assert.isNotEmpty(materials, (String)"\u8f6c\u6362\u4e3a\u7269\u6599\u4e3b\u6570\u636e\u7684\u65f6\u5019\uff0c\u4e3a\u7a7a\uff0c\u63d2\u5165\u5931\u8d25");
        List partition = Lists.partition(materials, (int)10);
        for (List materialList : partition) {
            this.materialService.insertBatch(materialList);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7ed9\u7269\u6599\u6307\u5b9a\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/assign"})
    @ResponseBody
    public ResponseResult<String> assign(@RequestBody(required=true) MaterialVO materialVO) {
        String categoryId = materialVO.getCategoryId();
        List<String> materialIds = materialVO.getMaterialIds();
        Assert.isNotBlank((String)categoryId, (String)"\u8bf7\u6307\u5b9a\u5206\u7c7b\uff01");
        Assert.isNotEmpty(materialIds, (String)"\u8bf7\u6307\u5b9a\u7269\u6599\uff01");
        MaterialCategory materialCategory = (MaterialCategory)this.materialCategoryService.queryObjById(categoryId);
        Assert.isNotNull((Object)materialCategory, (String)"\u7269\u6599\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        this.check(materialVO, materialCategory);
        Material material = new Material();
        material.setCategoryId(categoryId);
        material.setCategory(materialCategory.getCategoryCode());
        material.setCategoryName(materialCategory.getCategoryName());
        MaterialExample example = new MaterialExample();
        example.createCriteria().andIdIn((List)materialIds);
        this.materialService.updateByExampleSelective(material, example);
        return ResponseResult.success();
    }

    private void check(MaterialVO materialVO, MaterialCategory materialCategory) {
        List<String> materialIds = materialVO.getMaterialIds();
        for (int i = 0; i < materialIds.size(); ++i) {
            boolean b3;
            String materialId = materialIds.get(i);
            Material material = (Material)this.materialService.queryObjById(materialId);
            boolean b = !org.springframework.util.StringUtils.isEmpty((Object)materialCategory.getCategoryCode());
            boolean b1 = !org.springframework.util.StringUtils.isEmpty((Object)material.getBrandName());
            boolean b2 = !org.springframework.util.StringUtils.isEmpty((Object)material.getMaterialColour());
            boolean bl = b3 = !org.springframework.util.StringUtils.isEmpty((Object)material.getMaterialSpecification());
            if (!b || !b1 || !b2 || !b3) continue;
            MaterialService generateCodeService = (MaterialService)SpringContextHolder.getOneBean(MaterialService.class);
            MaterialExample example = new MaterialExample();
            example.createCriteria().andCategoryEqualTo(materialCategory.getCategoryCode()).andBrandNameEqualTo(material.getBrandName()).andMaterialColourEqualTo(material.getMaterialColour()).andMaterialSpecificationEqualTo(material.getMaterialSpecification());
            int i1 = generateCodeService.countByExample(example);
            if (i1 <= 0) continue;
            throw new CommonException("\u7b2c" + (i + 1) + "\u6761\u8bb0\u5f55\uff0c\u7269\u6599\u5206\u7c7b\u540d\u79f0\u3001\u54c1\u724c\u3001\u989c\u8272\u3001\u89c4\u683c \u5728\u7269\u6599\u5e93\u91cc\u9762\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!");
        }
    }

    @ApiOperation(httpMethod="POST", value="\u7ba1\u7406\u5458\u521b\u5efa\u7269\u6599")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Material material) {
        material.setId(null);
        material.setProjectId(ProjectUtils.getProjectId());
        material.setCompanyId(CompanyUtils.currentCompanyId());
        material.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        material.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        material.setCreateTime(new Date());
        if (ObjectUtils.isEmpty((Object)material.getIsEnable())) {
            material.setIsEnable(Constant.YES_INT);
        }
        this.materialService.addObj(material);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7ba1\u7406\u5458\u6279\u91cf\u521b\u5efa\u7269\u6599")
    @RequestMapping(value={"service/add"})
    @ResponseBody
    public ResponseResult<String> add(@RequestBody List<Material> materials) {
        MaterialAddCmd cmd = new MaterialAddCmd(materials, ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7ba1\u7406\u5458\u7f16\u8f91\u7269\u6599")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Material material) {
        material.setProjectId(ProjectUtils.getProjectId());
        material.setCompanyId(CompanyUtils.currentCompanyId());
        material.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        material.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        if (StringUtils.isBlank((String)material.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "id_is_blank");
        }
        material.setUpdateTime(new Date());
        material.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        material.setMaterialCode(null);
        if (ObjectUtils.isEmpty((Object)material.getInventoryFlag())) {
            material.setInventoryFlag(Constant.NO_INT);
        }
        this.materialService.modifyObj(material);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25", "id_is_blank");
        }
        Material material = (Material)this.materialService.queryObjById(id);
        if (material == null) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,\u8be5\u7269\u6599\u4e0d\u5b58\u5728\uff01", "do_not_exists", new Object[]{"\u8be5\u7269\u6599"});
        }
        this.materialService.deleteObjById(material.getId());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u7269\u6599")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25", "id_is_blank");
        }
        MaterialExample example = new MaterialExample();
        example.createCriteria().andIdIn((List)ids);
        this.materialService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Material>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Material") @RequestBody(required=false) QueryParamWapper queryParamWapper) {
        MaterialExample example = new MaterialExample();
        example.setPageView((PageView<Material>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        MaterialExample.Criteria criteria = example.createCriteria();
        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        PageView pageData = this.materialService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u7269\u6599\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadMaterialExcel"})
    @ResponseBody
    public ModelAndView downloadMaterialExcel(String queryParams, HttpServletResponse response) {
        try {
            MaterialExample example = new MaterialExample();
            example.setOrderByClause("MATERIAL_CODE ASC");
            MaterialExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT);
            if (StringUtils.isNotBlank((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            }
            List materialList = this.materialService.queryAllObjByExample((IExample)example);
            ArrayList<MaterialExportVO> list = new ArrayList<MaterialExportVO>();
            if (CollectionUtils.isNotEmpty((Collection)materialList)) {
                for (Material material : materialList) {
                    MaterialExportVO materialImportVO = new MaterialExportVO();
                    BeanUtils.copyProperties((Object)material, (Object)materialImportVO);
                    list.add(materialImportVO);
                }
            }
            ServletOutputStream outputStream = response.getOutputStream();
            ExportParams params = new ExportParams("\u7269\u6599\u4e3b\u6570\u636e", "\u7269\u6599\u4e3b\u6570\u636e\u9875\u7b7e", ExcelType.XSSF);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, MaterialExportVO.class, list);
            String fileName = String.format("\u7269\u6599\u4e3b\u6570\u636e%s.xlsx", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    @ApiOperation(value="\u7269\u6599\u9009\u4e2d\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadMaterialExcelSelect"})
    @ResponseBody
    public ModelAndView downloadMaterialExcelSelect(@RequestParam(defaultValue="") String ids, HttpServletResponse response) {
        try {
            if (StringUtils.isEmpty((String)ids)) {
                throw new CommonException("\u9009\u4e2d\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
            }
            MaterialExample example = new MaterialExample();
            example.setOrderByClause("MATERIAL_CODE ASC");
            if (StringUtils.isNotBlank((String)ids)) {
                if (StringUtils.contains((String)ids, (String)",")) {
                    example.createCriteria().andIdIn((List)Arrays.asList(ids.split(",")));
                } else {
                    example.createCriteria().andIdEqualTo(ids);
                }
            }
            List materialList = this.materialService.queryAllObjByExample((IExample)example);
            ArrayList<MaterialExportVO> list = new ArrayList<MaterialExportVO>();
            if (CollectionUtils.isNotEmpty((Collection)materialList)) {
                for (Material material : materialList) {
                    MaterialExportVO materialImportVO = new MaterialExportVO();
                    BeanUtils.copyProperties((Object)material, (Object)materialImportVO);
                    list.add(materialImportVO);
                }
            }
            ServletOutputStream outputStream = response.getOutputStream();
            ExportParams params = new ExportParams("\u7269\u6599\u4e3b\u6570\u636e", "\u7269\u6599\u4e3b\u6570\u636e\u9875\u7b7e", ExcelType.XSSF);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, MaterialExportVO.class, list);
            String fileName = String.format("\u7269\u6599\u4e3b\u6570\u636e%s.xlsx", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    private void setResponseHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
    }

    public List<TitleAndModelKey> createTitleAndModelKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u89c4\u683c", (String)"materialSpecification"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u57fa\u672c\u5355\u4f4d", (String)"basicUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u5355\u4f4d", (String)"orderUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ef7\u683c\u5355\u4f4d", (String)"priceUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u724c", (String)"brandName"));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="GET", value="\u542f\u7528/\u7981\u6b62\u7269\u6599\u4fe1\u606f")
    @RequestMapping(value={"service/isEnable"})
    @ResponseBody
    public ResponseResult<Integer> isEnable(@ApiParam(value="\u7269\u6599id") String id, @ApiParam(value="\u542f\u7528\u4f201,\u7981\u7528\u4f200") Integer isEnable) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e3a\u7a7a,\u542f\u7528/\u7981\u6b62\u4f01\u4e1a\u5931\u8d25", "id_is_blank");
        }
        int result = this.materialService.isEnable(id, isEnable);
        return ResponseResult.success((Object)result);
    }
}

