/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.materialprice.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.service.DepartmentService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.materialprice.entity.MaterialPrice;
import com.els.base.materialprice.service.MaterialPriceService;
import com.els.base.utils.SpringContextHolder;
import java.util.Date;

public class MaterialPriceAddCmd
extends BaseCommand<String> {
    private MaterialPrice materialPrice;

    public MaterialPriceAddCmd(MaterialPrice materialPrice) {
        this.materialPrice = materialPrice;
    }

    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.materialPrice);
        this.fill(this.materialPrice);
        this.process(this.materialPrice);
        return this.materialPrice.getId();
    }

    private void process(MaterialPrice materialPrice) {
        MaterialPriceService materialPriceService = (MaterialPriceService)SpringContextHolder.getOneBean(MaterialPriceService.class);
        MaterialPriceService materialPriceItemService = (MaterialPriceService)SpringContextHolder.getOneBean(MaterialPriceService.class);
        DepartmentService departmentService = (DepartmentService)SpringContextHolder.getOneBean(DepartmentService.class);
        materialPriceService.addObj(materialPrice);
    }

    private void fill(MaterialPrice materialPrice) {
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String code = generateCodeService.getNextCode("MATERIAL_PRICE");
        materialPrice.setMaterialPriceNo(code);
        materialPrice.setCreateTime(new Date());
        materialPrice.setMaterialPriceOrigin("3");
    }

    private void check(MaterialPrice materialPrice) {
        Assert.isNotNull((Object)materialPrice, (String)"\u7269\u6599\u4ef7\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)materialPrice.getPrice(), (String)"\u7269\u6599\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)materialPrice.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }
}

