/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.companymaterialcategory.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyMaterialCategory;
import com.els.base.company.entity.CompanyMaterialCategoryExample;
import com.els.base.company.service.CompanyMaterialCategoryService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.companymaterialcategory.service.CompanyMaterialCategoryService2;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialCategoryExample;
import com.els.base.material.service.MaterialCategoryService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CompanyMaterialCategoryService2Impl
implements CompanyMaterialCategoryService2 {
    @Resource
    private CompanyMaterialCategoryService companyMaterialCategoryService;
    @Resource
    private MaterialCategoryService materialCategoryService;
    @Resource
    private CompanyService companyService;

    @Override
    public List<MaterialCategory> findSelectedCategoryTree(String companyCode) {
        String companyId = null;
        if (StringUtils.isEmpty((Object)companyCode)) {
            companyId = CompanyUtils.currentCompanyId();
        } else {
            Company company = this.companyService.queryCompanyByCode(companyCode);
            if (company == null) {
                throw new CommonException("\u4e0d\u5b58\u5728\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a" + companyCode + "\u7684\u4f9b\u5e94\u5546!");
            }
            companyId = company.getId();
        }
        CompanyMaterialCategoryExample example1 = new CompanyMaterialCategoryExample();
        example1.createCriteria().andCompanyIdEqualTo(companyId);
        List selectedList = this.companyMaterialCategoryService.queryAllObjByExample((IExample)example1);
        if (CollectionUtils.isEmpty((Collection)selectedList)) {
            return Collections.emptyList();
        }
        List selectedMaterialCategoryIdList = selectedList.stream().map(CompanyMaterialCategory::getMaterialCategoryId).collect(Collectors.toList());
        MaterialCategoryExample example2 = new MaterialCategoryExample();
        example2.createCriteria().andIdIn(selectedMaterialCategoryIdList).andIsEnableEqualTo(Constant.YES_INT);
        List selectedCategoryList = this.materialCategoryService.queryAllObjByExample((IExample)example2);
        if (CollectionUtils.isEmpty((Collection)selectedCategoryList)) {
            return Collections.emptyList();
        }
        return this.materialCategoryService.querySupTree(selectedCategoryList);
    }
}

