/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.service.MaterialService;
import com.els.base.utils.SpringContextHolder;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.ObjectUtils;

public class MaterialAddCmd
extends BaseCommand<String> {
    private MaterialService materialService = (MaterialService)SpringContextHolder.getOneBean(MaterialService.class);
    private MaterialCategoryService materialCategoryService = (MaterialCategoryService)SpringContextHolder.getOneBean(MaterialCategoryService.class);
    private GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
    List<Material> materialList;
    Project project;
    Company company;
    User user;

    public MaterialAddCmd(List<Material> materialList, Project project, Company company, User user) {
        this.materialList = materialList;
        this.project = project;
        this.company = company;
        this.user = user;
    }

    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.materialList);
        this.fill(this.materialList);
        this.process(this.materialList);
        return null;
    }

    private void process(List<Material> materialList) {
        for (Material material : materialList) {
            if (StringUtils.isNotBlank((String)material.getCategoryId())) {
                MaterialCategory materialCategory = (MaterialCategory)this.materialCategoryService.queryObjById(material.getCategoryId());
                Assert.isNotNull((Object)materialCategory, (String)"\u7269\u6599\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                material.setCategoryId(material.getCategoryId());
                material.setCategory(materialCategory.getCategoryCode());
                material.setCategoryName(materialCategory.getCategoryName());
            }
            if (ObjectUtils.isEmpty((Object)material.getIsEnable())) {
                material.setIsEnable(Constant.YES_INT);
            }
            if (ObjectUtils.isEmpty((Object)material.getInventoryFlag())) {
                material.setInventoryFlag(Constant.NO_INT);
            }
            if (StringUtils.isBlank((String)material.getId())) {
                material.setId(null);
                material.setProjectId(this.project.getId());
                material.setCompanyId(this.company.getId());
                material.setCreateUserId(this.user.getId());
                material.setCreateUserName(this.user.getLoginName());
                material.setCreateTime(new Date());
                String materialCode = this.generateCodeService.getNextCode("MATERIAL_CODE");
                material.setMaterialCode(materialCode);
                this.materialService.addObj(material);
                continue;
            }
            material.setProjectId(this.project.getId());
            material.setCompanyId(this.company.getId());
            material.setUpdateTime(new Date());
            material.setUpdateUserName(this.user.getLoginName());
            material.setMaterialCode(null);
            this.materialService.updateByPrimaryKeySelective(material);
        }
    }

    private void fill(List<Material> materialList) {
    }

    private void check(List<Material> materialList) {
        Assert.isNotEmpty(materialList, (String)"\u8bf7\u6307\u5b9a\u7269\u6599\uff01");
    }
}

