/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.auth.entity.Menu;
import com.els.base.auth.service.IMenuTipGenerator;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.dao.MaterialFileNoticeMapper;
import com.els.base.material.entity.MaterialFileNotice;
import com.els.base.material.entity.MaterialFileNoticeExample;
import com.els.base.material.service.MaterialFileNoticeService;
import com.els.base.material.web.controller.MaterialFileNoticeController;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMaterialFileNoticeService")
public class MaterialFileNoticeServiceImpl
implements MaterialFileNoticeService,
IMenuTipGenerator {
    @Resource
    protected MaterialFileNoticeMapper materialFileNoticeMapper;
    @Resource
    protected MaterialFileNoticeController materialFileNoticeController;

    @CacheEvict(value={"materialFileNotice"}, allEntries=true)
    public void addObj(MaterialFileNotice t) {
        this.materialFileNoticeMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"materialFileNotice"}, allEntries=true)
    public void addAll(List<MaterialFileNotice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.materialFileNoticeMapper.insertBatch(list);
    }

    @CacheEvict(value={"materialFileNotice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialFileNoticeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialFileNotice"}, allEntries=true)
    public void deleteByExample(MaterialFileNoticeExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialFileNoticeMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialFileNotice"}, allEntries=true)
    public void modifyObj(MaterialFileNotice t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.materialFileNoticeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialFileNotice"}, keyGenerator="redisKeyGenerator")
    public MaterialFileNotice queryObjById(String id) {
        return this.materialFileNoticeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialFileNotice"}, keyGenerator="redisKeyGenerator")
    public List<MaterialFileNotice> queryAllObjByExample(MaterialFileNoticeExample example) {
        return this.materialFileNoticeMapper.selectByExample(example);
    }

    @Cacheable(value={"materialFileNotice"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialFileNotice> queryObjByPage(MaterialFileNoticeExample example) {
        PageView<MaterialFileNotice> pageView = example.getPageView();
        pageView.setQueryResult(this.materialFileNoticeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"materialFileNotice"}, keyGenerator="redisKeyGenerator")
    public List<MaterialFileNotice> selectUnConfirmByMaterialCodes(List<String> materialCodes, String supCompanyId) {
        MaterialFileNoticeExample example = new MaterialFileNoticeExample();
        example.createCriteria().andSupCompanyIdEqualTo(supCompanyId).andConfirmStatusEqualTo(Constant.NO_INT).andMaterialCodeIn((List)materialCodes);
        return this.materialFileNoticeMapper.selectByExample(example);
    }

    @Override
    @CacheEvict(value={"materialFileNotice"}, allEntries=true)
    public void modifyByExmaple(MaterialFileNotice notice, MaterialFileNoticeExample example) {
        this.materialFileNoticeMapper.updateByExampleSelective(notice, example);
    }

    public String generate(Menu menu) {
        if (menu == null) {
            return null;
        }
        int rowCount = 0;
        switch (menu.getMenuCode()) {
            case "designDocumentSup": {
                rowCount = ((PageView)this.materialFileNoticeController.supFindByPageConfrimed().getData()).getRowCount();
            }
        }
        return String.valueOf(rowCount);
    }

    public boolean isMatchMenuCode(String menuCode) {
        return "designDocumentSup".equals(menuCode);
    }
}

