/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.dao.MaterialExtMapper;
import com.els.base.material.dao.MaterialMapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialExt;
import com.els.base.material.entity.MaterialExtExample;
import com.els.base.material.service.MaterialService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialService")
public class MaterialServiceImpl
implements MaterialService {
    @Resource
    protected MaterialMapper materialMapper;
    @Resource
    protected MaterialExtMapper materialExtMapper;

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public int updateByPrimaryKeySelective(Material record) {
        return this.materialMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(Material record, MaterialExample example) {
        return this.materialMapper.updateByExampleSelective(record, example);
    }

    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public void addObj(Material t) {
        this.materialMapper.insertSelective(t);
    }

    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public void modifyObj(Material t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public Material queryObjById(String id) {
        return this.materialMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public List<Material> queryAllObjByExample(MaterialExample example) {
        return this.materialMapper.selectByExample(example);
    }

    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public PageView<Material> queryObjByPage(MaterialExample example) {
        PageView<Material> pageView = example.getPageView();
        pageView.setQueryResult(this.materialMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    public int isEnable(String materialId, Integer isEnable) {
        Material material = new Material();
        material.setId(materialId);
        material.setIsEnable(isEnable);
        return this.materialMapper.updateByPrimaryKeySelective(material);
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    public void importMaterial(List<Material> materials) {
        if (materials == null) {
            throw new IllegalArgumentException("parameter materials is null");
        }
        for (Material material : materials) {
            String projectId = material.getProjectId();
            String companyId = material.getCompanyId();
            String materialCode = material.getMaterialCode();
            MaterialExample materialExample = new MaterialExample();
            MaterialExample.Criteria criteria = materialExample.createCriteria();
            criteria.andProjectIdEqualTo(projectId).andCompanyIdEqualTo(companyId).andMaterialCodeEqualTo(materialCode);
            int count = this.materialMapper.countByExample(materialExample);
            if (count > 0) {
                this.materialMapper.updateByExampleSelective(material, materialExample);
                continue;
            }
            this.materialMapper.insertSelective(material);
        }
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public Boolean isExists(String materialCode) {
        if (StringUtils.isBlank((String)materialCode)) {
            throw new IllegalArgumentException("parameter materialCode is null");
        }
        MaterialExample materialExample = new MaterialExample();
        MaterialExample.Criteria criteria = materialExample.createCriteria();
        criteria.andMaterialCodeEqualTo(materialCode);
        int count = this.materialMapper.countByExample(materialExample);
        if (count > 0) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isJTL(String materialCode) {
        if (StringUtils.isEmpty((String)materialCode)) {
            throw new CommonException("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MaterialExample materialExample = new MaterialExample();
        materialExample.createCriteria().andMaterialCodeEqualTo(materialCode).andLogProGroupEqualTo("L003");
        int count = this.materialMapper.countByExample(materialExample);
        return count != 0;
    }

    @Override
    @Transactional
    @CacheEvict(value={"material"}, allEntries=true)
    public void add(Material material) {
        this.materialMapper.insertSelective(material);
    }

    @Override
    @Transactional
    @CacheEvict(value={"material"}, allEntries=true)
    public void modifyByExampleSelective(Material material, MaterialExample example) {
        this.materialMapper.updateByExampleSelective(material, example);
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public int countByExample(MaterialExample example) {
        return this.materialMapper.countByExample(example);
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public List<MaterialExt> queryMaterialExtByExampl(MaterialExtExample extExample) {
        return this.materialExtMapper.selectByExample(extExample);
    }

    @Override
    @Transactional
    @CacheEvict(value={"material"}, allEntries=true)
    public void addMaterialExt(MaterialExt ext) {
        this.materialExtMapper.insert(ext);
    }

    @Override
    @Transactional
    @CacheEvict(value={"material"}, allEntries=true)
    public void modifyMaterialExtByExample(MaterialExt ext, MaterialExtExample extExample) {
        this.materialExtMapper.updateByExampleSelective(ext, extExample);
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public PageView<Material> queryExtByPage(MaterialExample example, MaterialExtExample extexample) {
        PageView<Material> pageView = example.getPageView();
        extexample.getOredCriteria().get(0).andJitItemIsNotNull();
        List<MaterialExt> materialCodeLists = this.materialExtMapper.selectByExampleGroupCodeByPage(extexample);
        if (CollectionUtils.isEmpty(materialCodeLists)) {
            return pageView;
        }
        List ids = materialCodeLists.stream().map(materialExt -> materialExt.getId()).collect(Collectors.toList());
        MaterialExample materialExample = new MaterialExample();
        materialExample.createCriteria().andIdIn(ids);
        List<Material> lists = this.materialMapper.selectByExampleByPage(materialExample);
        lists.stream().forEach(material -> {
            for (MaterialExt ext : materialCodeLists) {
                if (!material.getId().equals(ext.getId())) continue;
                material.setJitItem(ext.getJitItem());
                materialCodeLists.remove(ext);
                break;
            }
        });
        pageView.setQueryResult(lists);
        pageView.setRowCount(extexample.getPageView().getRowCount());
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"material"}, allEntries=true)
    public void addMaterialExtAll(List<MaterialExt> extList) {
        if (CollectionUtils.isEmpty(extList)) {
            return;
        }
        for (MaterialExt materialExt : extList) {
            if (!StringUtils.isBlank((String)materialExt.getId())) continue;
            materialExt.setId(UUIDGenerator.generateUUID());
        }
        this.materialExtMapper.insertBatch(extList);
    }

    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public void addAll(List<Material> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (Material material : list) {
            if (!StringUtils.isBlank((String)material.getId())) continue;
            material.setId(UUIDGenerator.generateUUID());
        }
        this.materialMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"material"}, allEntries=true)
    @Transactional
    public void insertBatch(List<Material> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (Material material : list) {
                material.setId(UUIDGenerator.generateUUID());
            }
            this.materialMapper.insertBatch(list);
        }
    }

    @Transactional
    @CacheEvict(value={"material"}, allEntries=true)
    public void deleteByExample(MaterialExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialMapper.deleteByExample(example);
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialExt> queryMaterialExtByPage(MaterialExtExample extexample) {
        PageView<MaterialExt> pageView = extexample.getPageView();
        pageView.setQueryResult(this.materialExtMapper.selectByExampleByPage(extexample));
        return pageView;
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public Material queryObjByCode(String materialCode) {
        MaterialExample materialExample = new MaterialExample();
        MaterialExample.Criteria criteria = materialExample.createCriteria();
        criteria.andMaterialCodeEqualTo(materialCode);
        List<Material> list = this.materialMapper.selectByExample(materialExample);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<Material> queryByMaterialCategory(String materialCategory) {
        List<Material> list = this.materialMapper.selectByMaterialCategory(materialCategory);
        return list;
    }

    @Override
    public PageView<Material> queryMaterialCategoryByPage(MaterialExample example) {
        PageView<Material> pageView = example.getPageView();
        pageView.setQueryResult(this.materialMapper.selectByCategoryByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"material"}, keyGenerator="redisKeyGenerator")
    public String getMaterialJitItem(String materialCode, String factory) {
        MaterialExtExample example = new MaterialExtExample();
        example.createCriteria().andMaterialCodeEqualTo(materialCode).andFactoryEqualTo(factory);
        List<MaterialExt> materialExtList = this.materialExtMapper.selectByExample(example);
        if (materialExtList.size() > 0) {
            return materialExtList.get(0).getJitItem();
        }
        return null;
    }

    @Override
    public List<Material> queryMaterialCode(String materialCategory, String factory) {
        return this.materialMapper.selectByMaterialCodeExampleByPage(materialCategory, factory);
    }
}

