/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.command.MaterialApplyAddCmd;
import com.els.base.material.command.MaterialApplyApproveCmd;
import com.els.base.material.command.MaterialApplyDeleteCmd;
import com.els.base.material.command.MaterialApplyUpdateCmd;
import com.els.base.material.entity.MaterialApply;
import com.els.base.material.entity.MaterialApplyExample;
import com.els.base.material.entity.MaterialApplyItemExample;
import com.els.base.material.service.MaterialApplyItemService;
import com.els.base.material.service.MaterialApplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u7269\u6599\u7533\u8bf7\u5355"})
@Controller
@RequestMapping(value={"materialApply"})
public class MaterialApplyController {
    @Resource
    protected MaterialApplyService materialApplyService;
    @Resource
    protected MaterialApplyItemService materialApplyItemService;
    @Resource
    protected ICommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u63d0\u4ea4\u5ba1\u6279")
    @RequestMapping(value={"service/approve"})
    @ResponseBody
    public ResponseResult<String> approve(@RequestBody MaterialApply materialApply) {
        ArrayList<MaterialApply> materialApplys = new ArrayList<MaterialApply>();
        materialApplys.add(materialApply);
        MaterialApplyApproveCmd cmd = new MaterialApplyApproveCmd();
        cmd.setMaterialApplies(materialApplys);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u63d0\u4ea4\u5ba1\u6279")
    @RequestMapping(value={"service/approves"})
    @ResponseBody
    public ResponseResult<String> approve(@RequestBody List<MaterialApply> materialApplys) {
        MaterialApplyApproveCmd cmd = new MaterialApplyApproveCmd();
        cmd.setMaterialApplies(materialApplys);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u7269\u6599\u7533\u8bf7\u7f16\u53f7\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<MaterialApply> findById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u7533\u8bf7ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MaterialApply materialApply = (MaterialApply)this.materialApplyService.queryObjById(id);
        Assert.isNotNull((Object)materialApply, (String)"\u4e0d\u5b58\u5728\u8be5\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\uff01");
        MaterialApplyItemExample example = new MaterialApplyItemExample();
        example.createCriteria().andApplyIdEqualTo(id);
        List materialApplyItems = this.materialApplyItemService.queryAllObjByExample((IExample)example);
        materialApply.setMaterialApplyItemList(materialApplyItems);
        return ResponseResult.success((Object)materialApply);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u7269\u6599\u7533\u8bf7\u7f16\u53f7\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"service/detail"})
    @ResponseBody
    public ResponseResult<MaterialApply> detail(@RequestParam(required=true) String applyNo) {
        Assert.isNotBlank((String)applyNo, (String)"\u7533\u8bf7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MaterialApplyExample example = new MaterialApplyExample();
        example.createCriteria().andApplyNoEqualTo(applyNo);
        List materialApplies = this.materialApplyService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)materialApplies, (String)"\u4e0d\u5b58\u5728\u8be5\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\uff01");
        MaterialApply materialApply = (MaterialApply)materialApplies.get(0);
        MaterialApplyItemExample materialApplyItemExample = new MaterialApplyItemExample();
        materialApplyItemExample.createCriteria().andApplyIdEqualTo(materialApply.getId());
        List materialApplyItems = this.materialApplyItemService.queryAllObjByExample((IExample)materialApplyItemExample);
        materialApply.setMaterialApplyItemList(materialApplyItems);
        return ResponseResult.success((Object)materialApply);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterialApply materialApply) {
        materialApply.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        materialApply.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        materialApply.setCreateTime(new Date());
        materialApply.setProjectId(ProjectUtils.getProjectId());
        materialApply.setIsEnable(Constant.YES_INT);
        MaterialApplyAddCmd cmd = new MaterialApplyAddCmd(materialApply);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success((Object)materialApply.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialApply materialApply) {
        materialApply.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        MaterialApplyUpdateCmd cmd = new MaterialApplyUpdateCmd(materialApply);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        MaterialApplyDeleteCmd cmd = new MaterialApplyDeleteCmd(ids);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u7533\u8bf7\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialApply", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialApply>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialApplyExample example = new MaterialApplyExample();
        example.setPageView((PageView<MaterialApply>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        MaterialApplyExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andCreateUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        PageView pageData = this.materialApplyService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

