/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.materialprice.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.service.MaterialService;
import com.els.base.materialprice.dao.MaterialPriceMapper;
import com.els.base.materialprice.entity.MaterialPrice;
import com.els.base.materialprice.entity.MaterialPriceExample;
import com.els.base.materialprice.service.MaterialPriceService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMaterialPriceService")
public class MaterialPriceServiceImpl
implements MaterialPriceService {
    private static final Logger logger = LoggerFactory.getLogger(MaterialPriceServiceImpl.class);
    @Resource
    protected MaterialPriceMapper materialPriceMapper;
    @Resource
    private MaterialService materialService;
    @Resource
    private MaterialCategoryService materialCategoryService;

    @CacheEvict(value={"materialPrice"}, allEntries=true)
    public void addObj(MaterialPrice t) {
        this.materialPriceMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"materialPrice"}, allEntries=true)
    public void addAll(List<MaterialPrice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.materialPriceMapper.insertBatch(list);
    }

    @CacheEvict(value={"materialPrice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialPriceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialPrice"}, allEntries=true)
    public void deleteByExample(MaterialPriceExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialPriceMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialPrice"}, allEntries=true)
    public void modifyObj(MaterialPrice t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.materialPriceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialPrice"}, keyGenerator="redisKeyGenerator")
    public MaterialPrice queryObjById(String id) {
        return this.materialPriceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialPrice"}, keyGenerator="redisKeyGenerator")
    public List<MaterialPrice> queryAllObjByExample(MaterialPriceExample example) {
        return this.materialPriceMapper.selectByExample(example);
    }

    @Cacheable(value={"materialPrice"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialPrice> queryObjByPage(MaterialPriceExample example) {
        PageView<MaterialPrice> pageView = example.getPageView();
        pageView.setQueryResult(this.materialPriceMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public PageView<MaterialPrice> findSuppliableSupplierByPage(String institutionCode, String materialCode, String currency, MaterialPriceExample example) {
        Material material = this.materialService.queryObjByCode(materialCode);
        if (material == null) {
            logger.warn("findSuppliableSupplierByPage(s,s,m) => \u627e\u4e0d\u5230\u7f16\u7801\u4e3a{}\u7684\u7269\u6599!", (Object)materialCode);
            return PageView.empty();
        }
        String categoryCode = material.getCategory();
        if (StringUtils.isBlank((String)categoryCode)) {
            logger.warn("findSuppliableSupplierByPage(s,s,m) => \u7269\u6599{}\u672a\u6307\u5b9a\u7269\u6599\u5206\u7c7b!", (Object)materialCode);
            return PageView.empty();
        }
        MaterialCategory category = this.materialCategoryService.findByCode(categoryCode);
        if (category == null) {
            throw new CommonException("findSuppliableSupplierByPage(s,s,m) => \u627e\u4e0d\u5230\u7f16\u7801\u4e3a" + categoryCode + "\u7684\u7269\u6599\u5206\u7c7b!");
        }
        List<MaterialPrice> result = this.materialPriceMapper.findSuppliableSupplierByPage(institutionCode, materialCode, category.getId(), currency, example);
        PageView<MaterialPrice> pageView = example.getPageView();
        pageView.setQueryResult(result);
        return pageView;
    }
}

