/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.materialprice.web.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.materialprice.command.MaterialPriceAddCmd;
import com.els.base.materialprice.entity.MaterialPrice;
import com.els.base.materialprice.entity.MaterialPriceExample;
import com.els.base.materialprice.service.MaterialPriceService;
import com.els.base.materialprice.vo.ExportMaterialPriceVO;
import com.els.base.materialprice.vo.ImportMaterialPriceVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u7269\u6599\u4ef7\u683c\u8868"})
@Controller
@RequestMapping(value={"materialPrice"})
public class MaterialPriceController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected MaterialPriceService materialPriceService;
    @Resource
    protected ICommandInvoker invoker;

    @ApiOperation(value="\u4e0b\u8f7d\u7269\u6599Excel\u6a21\u677f", httpMethod="POST")
    @RequestMapping(value={"service/template"})
    public ResponseEntity<InputStreamResource> template() throws IOException {
        ClassPathResource resource = new ClassPathResource("import/MaterialPriceImport.xlsx");
        InputStream inputStream = resource.getInputStream();
        HttpHeaders headers = new HttpHeaders();
        String fileName = "\u7269\u6599\u4ef7\u683cExcel\u5bfc\u5165\u6a21\u677f.xlsx";
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", URLEncoder.encode(fileName, "UTF-8")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)new InputStreamResource(inputStream));
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u4ef7\u683c", httpMethod="POST")
    @RequestMapping(value={"service/import"})
    @ResponseBody
    public ResponseResult<String> importFromExcel(@RequestParam(value="file") MultipartFile file) {
        if (file.isEmpty()) {
            throw new CommonException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List list = new ArrayList();
        try {
            InputStream inputStream = file.getInputStream();
            ImportParams params = new ImportParams();
            params.setTitleRows(1);
            list = ExcelImportUtil.importExcel((InputStream)inputStream, ImportMaterialPriceVO.class, (ImportParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException(e.getMessage());
        }
        Assert.isNotEmpty(list, (String)"\u8bf7\u5bfc\u5165\u6709\u6548\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
        for (ImportMaterialPriceVO materialPriceVO : list) {
            MaterialPrice materialPrice = new MaterialPrice();
            BeanUtils.copyProperties((Object)materialPriceVO, (Object)materialPrice);
            MaterialPriceAddCmd cmd = new MaterialPriceAddCmd(materialPrice);
            this.invoker.invoke((BaseCommand)cmd);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u51fa\u7269\u6599\u4ef7\u683c\u8868")
    @RequestMapping(value={"service/export"})
    @ResponseBody
    public ModelAndView export(@RequestParam(defaultValue="") String ids, HttpServletResponse response) {
        try {
            MaterialPriceExample example = new MaterialPriceExample();
            example.setOrderByClause("ID ASC");
            if (StringUtils.isNotBlank((String)ids)) {
                if (StringUtils.contains((String)ids, (String)",")) {
                    example.createCriteria().andIdIn((List)Arrays.asList(ids.split(",")));
                } else {
                    example.createCriteria().andIdEqualTo(ids);
                }
            }
            List materialList = this.materialPriceService.queryAllObjByExample((IExample)example);
            ArrayList<ExportMaterialPriceVO> list = new ArrayList<ExportMaterialPriceVO>();
            if (CollectionUtils.isNotEmpty((Collection)materialList)) {
                for (MaterialPrice materialPrice : materialList) {
                    ExportMaterialPriceVO exportMaterialPriceVO = new ExportMaterialPriceVO();
                    BeanUtils.copyProperties((Object)materialPrice, (Object)exportMaterialPriceVO);
                    list.add(exportMaterialPriceVO);
                }
            }
            ServletOutputStream outputStream = response.getOutputStream();
            ExportParams params = new ExportParams("\u7269\u6599\u4ef7\u683c\u8868", "\u7269\u6599\u4ef7\u683c\u8868", ExcelType.XSSF);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, ExportMaterialPriceVO.class, list);
            String fileName = String.format("\u7269\u6599\u4ef7\u683c\u8868%s.xlsx", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    private void setResponseHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u4ef7\u683c\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterialPrice materialPrice) {
        MaterialPriceAddCmd cmd = new MaterialPriceAddCmd(materialPrice);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success((Object)materialPrice.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u4ef7\u683c\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialPrice materialPrice) {
        Assert.isNotBlank((String)materialPrice.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.materialPriceService.modifyObj(materialPrice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u7f16\u8f91\u7269\u6599\u4ef7\u683c\u8868")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<MaterialPrice> findById(@RequestParam String id) {
        Assert.isNotBlank((String)id, (String)"id \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        MaterialPrice materialPrice = (MaterialPrice)this.materialPriceService.queryObjById(id);
        return ResponseResult.success((Object)materialPrice);
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u4ef7\u683c\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        MaterialPriceExample example = new MaterialPriceExample();
        example.createCriteria().andIdIn((List)ids);
        this.materialPriceService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u4ef7\u683c\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialPrice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialPrice>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialPriceExample example = new MaterialPriceExample();
        example.setPageView((PageView<MaterialPrice>)new PageView(pageNo, pageSize));
        example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialPriceService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u4ef7\u683c\u8868")
    @RequestMapping(value={"service/findSuppliableSupplier"})
    @ResponseBody
    public ResponseResult<PageView<MaterialPrice>> findSuppliableSupplier(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        Assert.isNotNull((Object)wapper, (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String institutionCode = wapper.getParamValue("institutionCode");
        Assert.isNotBlank((String)institutionCode, (String)"\u53d1\u8d77\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        wapper.removeParam("institutionCode");
        String materialCode = wapper.getParamValue("materialCode");
        Assert.isNotBlank((String)materialCode, (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        wapper.removeParam("materialCode");
        String currency = wapper.getParamValue("currency");
        Assert.isNotBlank((String)currency, (String)"\u5e01\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        wapper.removeParam("currency");
        MaterialPriceExample example = new MaterialPriceExample();
        example.setPageView((PageView<MaterialPrice>)new PageView(pageNo, pageSize));
        example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<MaterialPrice> result = this.materialPriceService.findSuppliableSupplierByPage(institutionCode, materialCode, currency, example);
        return ResponseResult.success(result);
    }
}

