/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.materialstore.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.materialstore.dao.MaterialStoreDetailedMapper;
import com.els.base.materialstore.entity.MaterialStoreDetailed;
import com.els.base.materialstore.entity.MaterialStoreDetailedExample;
import com.els.base.materialstore.service.MaterialStoreDetailedService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMaterialStoreDetailedService")
public class MaterialStoreDetailedServiceImpl
implements MaterialStoreDetailedService {
    @Resource
    protected MaterialStoreDetailedMapper materialStoreDetailedMapper;

    @CacheEvict(value={"materialStoreDetailed"}, allEntries=true)
    public void addObj(MaterialStoreDetailed t) {
        this.materialStoreDetailedMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"materialStoreDetailed"}, allEntries=true)
    public void addAll(List<MaterialStoreDetailed> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.materialStoreDetailedMapper.insertBatch(list);
    }

    @CacheEvict(value={"materialStoreDetailed"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialStoreDetailedMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialStoreDetailed"}, allEntries=true)
    public void deleteByExample(MaterialStoreDetailedExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialStoreDetailedMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialStoreDetailed"}, allEntries=true)
    public void modifyObj(MaterialStoreDetailed t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.materialStoreDetailedMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialStoreDetailed"}, keyGenerator="redisKeyGenerator")
    public MaterialStoreDetailed queryObjById(String id) {
        return this.materialStoreDetailedMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialStoreDetailed"}, keyGenerator="redisKeyGenerator")
    public List<MaterialStoreDetailed> queryAllObjByExample(MaterialStoreDetailedExample example) {
        return this.materialStoreDetailedMapper.selectByExample(example);
    }

    @Cacheable(value={"materialStoreDetailed"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialStoreDetailed> queryObjByPage(MaterialStoreDetailedExample example) {
        PageView<MaterialStoreDetailed> pageView = example.getPageView();
        pageView.setQueryResult(this.materialStoreDetailedMapper.selectByExampleByPage(example));
        return pageView;
    }
}

