/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.materialstore.web.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.collection.CollectionUtil;
import com.els.base.company.entity.Department;
import com.els.base.company.enums.DepartmentTypeEnum;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.materialstore.entity.MaterialStore;
import com.els.base.materialstore.entity.MaterialStoreExample;
import com.els.base.materialstore.service.MaterialStoreService;
import com.els.base.materialstore.web.vo.CheckStoreVO;
import com.els.base.materialstore.web.vo.MaterialStoreVO;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5e93\u5b58\u8868"})
@Controller
@RequestMapping(value={"materialStore"})
public class MaterialStoreController {
    @Resource
    protected MaterialStoreService materialStoreService;

    @ApiOperation(httpMethod="POST", value="\u68c0\u67e5\u5e93\u5b58\u662f\u5426\u6ee1\u8db3")
    @RequestMapping(value={"service/checkStoreNumber"})
    @ResponseBody
    public ResponseResult<List<CheckStoreVO>> checkStoreNumber(@RequestBody List<CheckStoreVO> checkStoreVOS) {
        Assert.isNotEmpty(checkStoreVOS, (String)"\u68c0\u67e5\u4fe1\u606f\u4e3a\u7a7a\uff01\u64cd\u4f5c\u5931\u8d25");
        return ResponseResult.success(this.materialStoreService.checkStoreNumberReturnList(checkStoreVOS));
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5e93\u5b58\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterialStore materialStore) {
        this.materialStoreService.addObj(materialStore);
        return ResponseResult.success((Object)materialStore.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5e93\u5b58\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialStore materialStore) {
        Assert.isNotBlank((String)materialStore.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.materialStoreService.modifyObj(materialStore);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5e93\u5b58\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        MaterialStoreExample example = new MaterialStoreExample();
        example.createCriteria().andIdIn((List)ids);
        this.materialStoreService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5e93\u5b58\u4fe1\u606f\u5bfc\u51faexcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadMaterialStoreExcel"})
    @ResponseBody
    public ModelAndView downloadMaterialStoreExcel(String queryParams, HttpServletResponse response) {
        try {
            MaterialStoreExample example = new MaterialStoreExample();
            example.setOrderByClause("MATERIAL_CODE ASC");
            if (StringUtils.isNotBlank((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            }
            List materialStoreList = this.materialStoreService.queryAllObjByExample((IExample)example);
            ArrayList list = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)materialStoreList)) {
                materialStoreList.forEach(materialStore -> {
                    MaterialStoreVO materialStoreVO = new MaterialStoreVO();
                    BeanUtils.copyProperties((Object)materialStore, (Object)materialStoreVO);
                    list.add(materialStoreVO);
                });
            }
            ServletOutputStream outputStream = response.getOutputStream();
            ExportParams params = new ExportParams("\u5e93\u5b58\u4e3b\u6570\u636e", "\u5e93\u5b58\u4e3b\u6570\u636e\u9875\u7b7e", ExcelType.XSSF);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, MaterialStoreVO.class, list);
            String fileName = String.format("\u5e93\u5b58\u4e3b\u6570\u636e%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5e93\u5b58\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialStore", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialStore>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ArrayList<String> departmentType = new ArrayList<String>();
        departmentType.add(DepartmentTypeEnum.IN_THE_ORGANIZATION.getCode());
        List departments = CompanyUtils.getDepartmentByType(departmentType);
        if (CollectionUtil.isEmpty((Collection)departments)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        List ids = departments.stream().map(Department::getId).collect(Collectors.toList());
        MaterialStoreExample example = new MaterialStoreExample();
        example.setPageView((PageView<MaterialStore>)new PageView(pageNo, pageSize));
        MaterialStoreExample.Criteria criteria = example.createCriteria();
        criteria.andInstitutionIdIn(ids);
        example.or(criteria);
        example.setOrderByClause("CREATE_TIME DESC");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialStoreService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6ca1\u6709\u6570\u636e\u6743\u9650")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialStore", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByMaterialStoreInfo"})
    @ResponseBody
    public ResponseResult<PageView<MaterialStore>> findByMaterialStoreInfo(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialStoreExample example = new MaterialStoreExample();
        example.setPageView((PageView<MaterialStore>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialStoreService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5e93\u5b58\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialStore", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findGetPageByCode"})
    @ResponseBody
    public ResponseResult<PageView<MaterialStore>> findGetPageByCode(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialStoreExample example = new MaterialStoreExample();
        example.setPageView((PageView<MaterialStore>)new PageView(pageNo, pageSize));
        MaterialStoreExample.Criteria criteria = example.createCriteria();
        example.setOrderByClause("CREATE_TIME DESC");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialStoreService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    private void setResponseHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
    }
}

