/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.materialstore.web.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.materialstore.entity.MaterialStoreDetailed;
import com.els.base.materialstore.entity.MaterialStoreDetailedExample;
import com.els.base.materialstore.service.MaterialStoreDetailedService;
import com.els.base.materialstore.web.vo.MaterialStoreDetailedVO;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u5e93\u5b58\u660e\u7ec6")
@Controller
@RequestMapping(value={"materialStoreDetailed"})
public class MaterialStoreDetailedController {
    @Resource
    protected MaterialStoreDetailedService materialStoreDetailedService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5e93\u5b58\u660e\u7ec6")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterialStoreDetailed materialStoreDetailed) {
        this.materialStoreDetailedService.addObj(materialStoreDetailed);
        return ResponseResult.success((Object)materialStoreDetailed.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5e93\u5b58\u660e\u7ec6")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialStoreDetailed materialStoreDetailed) {
        Assert.isNotBlank((String)materialStoreDetailed.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.materialStoreDetailedService.modifyObj(materialStoreDetailed);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5e93\u5b58\u660e\u7ec6")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        MaterialStoreDetailedExample example = new MaterialStoreDetailedExample();
        example.createCriteria().andIdIn((List)ids);
        this.materialStoreDetailedService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5e93\u5b58\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialStoreDetailed", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialStoreDetailed>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        List ids = CompanyUtils.findByDepartmentTypeReturnList();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        MaterialStoreDetailedExample example = new MaterialStoreDetailedExample();
        example.setPageView((PageView<MaterialStoreDetailed>)new PageView(pageNo, pageSize));
        MaterialStoreDetailedExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialStoreDetailedService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u5e93\u5b58\u4fe1\u606f\u5bfc\u51faexcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadMaterialStoreDetailedExcel"})
    @ResponseBody
    public ModelAndView downloadMaterialStoreDetailedExcel(String queryParams, HttpServletResponse response) {
        try {
            MaterialStoreDetailedExample example = new MaterialStoreDetailedExample();
            example.setOrderByClause("CREATE_TIME desc");
            if (StringUtils.isNotBlank((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            }
            List materialStoreDetaileds = this.materialStoreDetailedService.queryAllObjByExample((IExample)example);
            ArrayList list = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)materialStoreDetaileds)) {
                materialStoreDetaileds.forEach(materialStoreDetailed -> {
                    MaterialStoreDetailedVO materialStoreVO = new MaterialStoreDetailedVO();
                    BeanUtils.copyProperties((Object)materialStoreDetailed, (Object)materialStoreVO);
                    list.add(materialStoreVO);
                });
            }
            ServletOutputStream outputStream = response.getOutputStream();
            ExportParams params = new ExportParams("\u5e93\u5b58\u660e\u7ec6\u67e5\u8be2\u62a5\u8868", "\u5e93\u5b58\u660e\u7ec6\u67e5\u8be2\u62a5\u8868\u9875\u7b7e", ExcelType.XSSF);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, MaterialStoreDetailedVO.class, list);
            String fileName = String.format("\u5e93\u5b58\u660e\u7ec6\u67e5\u8be2\u62a5\u8868%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    private void setResponseHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
    }
}

