/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.materialstoresetting.web.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Department;
import com.els.base.company.enums.DepartmentTypeEnum;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.materialstoresetting.entity.MaterialStoreSetting;
import com.els.base.materialstoresetting.entity.MaterialStoreSettingExample;
import com.els.base.materialstoresetting.enums.StoreSettingStoreTypeEnum;
import com.els.base.materialstoresetting.service.MaterialStoreSettingService;
import com.els.base.materialstoresetting.web.vo.AddMaterialStoreSettingVO;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4ed3\u5e93\u8868"})
@Controller
@RequestMapping(value={"materialStoreSetting"})
public class MaterialStoreSettingController {
    @Resource
    protected MaterialStoreSettingService materialStoreSettingService;
    @Resource
    private DepartmentService departmentService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4ed3\u5e93\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody @Validated(value={AddMaterialStoreSettingVO.CreateValidator.class}) AddMaterialStoreSettingVO materialStoreSettingVO) {
        MaterialStoreSetting materialStoreSetting = new MaterialStoreSetting();
        BeanUtils.copyProperties((Object)materialStoreSettingVO, (Object)materialStoreSetting);
        materialStoreSetting.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        materialStoreSetting.setCreateTime(new Date());
        materialStoreSetting.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        materialStoreSetting.setUpdateTime(new Date());
        this.materialStoreSettingService.addObj(materialStoreSetting);
        return ResponseResult.success((Object)materialStoreSetting.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4ed3\u5e93\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody @Validated(value={AddMaterialStoreSettingVO.UpdateValidator.class}) AddMaterialStoreSettingVO materialStoreSettingVO) {
        MaterialStoreSetting materialStoreSetting = new MaterialStoreSetting();
        BeanUtils.copyProperties((Object)materialStoreSettingVO, (Object)materialStoreSetting);
        materialStoreSetting.setUpdateTime(new Date());
        this.materialStoreSettingService.modifyObj(materialStoreSetting);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4ed3\u5e93\u4fe1\u606f\u8868")
    @RequestMapping(value={"service/queryById"})
    @ResponseBody
    public ResponseResult<MaterialStoreSetting> queryById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        return ResponseResult.success((Object)this.materialStoreSettingService.queryObjById(id));
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4ed3\u5e93\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.materialStoreSettingService.deleteByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4ed3\u5e93\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialStoreSetting", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialStoreSetting>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialStoreSettingExample example = new MaterialStoreSettingExample();
        example.setPageView((PageView<MaterialStoreSetting>)new PageView(pageNo, pageSize));
        List ids = CompanyUtils.findByDepartmentTypeReturnList();
        if (CollectionUtil.isEmpty((Collection)ids)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        List parts = Lists.partition((List)ids, (int)1000);
        parts.stream().forEach(ls -> {
            MaterialStoreSettingExample.Criteria criteria = example.createCriteria();
            criteria.andInstitutionIdIn(ids);
            example.or(criteria);
        });
        MaterialStoreSettingExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialStoreSettingService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u6839\u636e\u90e8\u95e8id\u67e5\u8be2\u5e93\u5b58\u5730\u70b9")
    @RequestMapping(value={"service/findByDeparment"})
    @ResponseBody
    public ResponseResult<List<MaterialStoreSetting>> findByDeparment(@RequestParam(required=false) String departmentId) {
        Assert.isNotBlank((String)departmentId, (String)"departmentId\u4e0d\u80fd\u4e3a\u7a7a");
        MaterialStoreSettingExample example = new MaterialStoreSettingExample();
        example.or().andDepartmentIdEqualTo(departmentId);
        List list = this.materialStoreSettingService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)list);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4ed3\u5e93\u8868-\u5e26\u8d26\u5957\u5206\u9875\u529f\u80fd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialStoreSetting", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageToAccountSet"})
    @ResponseBody
    public ResponseResult<PageView<MaterialStoreSetting>> findByPageToAccountSet(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialStoreSettingExample example = new MaterialStoreSettingExample();
        example.setPageView((PageView<MaterialStoreSetting>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List list = CompanyUtils.getDepartmentIds(null);
        ArrayList ids = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        list.forEach(dto -> ids.addAll(dto.getIds()));
        List parts = Lists.partition(ids, (int)1000);
        parts.stream().forEach(ls -> {
            MaterialStoreSettingExample.Criteria criteria = example.createCriteria();
            criteria.andDepartmentIdIn((List)ls);
            example.or(criteria);
        });
        PageView pageData = this.materialStoreSettingService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u6839\u636e\u7528\u6237\u67e5\u627e\u5bf9\u5e94\u7684\u90e8\u95e8\u5e93\u5b58\u5730\u5740")
    @RequestMapping(value={"service/getLists"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated
    public ResponseResult<List<MaterialStoreSetting>> getLists() {
        String userId = SpringSecurityUtils.getLoginUserId();
        List<MaterialStoreSetting> result = this.materialStoreSettingService.getLists(userId);
        return ResponseResult.success(result);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u672c\u7528\u6237\u76f8\u5173\u5e93\u5b58\u7684\u516c\u53f8\u6709\u4ed3\u5e93\u548c\u6240\u6709\u90e8\u95e8\u7684\u79c1\u6709\u5e93")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialStoreSetting", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByDepartmentInfo"})
    @ResponseBody
    public ResponseResult<PageView<MaterialStoreSetting>> findByDepartmentInfo(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        List list = CompanyUtils.queryDepartmentsOfUser();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        MaterialStoreSettingExample example = new MaterialStoreSettingExample();
        example.setPageView((PageView<MaterialStoreSetting>)new PageView(pageNo, pageSize));
        List ids = list.stream().map(Department::getId).collect(Collectors.toList());
        List parts = Lists.partition(ids, (int)1000);
        parts.stream().forEach(ls -> {
            MaterialStoreSettingExample.Criteria criteria = example.createCriteria();
            criteria.andDepartmentIdIn((List)ls);
            example.or(criteria);
        });
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialStoreSettingService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4ed3\u5e93\u8868-\u5e26\u8d26\u5957\u5206\u9875\u529f\u80fd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialStoreSetting", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageToAccountSetInfo"})
    @ResponseBody
    public ResponseResult<PageView<MaterialStoreSetting>> findByPageToAccountSetInfo(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ArrayList<String> departmentType = new ArrayList<String>();
        departmentType.add(DepartmentTypeEnum.IN_THE_ORGANIZATION.getCode());
        List departments = CompanyUtils.getDepartmentByType(departmentType);
        if (CollectionUtil.isEmpty((Collection)departments)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        List ids = departments.stream().map(Department::getId).collect(Collectors.toList());
        MaterialStoreSettingExample example = new MaterialStoreSettingExample();
        example.setPageView((PageView<MaterialStoreSetting>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        example.createCriteria().andInstitutionIdIn(ids);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialStoreSettingService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u975e\u81ea\u5df1\u6240\u5c5e\u4ed3\u5e93\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialStoreSetting", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/searchNotBelongToStoreInfo"})
    @ResponseBody
    public ResponseResult<PageView<MaterialStoreSetting>> searchNotBelongToStoreInfo(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialStoreSettingExample example = new MaterialStoreSettingExample();
        example.setPageView((PageView<MaterialStoreSetting>)new PageView(pageNo, pageSize));
        MaterialStoreSettingExample.Criteria criteria = example.createCriteria();
        criteria.andStoreTypeEqualTo(StoreSettingStoreTypeEnum.SHARE_STORE.getCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.materialStoreSettingService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

