CREATE TABLE "T_MATERIAL_STORE_DETAILED"
(
    "ID"                             NVARCHAR2(32) NOT NULL,
    "STORE_ID"                     NVARCHAR2(32),
    "STORE_NAME"                  NVARCHAR2(255),
    "MATERIAL_CODE"                  NVARCHAR2(255),
    "DESCRIPTION"                  NVARCHAR2(255),
    "BRAND_NAME"                    NVARCHAR2(255),
    "MATERIAL_COLOUR"                  NVARCHAR2(255),
    "MATERIAL_SPECIFICATION"                  NVARCHAR2(255),
    "BUSINESS_TYPE"                  NVARCHAR2(255),
    "BUSINESS_ID"                  NVARCHAR2(255),
    "ORIGINAL_NUMBER"                  NUMBER(7,0) DEFAULT 0,
    "UPDATE_NUMBER"                  NUMBER(7,0) DEFAULT 0,
    "OPERATION_NUMBER"                  NUMBER(7,0) DEFAULT 0,
    "TOTAL_GROUPID"                  NVARCHAR2(255),
    "TOTAL_GROUP_NAME"                  NVARCHAR2(255),
    "ACCOUNT_SET_ID"                  NVARCHAR2(255),
    "ACCOUNT_SET_NAME"                  NVARCHAR2(255),
    "ACCOUNT_CODE"                  NVARCHAR2(255),
    "INSTITUTIONS_ID"                  NVARCHAR2(255),
    "INSTITUTIONS_NAME"                  NVARCHAR2(255),
    "IN_THE_ORGANIZATION_ID"                  NVARCHAR2(255),
    "IN_THE_ORGANIZATION_NAME"                  NVARCHAR2(255),
    "DEPART_ID"                  NVARCHAR2(255),
    "DEPART_NAME"                  NVARCHAR2(255),
    "CREATE_TIME"                    DATE,
    "UPDATE_TIME"                    DATE,
	PRIMARY KEY("ID")
);


COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."id" IS 'id';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."STORE_ID" IS '仓库id';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."STORE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."MATERIAL_CODE" IS '物料编号';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."DESCRIPTION" IS '物料描述';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."BRAND_NAME" IS '品牌';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."MATERIAL_COLOUR" IS '物料颜色';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."MATERIAL_SPECIFICATION" IS '物料规格';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."BUSINESS_TYPE" IS '业务单据类型';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."BUSINESS_ID" IS '业务单据id';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."ORIGINAL_NUMBER" IS '原有库存数量';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."UPDATE_NUMBER" IS '操作后库存数量';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."OPERATION_NUMBER" IS '操作数量';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."TOTAL_GROUPID" IS '总集团id';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_MATERIAL_STORE_DETAILED"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "T_MATERIAL_STORE_DETAILED" IS '库存明细';
