/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.mail.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.msg.mail.dao.MailRecordMapper;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.msg.mail.entity.MailRecord;
import com.els.base.msg.mail.entity.MailRecordExample;
import com.els.base.msg.mail.enums.MailRecoredSendStatusEnum;
import com.els.base.msg.mail.service.MailAccountService;
import com.els.base.msg.mail.service.MailRecordService;
import com.els.base.msg.mail.utils.SmtpSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMailRecordService")
public class MailRecordServiceImpl
implements MailRecordService {
    @Resource
    protected MailRecordMapper mailRecordMapper;
    @Resource
    protected MailAccountService mailAccountService;

    @CacheEvict(value={"mailRecord"}, allEntries=true)
    public void addObj(MailRecord t) {
        this.mailRecordMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"mailRecord"}, allEntries=true)
    public void addAll(List<MailRecord> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.mailRecordMapper.insertBatch(list);
    }

    @CacheEvict(value={"mailRecord"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mailRecordMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"mailRecord"}, allEntries=true)
    public void deleteByExample(MailRecordExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.mailRecordMapper.deleteByExample(example);
    }

    @CacheEvict(value={"mailRecord"}, allEntries=true)
    public void modifyObj(MailRecord t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.mailRecordMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"mailRecord"}, keyGenerator="redisKeyGenerator")
    public MailRecord queryObjById(String id) {
        return this.mailRecordMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"mailRecord"}, keyGenerator="redisKeyGenerator")
    public List<MailRecord> queryAllObjByExample(MailRecordExample example) {
        return this.mailRecordMapper.selectByExample(example);
    }

    @Cacheable(value={"mailRecord"}, keyGenerator="redisKeyGenerator")
    public PageView<MailRecord> queryObjByPage(MailRecordExample example) {
        PageView<MailRecord> pageView = example.getPageView();
        pageView.setQueryResult(this.mailRecordMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void checkerMailNoSend() {
        MailRecordExample example = new MailRecordExample();
        example.createCriteria().andSendStatusEqualTo(MailRecoredSendStatusEnum.SEND_ERROR.getCode());
        List<MailRecord> mailRecords = this.queryAllObjByExample(example);
        if (CollectionUtil.isEmpty(mailRecords)) {
            return;
        }
        for (MailRecord mailRecord : mailRecords) {
            MailAccount mailAccount = (MailAccount)this.mailAccountService.queryObjById(mailRecord.getMailAccountId());
            if (mailAccount == null) continue;
            try {
                SmtpSendUtils.sendMail(mailAccount, mailRecord.getReceiver(), mailRecord.getReceiver(), mailRecord.getSender(), mailRecord.getSenderMail());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

