/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.mail.utils;

import com.els.base.core.utils.Constant;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.msg.mail.entity.MailRecord;
import com.els.base.msg.mail.enums.MailRecoredSendStatusEnum;
import com.els.base.msg.mail.service.MailRecordService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.encryption.DESUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class SmtpSendUtils {
    public static void sendMail(MailAccount senderMailAccount, String receiveEmailAddress, String receiveName, String subject, String mailContent) throws Exception {
        String smtpHost = senderMailAccount.getStmpServerHost();
        Integer smtpPort = senderMailAccount.getStmpServerPort();
        boolean isSsl = !Constant.NO_INT.equals(senderMailAccount.getStmpServerIsSsl());
        String senderMailAddress = senderMailAccount.getMailAddress();
        String password = senderMailAccount.getPassword();
        password = DESUtils.decrypt((String)password, (String)"tissonco");
        String senderName = senderMailAccount.getUserName();
        MailRecord mailRecord = new MailRecord();
        mailRecord.setMailTheme(subject);
        mailRecord.setMailContent(mailContent);
        mailRecord.setSender(senderName);
        mailRecord.setSenderMail(senderMailAddress);
        mailRecord.setReceiver(receiveName);
        mailRecord.setReceiverMail(receiveEmailAddress);
        mailRecord.setSendStatus(MailRecoredSendStatusEnum.SEND.getCode());
        mailRecord.setMailAccountId(senderMailAccount.getId());
        mailRecord.setCreateTime(new Date());
        mailRecord.setUpdateTime(new Date());
        SmtpSendUtils.operationMailRecoredInfo(mailRecord);
        SmtpSendUtils.sendMail(smtpHost, smtpPort, isSsl, senderMailAddress, password, senderName, receiveEmailAddress, receiveName, subject, mailContent, null, mailRecord);
    }

    private static void operationMailRecoredInfo(MailRecord mailRecord) {
        MailRecordService mailRecordService = (MailRecordService)SpringContextHolder.getOneBean(MailRecordService.class);
        if (StringUtils.isBlank((String)mailRecord.getId())) {
            mailRecordService.addObj(mailRecord);
        } else {
            mailRecordService.modifyObj(mailRecord);
        }
    }

    public static void sendMail(String smtpHost, int smtpPort, boolean isSsl, String senderMailAddress, String password, String senderName, String receiveEmailAddress, String receiveName, String subject, String mailContent, File attachment, MailRecord mailRecord) throws MessagingException, UnsupportedEncodingException {
        Properties properties = new Properties();
        properties.setProperty("mail.debug", "true");
        properties.setProperty("mail.smtp.timeout", "1000");
        properties.setProperty("mail.smtp.port", String.valueOf(smtpPort));
        properties.setProperty("mail.smtp.socketFactory.fallback", "false");
        if (isSsl) {
            properties.setProperty("mail.smtp.auth", "true");
            properties.setProperty("mail.smtp.socketFactory.port", String.valueOf(smtpPort));
            properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(smtpHost);
        sender.setPort(smtpPort);
        sender.setUsername(senderMailAddress);
        sender.setPassword(password);
        sender.setDefaultEncoding("UTF-8");
        sender.setJavaMailProperties(properties);
        MimeMessage message = sender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setFrom(new InternetAddress(senderMailAddress, senderName, "UTF-8"));
        helper.setTo(new InternetAddress(receiveEmailAddress, receiveName, "UTF-8"));
        helper.setSubject(subject);
        helper.setText(mailContent, true);
        if (attachment != null) {
            helper.addAttachment(attachment.getName(), attachment);
        }
        sender.testConnection();
        MailRecord m = new MailRecord();
        m.setId(mailRecord.getId());
        try {
            sender.send(message);
            m.setSendStatus(MailRecoredSendStatusEnum.SEND_SUCCESS.getCode());
        }
        catch (MailException e) {
            e.printStackTrace();
            m.setSendStatus(MailRecoredSendStatusEnum.SEND_ERROR.getCode());
        }
        SmtpSendUtils.operationMailRecoredInfo(m);
    }

    public static void testConnection(MailAccount senderMailAccount) throws Exception {
        String smtpHost = senderMailAccount.getStmpServerHost();
        Integer smtpPort = senderMailAccount.getStmpServerPort();
        boolean isSsl = !Constant.NO_INT.equals(senderMailAccount.getStmpServerIsSsl());
        String senderMailAddress = senderMailAccount.getMailAddress();
        String password = senderMailAccount.getPassword();
        password = DESUtils.decrypt((String)password, (String)"tissonco");
        SmtpSendUtils.testConnection(smtpHost, smtpPort, isSsl, senderMailAddress, password);
    }

    public static void testConnection(String smtpHost, int smtpPort, boolean isSsl, String senderMailAddress, String password) throws MessagingException {
        Properties properties = new Properties();
        properties.setProperty("mail.debug", "true");
        properties.setProperty("mail.smtp.timeout", "1000");
        properties.setProperty("mail.smtp.port", String.valueOf(smtpPort));
        properties.setProperty("mail.smtp.socketFactory.fallback", "false");
        if (isSsl) {
            properties.setProperty("mail.smtp.auth", "true");
            properties.setProperty("mail.smtp.socketFactory.port", String.valueOf(smtpPort));
            properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(smtpHost);
        sender.setPort(smtpPort);
        sender.setUsername(senderMailAddress);
        sender.setPassword(password);
        sender.setDefaultEncoding("UTF-8");
        sender.setJavaMailProperties(properties);
        sender.testConnection();
    }
}

